/***************************************************************************
		       authorbase.cpp  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "authorbase.h"
#include <assert.h>

#define Inherited Table

// Creates new Author
AuthorBase::AuthorBase(Sql *conn):Inherited("author", conn) {
  initNew();
}

AuthorBase::AuthorBase(const char *dbname):Inherited("author", dbname) {
  initNew();
}

void AuthorBase::initNew() {
  AuthorRec *author=new AuthorRec;
  assert(author);
  author->empty();
  author->id.set(newAuthor());
  init(author);
  asprintf(&_where, "where oid=%u", author->id.get()); //??????
}

AuthorBase::AuthorBase(const char *where, Sql *conn):Inherited("author", conn) {
  initWhere(where);
}

AuthorBase::AuthorBase(const char *where, const char *dbname):Inherited("author", dbname) {
	initWhere(where);
}

void AuthorBase::initWhere(const char *where) {
  AuthorRec *author=getAuthor(where);
  if(!author) {
    author=new AuthorRec;
    assert(author);
    author->empty();
  }
  init(author);
  if(where) _where=mystrdup(where);
	else _where=0L;
}

AuthorBase::~AuthorBase() {
  delete _where;
}

const char *AuthorBase::getLastName() {
  return author()->lastname.get();
}

const char *AuthorBase::getFirstName() {
  return author()->firstname.get();
}

const char *AuthorBase::getPseudonym() {
  return author()->pseudonym.get();
}

const char *AuthorBase::getCountry() {
  return author()->country.get();
}

const char *AuthorBase::getBirthday() {
  return author()->born.get();
}

const char *AuthorBase::getDay_of_Death() {
  return author()->died.get();
}

const char *AuthorBase::getMemo() {
  return author()->memo.get();
}

const char *AuthorBase::getModified() {
  return author()->modified.get();
}

const char *AuthorBase::getCreated() {
  return author()->created.get();
}

const unsigned char *AuthorBase::getPicture() {
  return author()->picture.get();
}

long AuthorBase::getPictureLength() {
  return author()->picture.length();
}

void AuthorBase::setLastName(const char *s) {
  author()->lastname.set(s);
  author()->lastname.setChanged();
}

void AuthorBase::setFirstName(const char *s) {
  author()->firstname.set(s);
  author()->firstname.setChanged();
}

void AuthorBase::setPseudonym(const char *s) {
  author()->pseudonym.set(s);
  author()->pseudonym.setChanged();
}

void AuthorBase::setCountry(const char *s) {
  author()->country.set(s);
  author()->country.setChanged();
}

void AuthorBase::setBirthday(const char *d) {
  author()->born.set(d);
  author()->born.setChanged();
}

void AuthorBase::setDay_of_Death(const char *d) {
  author()->died.set(d);
  author()->died.setChanged();
}

void AuthorBase::setMemo(const char *s) {
  author()->memo.set(s);
  author()->memo.setChanged();
}


void AuthorBase::setPicture(const unsigned char *a, long l) {
  author()->picture.set(a, l);
  author()->picture.setChanged();
}

KaspaRec *AuthorBase::invalid() {
  KaspaRec *author=new AuthorRec();
  assert(author);
  author->id.set((Oid)InvalidOid);
	return author;
}

KaspaRec *AuthorBase::read(const char *where) {
  return getAuthor(where);
}

void AuthorBase::write(const char *where, bool block) {
  updateAuthor(author(), where, block);
}

void AuthorBase::del(Oid o) {
	Str s="where author.oid=";
	oid2str(o, &s);
  deleteAuthor(s);
  author()->id.set((Oid)InvalidOid);
  author()->empty();
}

PublTitle *AuthorBase::getPubl() {
  Str s("where publication.oid=publication_author.publicationno and publication_author.authorno=");
  oid2str(author()->id.get(), &s);
  return getPublTitles(s);
}

PartTitle *AuthorBase::getParts() {
  Str s("where part.oid=part_author.partno and part_author.authorno=");
  oid2str(author()->id.get(), &s);
  return getPartTitles(s);
}


AuthorRec *AuthorBase::author() {
  if(!dynamic_cast<AuthorRec*>(rec))
    abort();
  return dynamic_cast<AuthorRec*>(rec);
}


Oid AuthorBase::createNote() {
	Oid o=newNote();
	insertLink(o);
	return o;
}	

Oid AuthorBase::createPubl() {
	Oid o=newPubl();
	newPublAuthor(o, author()->id.get());
	return o;
}

void AuthorBase::insertPubl(Oid o) {
	newPublAuthor(o, author()->id.get());
}
	
void AuthorBase::removePubl(Oid o) {
	Str s="where publicationno=";	oid2str(o, &s);
	s+=" and authorno="; oid2str(author()->id.get(), &s);
	deletePublAuthor(s);
}

void AuthorBase::insertPart(Oid o) {
	newPartAuthor(o, author()->id.get());
}

void AuthorBase::removePart(Oid o) {
	Str s="where part=";	oid2str(o, &s);
	s+=" and author="; 			oid2str(author()->id.get(), &s);
	deletePartAuthor(s);
}
































