/***************************************************************************
                          vigmeup.h  -  description                              
                             -------------------                                         
    begin                : Sun Jun 13 03:59:48 CDT 1999
                                           
    copyright            : (C) 1999 by Sean Melody                         
    email                : vigmeup@c-nix.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef VIGMEUP_H
#define VIGMEUP_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//system includes
#include <sys/types.h>
#include <signal.h>    
#include <unistd.h>
#include <iostream.h>  
// include files for QT
#include <qprinter.h>
#include <qpainter.h>

//old includes
#include <qdialog.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qlined.h>
#include <qscrbar.h>
#include <qpushbt.h>
#include <qtooltip.h>
#include <qlcdnum.h>
#include <kapp.h>
#include <qstring.h>
#include <qfiledlg.h>
#include <kmenubar.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <kapp.h>

// include files for KDE
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include <kfiledialog.h>
// application specific includes

#include "resource.h"


// C system lib
#include <stdlib.h>

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class VigmeupView is
  * created which creates your view.
  */
class VigmeupApp : public KTMainWindow 
{
  Q_OBJECT

public:
  /** construtor */
  VigmeupApp(); 
  /** destructor */
  ~VigmeupApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
//  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  //void initView();
/** sets up the objects in the main window */
void initObjects();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  /** overloaded for Message box on last window exit */
  bool queryExit();


 	bool alarmOff();
	void toggleAlarm ();
	bool vigAlarm;
	bool alarmOn();
	void playMp3(const char *mp3File);
	QString ampProgram;
	QString lastPlayerDir;
	int snoozeLength;
	int childPID;
	

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** open a new application window */
  //void slotFileNewWindow();
  /** generate a new document in the actual view */
  //void slotFileNew();
  /** open a document */
  //void slotFileOpen();
  /** save a document */
  //void slotFileSave();
  /** save a document under a different filename*/
  //void slotFileSaveAs();
  /** close the actual file */
  //void slotFileClose();
  /** print the actual file */
  //void slotFilePrint();
  /** close the current window */
  //void slotFileCloseWindow();
  /** exits the application */
  void slotFileQuit();
  /** put the marked text/object into the clipboard and remove
    *	it from the document */
  //void slotEditCut();
  /** put the marked text/object into the clipboard*/
  //void slotEditCopy();
  /** paste the clipboard into the document*/
  //void slotEditPaste();
  /** toggle the toolbar*/
  //void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);

       	void checkTime ();
	void chooseMp3();
	void snoozeIt();
	void choosePlayer();

private:
/** Old objects that I'm trying to bring up to KDE 1.1.1 */

  QScrollBar *scroll2;
	QScrollBar *scroll1;
	QLCDNumber *lcd1;
	QLCDNumber *lcd2;
	QLCDNumber *lcd3;
	QLineEdit *text2;
	QPushButton *button2;
	QPushButton *button3;
	QLabel *label2;
	QPushButton *button1;
	QLabel *label3;
	QScrollBar *scroll3;
	QLineEdit *text1;
	QTimer *timer1;
	QLabel *label1;
//	QPopupMenu *blank2;
//	QPopupMenu *blank12;
//	QPopupMenu *blank6;

/** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** action_menu contains all items of the menubar entry "Action" */
  QPopupMenu *action_menu;

  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  //VigmeupView *view;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
//  VigmeupDoc *doc;
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  //KToolBar::BarPosition tool_bar_pos;
protected:
signals:
	void changeLcd1(int n);
	void changeLcd2(int n);


};   
 
#endif // VIGMEUP_H
 
 
 
 
 
 
 
 























