#include "moddlgproperties.h"

// QT includes
#include <qcheckbox.h>
#include <qgroupbox.h>

// KDE includes
#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>

ModDlgProperties::ModDlgProperties(QWidget* parent, const char* name) : ConfigModuleBase("Properties", "Dialogs", parent, name)
{
  KConfig* config = kapp->getConfig();
  config->setGroup("DIALOGS");

  fLookupDlgGroupBox = new QGroupBox(i18n("Lookup Dialog"), this, "LookupDlgGroupBox");
  fLookupDlgGroupBox->setGeometry(5, 5, 270, 50);

  fHideLookupDlg = new QCheckBox(i18n("Hide Lookup Dialog after a Lookup"), fLookupDlgGroupBox, "HideLookupDlg");
  fHideLookupDlg->setGeometry(10, 20, 250, 25);

  fHideLookupDlg->setChecked(config->readBoolEntry("HideLookup", false));
}

ModDlgProperties::~ModDlgProperties()
{
}

void ModDlgProperties::saveOptions()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("DIALOGS");
  config->writeEntry("HideLookup", fHideLookupDlg->isChecked());

  config->sync();
}

#include "moddlgproperties.moc"
