/***************************************************************************
                          resource.h  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sun Dec  6 16:24:51 EST 1998
                                           
    copyright            : (C) 1998 by Mike Pilone                         
    email                : mpilone@slac.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef RESSOURCE_H
#define RESSOURCE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlist.h>
#include <qdatetime.h>
#include <qstring.h>

#include <kconfig.h>
#include <kapp.h>

#include "errordialog.h"

///////////////////////////////////////////////////////////////////
// resource.h  -- contains macros used for commands

///////////////////////////////////////////////////////////////////
// Defines to line up the columns in the main view
#define COL_1_LABEL_X_POS 10
#define COL_1_FIELD_X_POS 90
#define COL_2_LABEL_X_POS 230
#define COL_2_FIELD_X_POS 310
#define COL_3_LABEL_X_POS 455
#define COL_3_FIELD_X_POS 530

///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES

///////////////////////////////////////////////////////////////////
// File-menu entries
#define ID_FILE_OPEN                10010
#define ID_FILE_CLOSE               10020
#define ID_FILE_SAVE                10030
#define ID_FILE_QUIT                10040

///////////////////////////////////////////////////////////////////
// Edit menu entries
#define ID_EDIT_PREFS               11010

///////////////////////////////////////////////////////////////////
// Contact menu entries
#define ID_CONTACT_NEW              12010
#define ID_CONTACT_DUPLICATE        12020
#define ID_CONTACT_DELETE           12030

///////////////////////////////////////////////////////////////////
// Lookup menu entries
#define ID_LOOKUP_FIRSTNAME         13010
#define ID_LOOKUP_LASTNAME          13020
#define ID_LOOKUP_TITLE             13030
#define ID_LOOKUP_COMPANY           13040
#define ID_LOOKUP_ADDRESS           13050
#define ID_LOOKUP_CITY              13060
#define ID_LOOKUP_STATE             13070
#define ID_LOOKUP_ZIP               13080
#define ID_LOOKUP_COUNTRY           13090
#define ID_LOOKUP_PHONE             13100
#define ID_LOOKUP_CUSTOM            13110
#define ID_LOOKUP_REFERREDBY        13120
#define ID_LOOKUP_EDITDATE          13130
#define ID_LOOKUP_MERGEDATE         13140
#define ID_LOOKUP_LASTREACH         13150
#define ID_LOOKUP_LASTATTEMPT       13160
#define ID_LOOKUP_LASTMEETING       13170
#define ID_LOOKUP_RECORDCREATOR     13180
#define ID_LOOKUP_CREATEDATE        13190

#define ID_LOOKUP_ADDRESSMENU       13200
#define ID_LOOKUP_PERSONALMENU      13210
#define ID_LOOKUP_DATEMENU          13220
#define ID_LOOKUP_RECORDMENU        13230

///////////////////////////////////////////////////////////////////
// View menu entries
#define ID_VIEW_CONTACT             14010
#define ID_VIEW_GROUP               14020
#define ID_VIEW_FIRST               14030
#define ID_VIEW_PREV                14040
#define ID_VIEW_NEXT                14050
#define ID_VIEW_LAST                14060
#define ID_VIEW_LIST                14070
  
///////////////////////////////////////////////////////////////////
// View->Contact menu entries
#define ID_VIEW_CONTACT_EXTENDED    15010
#define ID_VIEW_CONTACT_NOTES       15020

///////////////////////////////////////////////////////////////////
// View->group menu entries
#define ID_VIEW_GROUP_PERSONAL      16010
#define ID_VIEW_GROUP_BUSINESS      16020
#define ID_VIEW_GROUP_ALL           16030
#define ID_VIEW_GROUP_UNFILED       16040
#define ID_VIEW_GROUP_SEARCHRESULTS 16050

///////////////////////////////////////////////////////////////////
// Toolbar
#define ID_TOOLBAR1_COMBO           17010

///////////////////////////////////////////////////////////////////
// Commands
#define CMD_MOVENEXT           1     // CMD_MOVENEXT
#define CMD_MOVEPREV           2     // CMD_MOVEPREV
#define CMD_MOVELAST           3     // CMD_MOVELAST
#define CMD_MOVEFIRST          4     // CMD_MOVEFIRST

///////////////////////////////////////////////////////////////////
// General application values
#define ID_APP_EXIT                 1000      
#define ID_HELP                     1001

#define ID_SEARCH_RESULTS           4

#define IDS_DEFAULT                 "Ready."
#define IDS_APP_ABOUT               "PeopleSpace\nVersion " VERSION

#define MSG_NO_DB_OPEN              "No database open"
#define MSG_DB_TYPE_READWRITE       "Read/Write"
#define MSG_DB_TYPE_READ            "Read Only"
#define MSG_DB_TYPE_NOTOPEN         ""
#define MSG_NO_CONNECTION           "Not Connected          "
#define MSG_YES_CONNECTION          "Connection Established  "

///////////////////////////////////////////////////////////////////
// This variable will be checked apon exit to see if there is any
// unsaved data that needs to be written
extern bool gUnsavedData;
extern bool gViewedEntryChanged;

///////////////////////////////////////////////////////////////////
// Get the pointer to the error dialog
extern CErrorDialog *gErrorDialog;

//////////////////////////////////////////////////////
// ERROR MACRO 
// This macro allows for the displaying 
// of errors through out the program.
#define ERROR(error_message) gErrorDialog->displayError(error_message);
#define ERROR_FORCE_DISPLAY(error_message) gErrorDialog->displayError(error_message, TRUE);


///////////////////////////////////////////////////////////////////
// MACROS FOR THE CONNECT OF YOUR SIGNALS TO CORRESPONDENT SLOTS 
// IN YOUR MAIN IMPLEMENTATION OF MENUBAR AND TOOLBAR


///////////////////////////////////////////////////////////////////
// MENU CONNECTS
#define CONNECT_CMD(submenu)           connect(submenu, SIGNAL(activated(int)), SLOT(commandCallback(int)))
#define DISCONNECT_CMD(submenu)        disconnect(submenu, SIGNAL(activated(int)), this, SLOT(commandCallback(int)))

///////////////////////////////////////////////////////////////////
// TOOLBAR CONNECT  
#define CONNECT_TOOLBAR(ToolBar)        connect(ToolBar, SIGNAL(clicked(int)), SLOT(commandCallback(int)))


///////////////////////////////////////////////////////////////////
// MACROS FOR GENERATING THE SWITCH CONSTRUCTION OF THE commandCallback(int) METHOD


///////////////////////////////////////////////////////////////////
// Create class member in implementation for commandCallback
#define BEGIN_CMD(class)         void class::commandCallback(int id_){ switch (id_){

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them with their functions
#define ON_CMD(id, cmd_class_function)   case id:cmd_class_function;break;   

/////////////////////////////////////////////////////////////////// 
// End class member in implementation for commandCallback 
#define END_CMD()      }}


///////////////////////////////////////////////////////////////////
// MACROS FOR GENERATING THE SWITCH CONSTRUCTION OF THE statusCallback(int) METHOD

///////////////////////////////////////////////////////////////////
// Create class member in implementation for statusCallback
#define BEGIN_STATUS_MSG(class) void class::statusCallback(int id_){ switch (id_){

///////////////////////////////////////////////////////////////////
// Create cases for entries and connect them to change statusBar entry
#define ON_STATUS_MSG(id, message)     case id:  slotStatusHelpMsg(message);break;
 
///////////////////////////////////////////////////////////////////
// End class member in implementation for statusCallback
#define END_STATUS_MSG()         default: slotStatusMsg(IDS_DEFAULT); }}

/** Used to convert things from one form to another
 */
class Convert
{
public:
  Convert();
  ~Convert();

  static QDate stringToDate(QString date)
    {
      QString day, month, year;
      QDate dateDate;
      
      //cout << "Date: " << date << endl;
      
      month = date.left(2);
      date = date.remove(0, 3);
      day = date.left(2);               
      year = date.right(4);
      
      //cout << "Month: " << month << " Year: " << year << " Day: " << day << endl;
      
      dateDate.setYMD(year.toInt(), month.toInt(), day.toInt());
      
      return dateDate;
    };

  static QString dateToString(QDate date)
    {
      QString dateString = "";
      char temp[10];
      
      //cout << "Month: " << date.month() << endl;
      
      sprintf(temp, "%d", date.month());
      if (date.month() < 10)
	{
	  dateString = "0";
	}
      dateString.append(temp);   
      
      dateString += "/";
      
      sprintf(temp, "%d", date.day());
      if (date.day() < 10)
	{
	  dateString += "0";
	}
      dateString.append(temp);
      
      dateString += "/";
      
      sprintf(temp, "%d", date.year());
      dateString.append(temp);
      
      return dateString;
    } ;                       
};

#endif // RESOURCE_H









