// Local includes
#include "lookupdialog.h"
#include "databaseresource.h"
#include "resource.h"

// QT includes
#include <qlineedit.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qdatetime.h>

// KDE includes
#include <kdatepik.h>
#include <kapp.h>
#include <klocale.h>

LookupDialog::LookupDialog(QWidget* parent, const char* name) : QDialog(NULL, name, false)
{
  setGeometry(300, 300, 300, 275);

  fFieldGroupBox = new QGroupBox(i18n("Field Name"), this, "FieldGroupBox");
  fFieldGroupBox->setGeometry(5, 5, 290, 55);

  fFieldCombo = new QComboBox(fFieldGroupBox, "FieldCombo");
  fFieldCombo->setGeometry(10, 20, 265, 25);
  fFieldCombo->insertItem(i18n("First Name"), combo_firstname);
  fFieldCombo->insertItem(i18n("Last Name"), combo_lastname);
  fFieldCombo->insertItem(i18n("Title"), combo_title);
  fFieldCombo->insertItem(i18n("Company"), combo_company);
  fFieldCombo->insertItem(i18n("Address"), combo_address);
  fFieldCombo->insertItem(i18n("City"), combo_city);
  fFieldCombo->insertItem(i18n("State"), combo_state);
  fFieldCombo->insertItem(i18n("Zip"), combo_zip);
  fFieldCombo->insertItem(i18n("Country"), combo_country);
  fFieldCombo->insertItem(i18n("Phone"), combo_phone);
  fFieldCombo->insertItem(i18n("Custom"), combo_custom);
  fFieldCombo->insertItem(i18n("Referred By"), combo_referredby);
  fFieldCombo->insertItem(i18n("Record Creator"), combo_recordcreator);
  fFieldCombo->insertItem(i18n("Edit Date"), combo_editdate);
  fFieldCombo->insertItem(i18n("Merge Date"), combo_mergedate);
  fFieldCombo->insertItem(i18n("Last Reach"), combo_lastreach);
  fFieldCombo->insertItem(i18n("Last Attempt"), combo_lastattempt);
  fFieldCombo->insertItem(i18n("Last Meeting"), combo_lastmeeting);
  fFieldCombo->insertItem(i18n("Create Date"), combo_createdate);
  connect(fFieldCombo, SIGNAL(activated(int) ), this, SLOT( slotFieldComboChanged(int) ));

  fParamGroupBox = new QGroupBox(i18n("Containing..."), this, "ParamGroupBox");
  fParamGroupBox->setGeometry(5, 60, 290, 160);
  
  fParam1 = new QLineEdit(fParamGroupBox, "Param1");
  fParam1->setGeometry(10, 20, 265, 20);
 
  fDatePickerGroupBox = new QGroupBox(i18n("Matching..."), this, "DatePickerGroupBox");
  fDatePickerGroupBox->setGeometry(5, 60, 290, 160);
  
  fDatePicker = new KDatePicker(fDatePickerGroupBox);
  fDatePicker->setGeometry(10, 20, 265, 130);
  connect(fDatePicker, SIGNAL( dateSelected(QDate) ), this, SLOT( slotDateSelected( QDate )));
  fSelectedDate = QDate::currentDate();

  fLookupButton = new QPushButton(i18n("&Lookup"), this, "LookupButton");
  fLookupButton->setGeometry(55, this->height()-40, 75, 30);
  connect(fLookupButton, SIGNAL( clicked() ), this, SLOT( slotLookupButtonClicked() ));

  fCancelButton = new QPushButton(i18n("&Cancel"), this, "CancelButton");
  fCancelButton->setGeometry(170, this->height()-40, 75, 30);
  connect(fCancelButton, SIGNAL( clicked() ), this, SLOT( slotCancelButtonClicked() ));
}

LookupDialog::~LookupDialog()
{
}

void LookupDialog::setLookupField(int comboId)
{
  disconnect(fFieldCombo, SIGNAL(activated(int) ), this, SLOT( slotFieldComboChanged(int) ));
  fFieldCombo->setCurrentItem(comboId);
  connect(fFieldCombo, SIGNAL(activated(int) ), this, SLOT( slotFieldComboChanged(int) ));

  fDatePickerGroupBox->hide();
  fParamGroupBox->hide();

  switch(comboId)
    {
    case combo_firstname:
    case combo_lastname:
    case combo_title: 
    case combo_company: 
    case combo_address: 
    case combo_city: 
    case combo_state: 			 
    case combo_zip: 
    case combo_country: 
    case combo_phone: 
    case combo_custom: 
    case combo_referredby: 
    case combo_recordcreator:
      fParamGroupBox->show();
      break;
      
    case combo_editdate: 
    case combo_mergedate: 
    case combo_lastreach: 
    case combo_lastattempt: 
    case combo_lastmeeting: 
    case combo_createdate:
      fDatePickerGroupBox->show();
      break;
    }
}

///////////////////////////////////////////////
// SLOTS

void LookupDialog::slotFieldComboChanged(int id)
{
  setLookupField(id);
}

void LookupDialog::slotLookupButtonClicked()
{
  KConfig* config = kapp->getConfig();

  QString param1 = "", param2 = "";

  config->setGroup("DIALOGS");
  if (config->readBoolEntry("HideLookup", true))
    this->hide();

  switch(fFieldCombo->currentItem())
    {
    case combo_firstname:
      param1 = fParam1->text();
      emit lookupButtonClicked(field_firstname, param1, param2);
      break;
    case combo_lastname:
      param1 = fParam1->text();
      emit lookupButtonClicked(field_lastname, param1, param2);
      break;
    case combo_title: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_title, param1, param2);
      break;
    case combo_company:  
      param1 = fParam1->text();
      emit lookupButtonClicked(field_company , param1, param2);
      break;
    case combo_address: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_address , param1, param2);
      break;
    case combo_city: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_city , param1, param2);
      break;
    case combo_state: 
      param1 = fParam1->text();	
      emit lookupButtonClicked(field_state , param1, param2);
      break;
    case combo_zip: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_zip , param1, param2);
      break;
    case combo_country: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_country , param1, param2);
      break;
    case combo_phone: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_phone1 , param1, param2);
      break;
    case combo_custom: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_custom1 , param1, param2);
      break;
    case combo_referredby: 
      param1 = fParam1->text();
      emit lookupButtonClicked(field_referredby , param1, param2);
      break;
    case combo_recordcreator:
      param1 = fParam1->text();
      emit lookupButtonClicked(field_recordcreator , param1, param2);
      break;
    case combo_editdate: 
      param1 = Convert::dateToString(fSelectedDate);
      emit lookupButtonClicked(field_editdate , param1, param2);
      break;
    case combo_mergedate: 
      param1 = Convert::dateToString(fSelectedDate);
      emit lookupButtonClicked(field_mergedate , param1, param2);
      break;
    case combo_lastreach: 
      param1 = Convert::dateToString(fSelectedDate);
      emit lookupButtonClicked(field_lastreach , param1, param2);
      break;
    case combo_lastattempt: 
      param1 = Convert::dateToString(fSelectedDate);
      emit lookupButtonClicked(field_lastattempt , param1, param2);
      break;
    case combo_lastmeeting: 
      param1 = Convert::dateToString(fSelectedDate);
      emit lookupButtonClicked(field_lastmeeting , param1, param2);
      break;
    case combo_createdate:
      param1 = Convert::dateToString(fSelectedDate);
      emit lookupButtonClicked(field_createdate , param1, param2);
      break;
    }
}

void LookupDialog::slotCancelButtonClicked()
{
  this->hide();
}

void LookupDialog::slotDateSelected(QDate date)
{
  fSelectedDate = date;
}

#include "lookupdialog.moc"
