#ifndef _ERROR_DIALOG_H_
#define _ERROR_DIALOG_H_

// QT includes
#include <qdialog.h>
#include <qstring.h>
class QMultiLineEdit;
class QPushButton;

class CErrorDialog : public QDialog
{

  Q_OBJECT

public:
  CErrorDialog(QWidget* parent, const char* name);
  ~CErrorDialog();

  /** Writes the error to the error dialog multiline edit filed.
   */
  void displayError(QString errorMessage, bool forceDisplay = FALSE);

protected:
  QMultiLineEdit *fErrorMessageField;

  QPushButton *fCloseButton;

protected slots:
  /** Called when the user presses the close button
   */
  void slotClose();
};

#endif
