#ifndef __CONFIGDIALOG_H_
#define __CONFIGDIALOG_H_

// QT includes
#include <qwidget.h>
#include <qlist.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qsplitter.h>
class QLabel;

// KDE includes
class KTreeList;

// Local includes
#include "configmodulebase.h"

class ConfigDialog : public QDialog
{
  Q_OBJECT

public:
  ConfigDialog(QWidget* parent, const char* name);
  ~ConfigDialog();

protected:
  void resizeEvent(QResizeEvent*);

  /** Initializes the Modules
   */
  void initModules();
  
  /** Initializes the config widget
   */
  void initConfigWidget();

  void addModule(ConfigModuleBase* module);

private:
  /** This is the widget on the right side of the splitter when there is a config
   * section selected
   */
  QWidget* fConfigWidget;
  
  /** This is the widget on the right side of the splitter when there is no 
   * config information to display.
   */
  QWidget* fDefaultWidget;

  QSplitter* fSplitter;

  QPushButton* fOkButton;
  QPushButton* fCancelButton;
  QPushButton* fApplyButton;
  QPushButton* fHelpButton;

  KTreeList* fModuleTree;

  QList<ConfigModuleBase> fModuleList;

  QLabel* fPSLogo;
  QLabel* fModuleTitle;

  /** Hides all the modules, including the PSLogo
   */
  void hideAllModules();

  /** Sets the currently displayed module
   */
  void setDisplayedModule(ConfigModuleBase*);

public slots:
  void slotModuleTreeSingleClicked(int);
  void slotModuleTreeDoubleClicked(int);

  void slotApplyButtonClicked();
  void slotHelpButtonClicked();
  void slotOkButtonClicked();
  void slotCancelButtonClicked();
};

#define DEFAULT_TITLE "PeopleSpace - Preferences"

#endif
