/***************************************************************************
                          usrmodem.h  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef USRMODEM_H
#define USRMODEM_H

#include <stdio.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qlist.h>
#include <modemconnector.h>

struct USRMemHdr {
  unsigned char  mIndex;
  unsigned char  mType;
  unsigned char  mPages;
  char           Filler[5];
  char           mSender[20];
  unsigned char  mPrevPage;
  unsigned char  mPrevAddr1;
  unsigned char  mPrevAddr2;
  unsigned char  mNextPage;
  unsigned char  mNextAddr1;
  unsigned char  mNextAddr2;
}; /* 34 byte */

enum MessageType {unknown, Fax, Voice, Data};
enum MessageAttrib {Atunknown, UnreleasedUnchecked, UnreleasedChecked, ReleasedChecked};

struct ModemGeneralInfo {
	int memSize;
	int memUsed;
	int noVoiceMsg;
	int noVoiceUnreleased;
	int noFaxMsg;
	int noFaxUnreleased;
	bool outMsgPresent;
	bool fullMsgPresent;
};

struct ModemMsgInfoStruct {
	int msgIndex;
	enum MessageType msgType;
	int msgSize;
	enum MessageAttrib msgAttribute;
	int msgStatus;
	bool clockValid;
	int msgDay;
	int msgHour;
	int msgMinute;
	QString callerId;
	int msgStartPage;
	unsigned int msgAddress;
};

/** typedef of a list class that stores message inx */
typedef QList<struct ModemMsgInfoStruct> ModemMessageList;

/**This class specialices the
ModemConnector class for the
USR Modem. It adds specific
functionality.
  *@author Torsten Uhlmann
  */

class USRModem : public ModemConnector
{
	Q_OBJECT

public:
	USRModem(char*, char*, char*);
	~USRModem();
	
	bool initModem();
	bool resetModem();
  bool getFax(int, char*);
  bool getMemory();
  bool getMemoryInfo(struct ModemGeneralInfo& ,ModemMessageList&);
  bool clearMemory();
  bool getFaxFileName(char*);
  bool getVoiceFileName(char*);
  bool getMemoryFileName(char*);
  int  getPagesWritten();

	/** functions for voice messages */
  bool getVoice(int, char*);
  bool playVoiceIntern(int);

  void faxFileName(char*, int);
  void voiceFileName(char*);

	/** set / unset functions which control the modem */
	bool 		setStandaloneMode();
	bool 		unsetStandaloneMode();
	bool 		resetClock();
	bool 		getFaxReception();
	bool 		setFaxReception();
	bool 		unsetFaxReception();
	bool 		getVoiceReception();
	bool 		setVoiceReception();
	bool 		unsetVoiceReception();
	bool 		getControlMonitor();
	bool 		setControlMonitor();
	bool 		unsetControlMonitor();
	bool 		setSetupRings(int);
	int  		getSetupRings();
	bool		setVoiceDuration(int);
	int			getVoiceDuration();
 	QString *getSetupFaxId();
 	bool 		setSetupFaxId(QString);
	bool 		commitSetup();

private:
  bool ExtractMessage(int, MessageType);
  int  WritePage(FILE*, unsigned char);
  void deleteMemoryFile();
  void deleteFaxFiles();
  void deleteVoiceFiles();

  char memoryFile[255];
  char faxFile[255];
  char voiceFile[255];
  bool tempFile;
  bool tempVoiceFile;
  int  pagesWritten;
  int  WasDLE;

  /** structures to store modem info internal */
  struct ModemGeneralInfo modemInfo;
};

#endif

























