/***************************************************************************
                          lost_treenode.h  -  description                              
                             -------------------                                         
    begin                : Sat Jun 5 1999                                           
    copyright            : (C) 1999 by jec                         
    email                : cuendet@linkvest.ch                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LOST_TREENODE_H
#define LOST_TREENODE_H

#include <sys/types.h>

#include <qlistview.h>

/**
  *@author jec
  */

class LoSTView;

class LoST_TreeNode : public QListViewItem
{

public:
	enum e_Type { UNKNOWN, DIR, FILES, FILE, SYM_LINK, SKIPPED };

	LoST_TreeNode(LoSTView& parent, const QString& str, e_Type type);
	LoST_TreeNode(QListViewItem* parent, LoSTView& view, const QString& dir, e_Type type);
	~LoST_TreeNode();
	
	void setSymbolicLink(const QString& link);
	
	virtual const char* text(int col) const;
	
	const char* getText(int col);
	void getSizeText(QString& sizeString);
	virtual const QPixmap* pixmap ( int column ) const;
	
	QString getCompletePath();
	const QString& getPath();
	
	e_Type getType() const;
	void setType(e_Type t);
	
	int64_t getSize();
	void setSize(int64_t size);
	void setNeedSizeUpdate(bool val);
	void setNeedSizeUpdateRecurse();
	
	LoST_TreeNode* getParent();
	LoST_TreeNode* getFilesNode();
	void setFilesNode(LoST_TreeNode* node);
	
	LoST_TreeNode* getChildThatMatch(const QString& str);
	LoST_TreeNode* getFileThatMatch(const QString& str);
	
	void removeDir(LoST_TreeNode* node);
	void removeFile(LoST_TreeNode* node);
	
protected:
	virtual const char* key(int column, bool ascending) const;
	
private:

	LoST_TreeNode* filesNode_;

	LoSTView& view_;
	QString myDir_;
	e_Type type_;
	
	QString link_;
	
	int64_t size_;
	bool needSizeUpdate_;
};

#endif









