/***************************************************************************
                          globals.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>
#include "globals.h"
#include <qstring.h>
#include <qlineedit.h>

PixPtr WetterIcon[256];  // Icon fr die Tageswetterlage
PixPtr SmallWetterIcon[256];  // kleines Icon fr die Tageswetterlage

// Einheiten fr Temperatur, Lustfruck, Niederschlag und Wind
char* (TempUnits[CNT_TEMPUNITS]) = {"C","F","R","K"};
char* (PrsUnits[CNT_PRSUNITS]) = {"mB", "hPa","mmHg","inHg","Torr"};
char* (LevelUnits[CNT_LEVELUNITS]) = {"mm","cm","dm","m","l/m","inch"};
char* (WindDirUnits[CNT_WINDDIRUNITS]) = {"","WR"};
char* (WindStrengthUnits[CNT_WINDSTRENGTHUNITS]) = {"m/s","km/h","Bft","mph"};
// Gridskalierungen
float TempScales[CNT_TEMPUNITS] = {5.0, 25.0, 5.0, 5.0};
float PrsScales[CNT_PRSUNITS] = {10.0, 10.0, 10.0};
float LevelScales[CNT_LEVELUNITS] = {10.0, 10.0, 10.0, 1.0, 10.0};

// Gridsnullpunkte
float TempZeros[CNT_TEMPUNITS] = {0.0, 32.0, 0.0, 273.0};
float PrsZeros[CNT_PRSUNITS] = {1000.0, 760.0, 100.0};
float LevelZeros[CNT_LEVELUNITS] = {0.0, 0.0, 0.0, 0.0};

char S[64];
struct GridSettingsType GridDefaults;  // globale Grideinstellungen

int MonTage(int Monat,int Jahr) {
// Anzahl der Tage eines Monats berechnen
   Monat++;
   switch (Monat)  {
      case 1:
      case 3:
      case 5:
      case 7:
      case 8:
      case 10:
      case 12:return 31;
      case 2 : if (Jahr % 400 == 0) return 29;
               else if (Jahr % 100 == 0) return 28;
               else if (Jahr % 4 == 0) return 29;
               else return 28;
      default: return 30;
   }
}

char ___SSSSSSS[10];
char* TimeToStrg(int Time) {

   sprintf(___SSSSSSS,"%02d:%02d",Time/60, Time%60);
   return ___SSSSSSS;
}

char* float2char(float f, int Len, int Nk) {
  sprintf(S,"%*.*f",Len,Nk,f);
  return S;
}

float char2float(char* S) {
QString Strg;
bool ok;
float f;

  Strg=S;
  f=Strg.toFloat(&ok);
  if (ok)
    return f;
  else
    return 0;

}

int checkfloat(const char* S) {
// Prfung ob die Zahl in S eine gltige Gleitpunktzahl ist
// Rckgabe TRUE, wenn ok, FALSE, wenn Fehler
QString Strg;
bool ok;
float f;

  Strg=S;
  f=Strg.toFloat(&ok);
  if (ok)
    return TRUE;
  else
    return FALSE;
}

int SetTempScales(const char *Unit, QWidget *ScaleEdit, QWidget *ZeroEdit) {
int Lauf;
QLineEdit * LE;
char S[20];

  debug ("SetTempScales %s",Unit);
  for (Lauf=0; Lauf<CNT_TEMPUNITS; Lauf++) {
    if (strcmp(Unit, TempUnits[Lauf])==0) {
      if (ScaleEdit!=NULL) {
        LE = (QLineEdit*)ScaleEdit;
        sprintf(S,"%0.1f", TempScales[Lauf]);
        LE->setText(S);

        LE = (QLineEdit*)ZeroEdit;
        sprintf(S,"%0.1f", TempZeros[Lauf]);
        LE->setText(S);
        return TRUE;
      }
    }
  }
  return FALSE;
}

int SetPrsScales(const char *Unit, QWidget *ScaleEdit, QWidget *ZeroEdit) {
int Lauf;
QLineEdit * LE;
char S[20];

  debug ("SetPrsScales %s",Unit);
  for (Lauf=0; Lauf<CNT_PRSUNITS; Lauf++) {
    if (strcmp(Unit, PrsUnits[Lauf])==0) {
      if (ScaleEdit!=NULL) {
        LE = (QLineEdit*)ScaleEdit;
        sprintf(S,"%0.1f", PrsScales[Lauf]);
        LE->setText(S);

        LE = (QLineEdit*)ZeroEdit;
        sprintf(S,"%0.1f", PrsZeros[Lauf]);
        LE->setText(S);
        return TRUE;
      }
    }
  }
  return FALSE;
}

int SetLevelScales(const char *Unit, QWidget *ScaleEdit, QWidget *ZeroEdit) {
int Lauf;
QLineEdit * LE;
char S[20];

  debug ("SetLevelScales %s",Unit);
  for (Lauf=0; Lauf<CNT_LEVELUNITS; Lauf++) {
    if (strcmp(Unit, LevelUnits[Lauf])==0) {
      if (ScaleEdit!=NULL) {
        LE = (QLineEdit*)ScaleEdit;
        sprintf(S,"%0.1f", LevelScales[Lauf]);
        LE->setText(S);

        LE = (QLineEdit*)ZeroEdit;
        sprintf(S,"%0.1f", LevelZeros[Lauf]);
        LE->setText(S);
        return TRUE;
      }
    }
  }
  return FALSE;
}