/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or           *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
                                       
#include <stdio.h>
#include <qfiledlg.h>
#include "mlist.h"
#include "convert.moc"
#include <kfiledialog.h>


Convert::Convert(QWidget *parent, const char *name):QDialog(parent,name,TRUE) {
	this->setCaption(klocale->translate("File conversion..."));
	this->resize(580,300);

	QLabel *From = new QLabel(this,klocale->translate("Convert from version"),this);
	From->adjustSize();
	From->move(20,25);
	Version=new QComboBox(FALSE,this,"version");
	Version->insertItem("stable release 0.91",0);
	Version->resize(80,20);
	Version->move(200,20);
	Version->insertItem("Snapshots older than 980907",1);	
	Version->insertItem("Snapshot version 980909",2);

	Version->adjustSize();

	QPushButton *Filechange = new QPushButton(klocale->translate("Filename..."),this);
	Filechange->resize(214,20);Filechange->move(31,135);
	Filename = new QLineEdit(this,"filename");
	Filename->resize(214,25);Filename->move(31,154);
	QLabel *TargetL = new QLabel(this,klocale->translate("Target filename..."),this);
	TargetL->resize(214,20);
	TargetL->move(260,135);
	
	Target = new QLineEdit(this,"target");
	Target->resize(214,25);Target->move(260,154);
	
	QPushButton *OK = new QPushButton(klocale->translate("Ok"),this);
	QPushButton *Cancel = new QPushButton(klocale->translate("Cancel"),this);
	OK->move(20,255);
	Cancel->move(300,255);

	connect(OK,SIGNAL(clicked()),SLOT(slotOKPressed()));
	connect(Cancel,SIGNAL(clicked()),SLOT(slotCancelPressed()));
	connect(Filechange,SIGNAL(clicked()),SLOT(slotFileChange()));
	connect(Filename,SIGNAL(textChanged(const char *)),SLOT(slotTextChanged()));
};

void Convert::slotFileChange() {
	QString s=QFileDialog::getOpenFileName(0,"*.kvl",this);
	Filename->setText(s);
	};
void Convert::slotTextChanged() {
	char Dummy[255];
	strcpy(Dummy,"NEW");

	Target->setText(Filename->text());
	};
void Convert::slotOKPressed() {
	  FILE *Test;
                if ((Test=fopen(Filename->text(),"rb"))==NULL) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The file You selected does not exist."));return;};     	
	if (strlen(Filename->text())==0) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("No filename given."));return;};
	if (strcmp(Filename->text(),Target->text()) == 0) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("Choose an other target."));return;};

QApplication::setOverrideCursor(waitCursor);


	char File[255];
	char TargetC[255];
	strcpy(File,Filename->text());
	strcpy(TargetC,Target->text());


if (Version->currentItem()==0) 	Converter(File,TargetC);
if (Version->currentItem()==1)  Convert980907(File,TargetC);
if (Version->currentItem()==2)  Convert980909(File,TargetC);

QApplication::restoreOverrideCursor();
QMessageBox::information(this,klocale->translate("Status"),klocale->translate("Convert succesfully finished."));
	
	accept();
	};
void Convert::slotCancelPressed() {
	reject();
	};


	
