/*
 *   kvideolist - a database for home-movie collections
 *   Copyright (C) 1998  Holger Hetterich
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qtooltip.h>
#include <kfiledialog.h>
#include <stdio.h>
#include <qfiledlg.h>
#include "moviedialog.moc"
#include "mlist.h"

Pointer DieserAnker;


MovieDialog::MovieDialog(QWidget *parent, const char *name):QDialog(parent,name,TRUE)  {
        
	// QDialog *Add;
	
	FETCHYEAR=0;
	FETCHPRODUCER=0;
	FETCHDIRECTOR=0;
	FETCHGENRES=0;
	FETCHCOUNTRY=0;
	FETCHCAST=0;	
	ASKONLINE=0;

       this->setCaption(klocale->translate("Entering movie data"));
       
 
	this->resize(700,580);
QLabel *OriginalNameL= new QLabel(this,klocale->translate("Original Title:"),this);
OriginalNameL->move(30,30);
      
	OriginalName= new QLineEdit(this,"OrigName");
	OriginalName->move(130,30);
	OriginalName->resize(200,20);

	PreTaped= new QCheckBox(klocale->translate("Pretaped"),this,"bought");
	PreTaped->move(550,300);


	 
	SubClass = new QComboBox(this,"SubClass");
	SubClass->move(130,370);
	SubClass->resize(250,20);

	


 
        PlayNumber = new QComboBox(FALSE,this,"PlayNumber");
	PlayNumber->insertItem(klocale->translate("first"),0);
	PlayNumber->insertItem(klocale->translate("second"),1);
	PlayNumber->insertItem(klocale->translate("third"),2);
	PlayNumber->insertItem(klocale->translate("fourth"),3);
	PlayNumber->insertItem(klocale->translate("fith"),4);
	PlayNumber->insertItem(klocale->translate("sixt"),5);
	PlayNumber->insertItem(klocale->translate("seventh"),6);
	PlayNumber->insertItem(klocale->translate("eights"),7);
	PlayNumber->insertItem(klocale->translate("ninght"),8);
	PlayNumber->insertItem(klocale->translate("tenth"),9);
QToolTip::add(PlayNumber,klocale->translate("This is the position where the movie\n begins on the tape."));
	PlayNumber->resize(100,20);
	OnTapeHours = new QLineEdit(this,"onthours");
	OnTapeMinutes = new QLineEdit(this,"ontminutes");
QToolTip::add(OnTapeHours,klocale->translate("If You have a time-counter, \n enter here when the movie begins\n on the tape."));
QToolTip::add(OnTapeMinutes,klocale->translate("If You have a time-counter, \n enter here when the movie begins\n on the tape."));

QLabel *PlayNumberL = new QLabel(this,klocale->translate("It is the"),this);
QLabel *PlayNumberL2= new QLabel(this,klocale->translate("movie on the tape."),this);
QLabel *OntL1 = new QLabel(this,klocale->translate("This movie begins at"),this);
QLabel *OntLHours = new QLabel(this,klocale->translate("Hours"),this);
QLabel *OntLMinutes = new QLabel(this,klocale->translate("Minutes"),this);
OntLHours->move(490,178);
OntLMinutes->move(550,178);
OntL1->move(350,208);
OntL1->resize(140,30);
OnTapeHours->resize(50,20);
OnTapeMinutes->resize(40,30);
OnTapeHours->move(490,208);
OnTapeMinutes->move(550,208);
OnTapeMinutes->resize(50,20);
PlayNumberL->move(350,248);
PlayNumberL->resize(75,30);
PlayNumber->move(428,252);
PlayNumberL2->move(530,248);
PlayNumberL2->resize(200,30);
	Genre1 = new QComboBox(FALSE,this,"read-only combo");
	Genre2 = new QComboBox(FALSE,this,"read-only 2");
	Genre1->move(350,80);
        Genre2->move(350,130);
QToolTip::add(Genre1,klocale->translate("Categorize Your movie with the Genre \n entrys. Choose one or two. If Your\n movie fits exactly in one category, \n select 'Nothing' on the second entry."));

QToolTip::add(Genre2,klocale->translate("Categorize Your movie with the Genre \n entrys. Choose one or two. IfYour\n movie fits exactly in one category, \n select 'Nothing' on the second entry."));



	Name = new QLineEdit(this,"name");
QToolTip::add(Name,klocale->translate("Enter the Name of the movie here.\n If it is a sequel, You may type something like\n (2), 2, II after the name to indicate\n which part it is."));

	Producer = new QLineEdit(this,"producer");
QToolTip::add(Producer,klocale->translate("Enter the producer here. You may enter more than one,\n type a ; between them."));

	Director= new QLineEdit(this,"director");
QToolTip::add(Director,klocale->translate("Enter the director here. You may enter more than one,\n tape a ; between them."));

	Cast1 = new QLineEdit(this,"cast1");

QToolTip::add(Cast1,klocale->translate("Enter the main cast here."));

	Cast2 = new QLineEdit(this,"cast2");
QToolTip::add(Cast2,klocale->translate("Enter the main cast here."));
	Cast3 = new QLineEdit(this,"cast3");
QToolTip::add(Cast3,klocale->translate("Enter the main cast here."));
	Cast4 = new QLineEdit(this,"cast4");
QToolTip::add(Cast4,klocale->translate("Enter the main cast here."));
	Cast5 = new QLineEdit(this,"cast5");
        
QToolTip::add(Cast5,klocale->translate("Enter the main cast here."));

      
	Hours = new QLineEdit(this,"hours");
	Minutes = new QLineEdit(this,"minutes");
        Hours->move(240+80-20-30,330+15);
	Minutes->move(300+80-20-30,330+15);
	Hours->resize(50,20);
	Minutes->resize(50,20);
QToolTip::add(Hours,klocale->translate("Enter the runtime of the movie here."));
QToolTip::add(Minutes,klocale->translate("Enter the runtime of the movie here."));
 





Rating= new QLineEdit(this,"rating");
Rating->move(300-30,290);
Rating->resize(50,20);
QToolTip::add(Rating,klocale->translate("Enter a personal ranking between 1 and 10.\n (1 = worst, 10 = best)."));
LP = new QCheckBox(klocale->translate("Longplay"),this,"lp");
LP->move(440,290-20+5);
LP->resize(90,20);


QToolTip::add(LP,klocale->translate("Enable this if the movie is recorded in Longplay on the Tape."));

Stereo= new QCheckBox(klocale->translate("Stereo"),this,"st");
Stereo->move(440,320-20);
QToolTip::add(Stereo,klocale->translate("Enable this if the movie is recorded in Stereo. Otherwise it's Mono."));

Surround=new QCheckBox(klocale->translate("Surround Sound"),this,"SS");
Surround->move(440,350-20);
Surround->resize(170,20);
QToolTip::add(Surround,klocale->translate("Enable this if the movie is recorded in Surround-Sound format."));


Color= new QCheckBox(klocale->translate("Color"),this,"Co");
Color->move(440,380-20);
QToolTip::add(Color,klocale->translate("Enable this if the movie is recorded in Color. Otherwise it's B/W."));


MovieText= new QCheckBox(klocale->translate("MovieText"),this,"MV");
MovieText->move(550,290-20);

QToolTip::add(MovieText,klocale->translate("Enable this if the movie supports MovieText."));


QLabel *CommentsL = new QLabel(this,klocale->translate("Comments:"),this);
QLabel *LinkURLL = new QLabel(this,klocale->translate("External Data-URL:"),this);
QLabel *MadeInL = new QLabel(this,klocale->translate("Made in:"),this);
MadeInL->move(350,10);
MadeInL->resize(130+205+75,20);
MadeIn = new QLineEdit(this,"MadeIn");
MadeIn->move(410,10);
MadeIn->resize(200,20);

QToolTip::add(MadeIn,klocale->translate("Enter here where the movie was made."));


CommentsL->move(10,400);
LinkURLL->move(10,450);
LinkURLL->resize(150,25);
Comments= new QMultiLineEdit(this,"Comments");
Comments->resize(400,45);
Comments->move(200,400);
QToolTip::add(Comments,klocale->translate("Enter here some personal notes."));


LinkURL= new QLineEdit(this,"URL");
LinkURL->resize(200,20);
LinkURL->move(200,450);
QToolTip::add(LinkURL,klocale->translate("You can link a URL with every movie.\n A URL can be any kind of data\n at any place. For example You could \n enter here Your favourite WWW-Page \n about the movie, or a sound file, or a picture."));

AutoShow= new QCheckBox(klocale->translate("Show URL automatically if movie is selected"),this);
AutoShow->move(200,473);
AutoShow->resize(400,20);
QToolTip::add(AutoShow,klocale->translate("Enable this if KVideolist should\n few the linked-URL automatically\n if the movie is selected \n in the main-window."));


        QLabel *RatingL = new QLabel(this,klocale->translate("Ranking:"),this);	 
	QLabel *HoursL= new QLabel(Hours,klocale->translate("Hours"),this);
	QLabel *MinutesL = new QLabel(Minutes,klocale->translate("Minutes"),this);
        QLabel *Time= new QLabel(this,klocale->translate("Playtime:"),this);
	Time->move(190,330+15-2);
	RatingL->move(190,288);RatingL->adjustSize();
	HoursL->move(240+80-20-30,300+15);
	MinutesL->resize(60,30);
	MinutesL->move(300+80-20-30,300+15);
        Time->resize(70,20); 
        QLabel *NameL = new QLabel(Name,klocale->translate("Title:"),this);
        QLabel *ProducerL = new QLabel(Producer,klocale->translate("Producer:"),this);
	QLabel *DirectorL = new QLabel(Director,klocale->translate("Director:"),this);

	QLabel *Category1= new QLabel(Genre1,klocale->translate("Category"),this);
	Category1->hide();
	DirectorL->move(350,50);
	DirectorL->resize(55,25);
	Director->move(410,50);
	Category1->resize(100,20);
	QLabel *Category2= new QLabel(Genre2,klocale->translate("... or two ..."),this);
        Category2->move(350,120);
	Category2->hide();
	Number = new QLineEdit(this,"nr");
        Number->move(130,330);	
QToolTip::add(Number,klocale->translate("Enter here the Tape number, \n where the movie is stored."));

        Number->resize(50,20);	
	QLabel *Cast1L = new QLabel(Cast1,klocale->translate("Cast 1:"),this);
	QLabel *Cast2L = new QLabel(Cast2,klocale->translate("Cast 2:"),this);
	QLabel *Cast3L = new QLabel(Cast3,klocale->translate("Cast 3:"),this);
	QLabel *Cast4L = new QLabel(Cast4,klocale->translate("Cast 4:"),this);
	QLabel *Cast5L = new QLabel(Cast5,klocale->translate("Cast 5:"),this);
	
// QLabel *PlayTimeL = new QLabel(PlayTime,klocale->translate("Play time:"),this);


	Age = new QLineEdit(this,"age");
	QLabel *AgeL = new QLabel(Age,klocale->translate("release-date:"),this);
	QLabel *NumberL = new QLabel(Number,klocale->translate("Tape Nr:"),this);

QToolTip::add(Age,klocale->translate("Enter here the year, when\n the movie was first released."));

	NumberL->move(30,330);
	QLabel *SubClassL= new QLabel(this,klocale->translate("Subclass:"),this);
	SubClassL->move(30,365);

	Age->move(130,290);
        Category1->move(455,85);
        AgeL->move(30,288);
	Age->resize(50,20);
	NameL->move(30,10);
	ProducerL->move(30,50);
	Cast1L->move(30,88);
	Cast2L->move(30,128);
	Cast3L->move(30,168);
	Cast4L->move(30,208);
	Cast5L->move(30,248);
IMDB = new QPushButton( klocale->translate("Autofill!"),this);
IMDB->hide();
QPushButton *Select = new QPushButton(klocale->translate("Select file..."),this);
QToolTip::add(Select,klocale->translate("If Your linked-URL is a file\n on Your local harddisk,\n You can choose it here."));


QPushButton *Show = new QPushButton(klocale->translate("Show URL"),this);

QToolTip::add(Show,klocale->translate("Test the URL You have entered: click here to open it."));


QPushButton *ClearComment = new QPushButton(klocale->translate("Clear text"),this);

QToolTip::add(ClearComment,klocale->translate("Click here to clear the comments You have entered."));

QPushButton *ClearURL = new QPushButton(klocale->translate("Clear URL"),this);

ClearURL->move(610,450);
ClearURL->resize(80,20);
QToolTip::add(ClearURL,klocale->translate("Click here to clear the URL You have entered."));

ClearComment->move(610,400);
ClearComment->resize(80,20);
Select->move(410,450);
Show->move(500,450);
Select->resize(80,20);
Show->resize(80,20);


	Name->move(130,10);
        Producer->move(130,50);
        Cast1->move(130,90);
	Cast2->move(130,130);
        Cast3->move(130,170);
	Cast4->move(130,210);
	Cast5->move(130,250);
	IMDB->move(450,500);
	Name->resize(200,20);
	Director->resize(200,20);
	Producer->resize(200,20);
	Cast1->resize(200,20);
	Cast2->resize(200,20);
	Cast3->resize(200,20);
	Cast4->resize(200,20);
	Cast5->resize(200,20);
 
	QPushButton *ok,*cancel,*Help;
	ok=new QPushButton(klocale->translate("Ok"),this);
        ok->setGeometry(10,350,100,30);
	Help = new QPushButton(klocale->translate("Help"),this);
	Help->adjustSize();
QToolTip::add(ok,klocale->translate("Closes the dialog and saves the movie."));


	cancel=new QPushButton(klocale->translate("Cancel"),this);
	cancel->setGeometry(200,350,100,30);
QToolTip::add(cancel,klocale->translate("Forget all changes and close the dialog."));

        connect(ok,SIGNAL(clicked()),SLOT(slotOKPressed()) ); 
        connect(cancel,SIGNAL(clicked()),SLOT(slotCancelPressed()) );
	connect(IMDB,SIGNAL(clicked()),SLOT(slotIMDBsearch()));
	connect(Select,SIGNAL(clicked()),SLOT(slotSelect()));
	connect(Show,SIGNAL(clicked()),SLOT(slotShowURL()));
	connect(ClearComment,SIGNAL(clicked()),SLOT(slotClearComment()));
	connect(ClearURL,SIGNAL(clicked()),SLOT(slotClearURL()));
	connect(Help,SIGNAL(clicked()),SLOT(slotMovieDialogHelp()));

	Help->move(440,500);
	ok->move(10,500);
	cancel->move(220,500);
	Genre1->insertItem(klocale->translate("Horror"),0);
        Genre1->insertItem(klocale->translate("Comedy"),1);
        Genre1->insertItem(klocale->translate("SciFi"),2);
        Genre1->insertItem(klocale->translate("Thriller"),3);
 	Genre1->insertItem(klocale->translate("Action"),4);
	Genre1->insertItem(klocale->translate("Crimi"),5);
	Genre1->insertItem(klocale->translate("Documentation"),6);
        Genre1->insertItem(klocale->translate("Cartoon"),7);
	Genre1->insertItem(klocale->translate("Drama"),8);
	Genre1->insertItem(klocale->translate("Monumental"),9);
	Genre1->insertItem(klocale->translate("Western"),10);
	Genre1->insertItem(klocale->translate("Erotic"),11);
	Genre1->insertItem(klocale->translate("Adventure"),12);
	Genre1->insertItem(klocale->translate("Musical"),13);
	Genre1->insertItem(klocale->translate("War"),14);
	Genre1->insertItem(klocale->translate("Catastrophe"),15);
	Genre1->insertItem(klocale->translate("Psycho"),16);
	Genre1->insertItem(klocale->translate("Satire"),17);
	Genre1->insertItem(klocale->translate("Fantasy"),18);
	Genre1->insertItem(klocale->translate("Traditional"),19);
	Genre1->insertItem(klocale->translate("Theatre"),20);
	Genre1->insertItem(klocale->translate("Other"),21); 
 ok->setDefault(TRUE); 


	  Genre2->insertItem(klocale->translate("Horror"),0);
        Genre2->insertItem(klocale->translate("Comedy"),1);
        Genre2->insertItem(klocale->translate("SciFi"),2);
        Genre2->insertItem(klocale->translate("Thriller"),3);
        Genre2->insertItem(klocale->translate("Action"),4);
        Genre2->insertItem(klocale->translate("Crimi"),5);
        Genre2->insertItem(klocale->translate("Documentation"),6);
        Genre2->insertItem(klocale->translate("Cartoon"),7);
        Genre2->insertItem(klocale->translate("Drama"),8);
        Genre2->insertItem(klocale->translate("Monumental"),9);
        Genre2->insertItem(klocale->translate("Western"),10);
        Genre2->insertItem(klocale->translate("Erotic"),11);
        Genre2->insertItem(klocale->translate("Adventure"),12);
        Genre2->insertItem(klocale->translate("Musical"),13);
        Genre2->insertItem(klocale->translate("War"),14);
        Genre2->insertItem(klocale->translate("Catastrophe"),15);
        Genre2->insertItem(klocale->translate("Psycho"),16);
        Genre2->insertItem(klocale->translate("Satire"),17);
        Genre2->insertItem(klocale->translate("Fantasy"),18);
        Genre2->insertItem(klocale->translate("Traditional"),19);
        Genre2->insertItem(klocale->translate("Theatre"),20);               
	Genre2->insertItem(klocale->translate("Other"),21);       	
 	Genre2->insertItem(klocale->translate("Nothing"),22);
	Genre2->setCurrentItem(22);	
  

connect( new KDNDDropZone(this,DndURL),SIGNAL(dropAction(KDNDDropZone *)),SLOT(slotDropEvent(KDNDDropZone *)));                                        


 QPixmap Hintergrund;
        char Filename[90];
        strcpy(Filename,kapp->kde_htmldir());
        strcat(Filename,"/en/kvideolist/imdb.xpm");
        Hintergrund.load(Filename);
Hintergrund1= new QLabel(this," ");
        Hintergrund1->setPixmap(Hintergrund);

        Hintergrund1->resize(198,82);
        Hintergrund1->move(455,82);
QToolTip::add(Hintergrund1,klocale->translate("The IMDb (Internet Movie Database)\n contains more than 150.000\n entries. You will find missing information \n for shure and can explore the background\n of a movie."));

        IMDbHome = new QPushButton(klocale->translate("Homepage"),this);

QToolTip::add(IMDbHome,klocale->translate("This connects You to the Homepage \n of the IMDb."));

        IMDbSearch = new QPushButton(klocale->translate("Search!"),this);
	IMDbFill = new QPushButton(klocale->translate("Autofill!"),this);

QToolTip::add(IMDbFill,klocale->translate("If You found the correct movie entry in the IMDb, You can autofill this dialog."));

QToolTip::add(IMDbSearch,klocale->translate("Enter a movie name into the 'Title'\n field. Then click on this button,\n and KVideolist shows You the search\n results on IMDb. If You found the correct \n entry, just drag and drop it into \n this window: KVideolist will then try\n to fill out all data automatically."));

        IMDbMovieEntry= new QPushButton(klocale->translate("More About"),this);
QToolTip::add(IMDbMovieEntry,klocale->translate("If You used the autofill-feature, You can \n directly few the entry in the IMDb\n here."));



        char ButtonDescribe[80];
        strcpy(ButtonDescribe,"More about ");
        strcat(ButtonDescribe,MOVIENAME);
        IMDbMovieEntry->setText(ButtonDescribe);
                                                                       
	      IMDbHome->resize(100,20);
        IMDbSearch->resize(100,20);
        IMDbMovieEntry->resize(100,20);

        IMDbHome->move(600,100-10);
        IMDbSearch->move(600,125-10);
        IMDbMovieEntry->move(600,150-10);
	IMDbFill->resize(100,20);
	IMDbFill->move(600,75-10);
        connect(IMDbHome,SIGNAL(clicked()),SLOT(slotIMDbHome()));
        connect(IMDbSearch,SIGNAL(clicked()),SLOT(slotIMDBsearch()));
        connect(IMDbFill,SIGNAL(clicked()),SLOT(slotIMDBFill()));

	connect(IMDbMovieEntry,SIGNAL(clicked()),SLOT(slotIMDbMovieEntry()));
	IMDbMovieEntry->hide();



	IMDB->hide();
	IMDbFill->hide();
                                                     

};

void MovieDialog::slotMovieDialogHelp() {

	// Will open the KDEHelp Browser with Help about MovieDialog,
	// once the documentation is up to date
	};


void MovieDialog::slotDropEvent(KDNDDropZone *zone) {

	IMDbSearch->show();
	IMDbHome->show();
	IMDbMovieEntry->show();
	Hintergrund1->show();



        QString u = zone->getURLList().first(),s;
        if (KFM::download(u,s)) {
        char Caption[255];


	strcpy(THISMOVIE,u);



        strcpy(Caption,s);
	char Result[80];
	char Pattern[80];
	// Fetching Producer

/* if (FETCHPRODUCER==TRUE) {
	strcpy(Pattern,"production-companies");
	IMDbMovieEntry->setText(Name->text());	
	Parse(Caption,Pattern,Result);	

	Producer->setText(Result);
	};
*/

	// Fetching Director
	
if (FETCHDIRECTOR==TRUE) {
	
	Parse2(Caption,"directors","Name",Result,1);
	Director->setText(Result);
	};


if (FETCHCAST==TRUE) {
	// Fetching Cast
	Parse2(Caption,"cast","Name",Result,1);
	Cast1->setText(Result);
	Parse2(Caption,"cast","Name",Result,2);
	Cast2->setText(Result);
	Parse2(Caption,"cast","Name",Result,3);
	Cast3->setText(Result);
	Parse2(Caption,"cast","Name",Result,4);
	Cast4->setText(Result);
	Parse2(Caption,"cast","Name",Result,5);
	Cast5->setText(Result);
       };

if (FETCHYEAR==TRUE) {
	// Fetching Release Year
	Parse(Caption,"TITLE",Result);
	char *Date;
	Date=strstr(Result,"("); 
	Date++;
	Date[4]='\0';
	Age->setText(Date);
    };

if (FETCHCOUNTRY==TRUE) {
	// Fetching Country

	Parse(Caption,"/Sections/Countries/",Result);
	MadeIn->setText(Result);
	};	
	
        KFM::removeTempFile(s); 


        };




};





void MovieDialog::slotIMDBFill() {

        IMDbSearch->show();
        IMDbHome->show();
        IMDbMovieEntry->show();
        Hintergrund1->show();



	QString u,s;        
        if (KFM::download(SEARCHSTRING,s)) {
        char Caption[255];


        strcpy(THISMOVIE,u);



        strcpy(Caption,s);
        char Result[80];
        char Pattern[80];
        // Fetching Producer
/*
if (FETCHPRODUCER==TRUE) {
        strcpy(Pattern,"production-companies");
        IMDbMovieEntry->setText(Name->text());
        Parse(Caption,Pattern,Result);

        Producer->setText(Result);
        };
*/

        // Fetching Director

if (FETCHDIRECTOR==TRUE) {

        Parse2(Caption,"directors","Name",Result,1);
        Director->setText(Result);
        };


if (FETCHCAST==TRUE) {
        // Fetching Cast
        Parse2(Caption,"cast","Name",Result,1);
        Cast1->setText(Result);
        Parse2(Caption,"cast","Name",Result,2);
        Cast2->setText(Result);
        Parse2(Caption,"cast","Name",Result,3);
        Cast3->setText(Result);
        Parse2(Caption,"cast","Name",Result,4);
        Cast4->setText(Result);
        Parse2(Caption,"cast","Name",Result,5);
        Cast5->setText(Result);
       };

if (FETCHYEAR==TRUE) {
        // Fetching Release Year
        Parse(Caption,"TITLE",Result);
        char *Date;
        Date=strstr(Result,"(");
        Date++;
        Date[4]='\0';
        Age->setText(Date);
    };

if (FETCHCOUNTRY==TRUE) {
        // Fetching Country

        Parse(Caption,"/Sections/Countries/",Result);
        MadeIn->setText(Result);
        };

        KFM::removeTempFile(s);


        };




};
                                                         





void MovieDialog::Parse(char *Filename,char *Pattern,char *Result) {

	FILE *Url;
	char BigString[100000];
	char *Needle;
	int Text;
	int Counter=0;
	Url=fopen(Filename,"r");
		
	while (((Text=getc(Url))!=-1) && (Counter<100000)) { BigString[Counter]=Text;Counter++; };
	
	// Searching for the Pattern
	Needle=strstr(BigString,Pattern);
	if (Needle==NULL) { Result[0]='\0'; return; };

	Needle=strstr(Needle,">");
	Counter=1;
	while (Needle[Counter]!='<') {Result[Counter-1]=Needle[Counter];
					Counter++;};Result[Counter-1]='\0';


	
	fclose(Url);
};



void MovieDialog::Parse2(char *Filename,char *Pattern1,char *Pattern2,char *Result,int n) {

        FILE *Url;
        char BigString[100000];
        char *Needle;
        int Text;
        int Counter=0;
        Url=fopen(Filename,"r");

        while (((Text=getc(Url))!=-1) && (Counter<100000)) { BigString[Counter]=Text;Counter++; };

        // Searching for the Pattern1
        Needle=strstr(BigString,Pattern1);
        if (Needle==NULL) { Result[0]='\0'; return; };
	
	// Searching n times for Pattern2
	Counter=0;
	while (Counter<n) {
	Needle=strstr(Needle,Pattern2);Needle++;Counter ++; };Needle--;

	
        Needle=strstr(Needle,">");
        Counter=1;
        while (Needle[Counter]!='<') {Result[Counter-1]=Needle[Counter];
                                        Counter++;};Result[Counter-1]='\0';



        fclose(Url);
};
                                                 
                                

void MovieDialog::setAnker(Pointer Anker) {
	DieserAnker=Anker;
	};



void MovieDialog::slotClearComment() {
	Comments->setText("\0"); };

void MovieDialog::slotClearURL() {
	LinkURL->setText("\0"); };



void MovieDialog::slotIMDBsearch() {

if (FETCHPRODUCER==0 && FETCHCAST==0 && FETCHYEAR==0 && FETCHDIRECTOR==0 && FETCHGENRES==0 && FETCHCOUNTRY==0) { QMessageBox::information(this,klocale->translate("Nothing to retrieve."),klocale->translate("Please check Your IMDB configuration in KVideolist's configuration dialog. \nAt the moment, KVideolist would not retrieve anything from IMDB."));
			return;			};


	KFM *url= new KFM;
	url->allowKFMRestart(TRUE);
	if (strlen(Name->text())==0) { 
		QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("Please enter the title to search for into the 'Title'-Field.")); return; };
if (ASKONLINE==TRUE) {
if (!QMessageBox::warning(0,klocale->translate("One moment"),klocale->translate("To continue, KVideolist needs a connection\nto the internet. Are You online?"),klocale->translate("No"),klocale->translate("Yes"))) return;                                          
						};

	
	char urlName[255];
	char Filmname[255];
	strcpy(Filmname,Name->text());
	int x=0;
	while (x<(signed) strlen(Filmname)) {
		if (Filmname[x]==' ') { Filmname[x]='+'; };
		x++;
		};

				
	strcpy(urlName,"http://us.imdb.com/M/title-substring?title=");
	strcat(urlName,Filmname);
	strcat(urlName,"&tv=both");

	url->openURL(urlName);
	strcpy(SEARCHSTRING,urlName);


// Checking for a direct hit by the IMDb

	QString u,s;
	if (KFM::download(SEARCHSTRING,s)) { 
			
			char Pattern[80];
		
			
			// Looking for a direct hit description
		        // 
			FILE *Url;
			char *Needle;
			int Text;
			char BigString[100000];
			int Counter=0;
			strcpy(Pattern,"Directed by");
			Url=fopen(s,"r");
			
			while (((Text=getc(Url))!=-1) && (Counter<100000)) { BigString[Counter]=Text;Counter++;};

			Needle=strstr(BigString,Pattern);
			if (Needle!=NULL) { // This is a direct hit,
					    // just fill it out.
					  
			                    slotIMDBFill();
		    
 
						};
			strcpy(Pattern,"Sorry there were");
		        Needle=strstr(BigString,Pattern);
			if (Needle!=NULL) { // This is when nothing is found,
					    // just show a dialog.
					    QMessageBox::information(this,klocale->translate("No Results"),klocale->translate("The IMDb did not found the title You entered."));};

			KFM::removeTempFile(s);
	
			};
			
		
		
			
			

         
	};



void MovieDialog::slotOKPressed() {
if ( Genre1->currentItem()==Genre2->currentItem() ) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The two Genres cannot be the same. "));return;};
if ( (atoi(Number->text())) <1 ) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("Enter a higher Tape-number."));return;};
if ((atoi(Minutes->text()))>59) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The minutes of the playtime cannot be more then 59"));return;};
if (strlen(Number->text())==0) { QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("You must enter a video number."));return;};
if (strlen(Name->text())==0) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("You must enter the movie name."));return;};
if ( (atoi(Rating->text())<0) || (atoi(Rating->text())>10)) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("The ranking has to be between 1 and 10"));return;};
if ((strlen(Age->text())>0) && (strlen(Age->text()))<4) {QMessageBox::information(this,klocale->translate("Mistake..."),klocale->translate("Please enter the release year with 4 digits.\n e.g. 1984, to avoid Year2000 problems\nwhen sorting by release-year."));return;};
if (EDITING==false) { int a;
			char Dumm[70];
strcpy(Dumm,Name->text());
a=CheckMovie(DieserAnker,Dumm,PlayNumber->currentItem(),atoi(Number->text()));
if (a==-1) {QMessageBox::information(this,klocale->translate("Hmm..."),klocale->translate("There is already a movie with exactly the same name.\nPlease choose another one."));return;};
if (a==-2) {QMessageBox::information(this,klocale->translate("Hmm..."),klocale->translate("Sorry. Another movie is at the same position on the tape.\n Change the position."));return;};

};



accept();
};

void MovieDialog::slotCancelPressed() {

	reject();
	};



void MovieDialog::slotSelect() {
QString s=QFileDialog::getOpenFileName(0,"*.*",this);
LinkURL->setText(s);
};

void MovieDialog::slotShowURL() {

	KFM *url= new KFM;
	url->allowKFMRestart(TRUE);
	url->openURL(LinkURL->text());
};


void MovieDialog::slotIMDbHome() {

        KFM *url= new KFM;
        url->allowKFMRestart(TRUE);
        url->openURL("http://www.imdb.com/");
        printf("HOME");
        };
void MovieDialog::slotIMDbSearch() {
        KFM *url = new KFM;
        url->allowKFMRestart(TRUE);
        url->openURL("http://www.imdb.com/search/");
        };
void MovieDialog::slotIMDbMovieEntry() {
        KFM *url= new KFM;
        url->allowKFMRestart(TRUE);
        url->openURL(THISMOVIE);
        };

                            


	
