    /*

    random.C  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@uwix.alt.na

    The class Random is based on Makoto Matsumoto 's and Takuiji
    Nishimimura's 'mt19937.c'. They invented the algorithm and all
    credits go to them (matumoto@math.keio.ac.jp).

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#include <time.h>

#include "random.h"


/*
Don't change any of the following values unless you know _exactly_
what you're doing. Obey or die!
*/

// Period parameters

#define N 624
#define M 397
#define MATRIX_A 0x9908b0df         // constant vector a
#define UPPER_MASK 0x80000000       // most significant w-r bits
#define LOWER_MASK 0x7fffffff       // least significant r bits


// Tempering parameters

#define TEMPERING_MASK_B 0x9d2c5680
#define TEMPERING_MASK_C 0xefe60000




// public member functions

Random::Random( unsigned long seed )
  {
  mt = new unsigned long[N];
  if ( mt == 0 ) exit( 1 );
  if ( seed == 0 )
    {
    mt[0] = time( 0 ) & 0xffffffff;
    }
  else
    {
    mt[0] = seed & 0xffffffff;
    }
  for ( mti = 1; mti < N; mti++ )
    {
    mt[mti] = ( 69069 * mt[mti-1] ) & 0xffffffff;
    }
  mag01[0] = 0x0;
  mag01[1] = MATRIX_A;
  }


Random::~Random()
  {
  delete [] mt;
  }


double Random::drand()
  {
  unsigned long d = rand();
  if ( d == 0xffffffff ) d -= rand();
  return ( (double) d / (unsigned long) 0xffffffff );
  }


double Random::drand( double lowerLimit, double upperLimit )
  {
  return ( upperLimit - lowerLimit ) * drand() + lowerLimit;
  }


unsigned long Random::lrand()
  {
  return rand();
  }


unsigned long Random::lrand( unsigned long lowerLimit, unsigned long upperLimit )
  {
  double tmp = drand();
  return ( upperLimit - lowerLimit + 1 ) * tmp + lowerLimit;
  }



// private member functions

unsigned long Random::rand()
  {
  unsigned long y;
  if ( mti == N )
    {
    int kk;
    for ( kk = 0; kk < N - M; kk++ )
      {
      y = ( mt[kk] & UPPER_MASK ) | ( mt[kk+1] & LOWER_MASK );
      mt[kk] = mt[kk+M] ^ ( y >> 1 ) ^ mag01[y & 0x1];
      }
    for ( ; kk < N - 1; kk++ )
      {
      y = ( mt[kk] & UPPER_MASK ) | ( mt[kk+1] & LOWER_MASK );
      mt[kk] = mt[kk + M - N] ^ ( y >> 1 ) ^ mag01[y & 0x1];
      }
    y = ( mt[N - 1] & UPPER_MASK ) | ( mt[0] & LOWER_MASK );
    mt[N - 1] = mt[M - 1] ^ ( y >> 1 ) ^ mag01[ y & 0x1];

    mti = 0;
    }
  y = mt[mti++];
  y ^= temperingShiftU( y );
  y ^= temperingShiftS( y ) & TEMPERING_MASK_B;
  y ^= temperingShiftT( y ) & TEMPERING_MASK_C;
  y ^= temperingShiftL( y );

  return y;
  }


