    /*

    ktsp.h  for ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __KTSP__
#define __KTSP__



#include <qwidget.h>
#include <qlabel.h>
#include <qprogressdialog.h>
#include <qprogressbar.h>
#include <qtimer.h>
#include <qstring.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <drag.h>

#include "tspgda.h"
#include "view.h"
#include "actionsdisplay.h"
#include "runsdisplay.h"



class KTsp : public KTMainWindow
  {
  Q_OBJECT

  public:
    KTsp( const char *fileName = 0 );
    ~KTsp();
    enum { STATUSBAR_READY, STATUSBAR_WATING, STATUSBAR_GENERATING,
           STATUSBAR_NEIGHBOURS, STATUSBAR_OPTIMIZING,
           STATUSBAR_LOADING, STATUSBAR_SAVING, STATUSBAR_LOAD_ERROR,
           STATUSBAR_SAVE_ERROR, STATUSBAR_RESUMING,
           STATUSBAR_RESUME_ERROR };
    enum { ORIG_TSP, CURRENT_TSP, BEST_TSP };

  protected slots:
    void slotToolbarClicked( int item );
    void slotStatusChanged( int id );
    void slotNeighbours( int number );
    void slotNeighboursMax( int number );
    void slotPointsMax( int number );
    void slotQuit();
    void slotStart();
    void slotViewOrigTsp();
    void slotViewCurrentTsp();
    void slotViewBestTsp();
    void slotCoursesReady();
    void slotNoCoursesReady();
    void slotConfigTsp();
    void slotConfigGraphic();
    void slotRunsChanged( int number );
    void slotPointsShapeChanged( int value );
    void slotPointsColourChanged( int value );
    void slotPointsSizeChanged( int value );
    void slotLinesStyleChanged( int value );
    void slotLinesColourChanged( int value );
    void slotLinesWidthChanged( int value );
    void slotOpen();
    void slotDrop( KDNDDropZone *drop );
    void slotSaveAs();
    void slotForcedLoad();
    void slotForcedResume();
    void slotBestQuality( double quality );

  protected:
    void setupMenubar();
    void setupToolbar();
    void setupStatusbar();
    void setupTsp();
    void setupView();
    void loadFile( QString url );
    void setupRandom();
    void setupDND();
    void viewTsp( int id );
    void saveConfig();
    void readConfig();
    void queryUnsaved();
    virtual bool queryClose();
    virtual void saveProperties( KConfig *config );
    virtual void readProperties( KConfig *config );

  private:
    enum { TOOLBAR_QUIT, TOOLBAR_HELP, TOOLBAR_RUN,
           TOOLBAR_OPEN, TOOLBAR_SAVE };
    QTimer *timer;
    QWidget *w;
    View *display;
    KAccel *accel;
    TspGda *tsp;
    int _numberOfPoints;
    int _numberOfNeighbours;
    int _runs;
    double bestQuality;
    ActionsDisplay *aDisplay;
    RunsDisplay *rDisplay;
    QProgressBar *progressBar;
    QPopupMenu *viewMenu;
    QPopupMenu *fileMenu;
    QProgressDialog *progress;
    int best_id, orig_id, current_id;
    int save_id, open_id;
    int new_id;
    int _pointsShape;
    int _pointsColour;
    int _pointsSize;
    int _linesStyle;
    int _linesColour;
    int _linesWidth;
    int performedRuns;
    bool dirty;
    bool finished;
    bool cannotOpen;
    bool noClearDisplay;
    QString loadFileName;
    QString resumedOrigTsp;
    QString resumedBestTsp;
    double resumedBestQuality;
    void showFileError( const char *messge );
    void enableOpenNew();
    void disableOpenNew();
  };


#endif   // __KTSP__
