// ----------------------------------------------------------------------------
// main.cpp
// ----------------------------------------------------------------------------
// Main kickstarter for KTimeclock.
// ----------------------------------------------------------------------------

#include <kapp.h>                       // Needed for KApplication class

#include "MainWidget.h"                 // Needed for MainWidget class

int main (int argc, char* argv[])
{
    KApplication* ktimeclockapp = new KApplication( argc, argv, "ktimeclock" );

    // Process any cmd line args that we've been given that are special
    // (e.g. "-help")
    for (int i=1; i<kapp->argc(); i++)
    {
        if ('-' == kapp->argv()[i][0])
        {
            if (QString("-help") != kapp->argv()[i])
            {
                printf( "Invalid command line argument: %s\n\n", kapp->argv()[i] );
            }

            printf( KTIMECLOCK_VERSION );
            printf( "\n(C) 1998 Graham TerMarsch (gtermars@home.com)\n\n" );
            printf( "Project task time clock for the KDE Desktop Environment\n\n" );
            printf( "Usage: %s [-help]\n", argv[0] );
            printf( "\t-help    : Displays this message\n" );
            exit( 0 );
        }
    }

    // Create the main widget and display it.  Note, that although we've got
    // things set up here to use session management, the KTimeclockMainWidget
    // class doesn't currently store any information in the KConfig file (right
    // now this stuff doesn't really do anything).
    if (kapp->isRestored())
    {
        RESTORE(KTimeclockMainWidget)
    }
    else
    {
        KTimeclockMainWidget* mw =
            new KTimeclockMainWidget( NULL, "ktimeclock" );
        CHECK_PTR( mw );
        ktimeclockapp->setMainWidget( mw );
        mw->show();
    }

    // Run the application.
    return (ktimeclockapp->exec());
}
