// ----------------------------------------------------------------------------
// Filename:    DockWidget.cpp
// $Date: 2000/02/08 00:48:52 $
// $Revision: 1.1 $
// ----------------------------------------------------------------------------

#include "DockWidget.h"
#include <kwm.h>
#include <kapp.h>
#include <qwmatrix.h>

// ----------------------------------------------------------------------------
// Function:    DockWidget::DockWidget (QWidget* mainwin, const char* name=0)
// Parameters:  mainwin     - Handle to main window
//              name        - Name of this widget
// ----------------------------------------------------------------------------
// Constructor.
// ----------------------------------------------------------------------------
DockWidget::DockWidget (QWidget* mainwin, const char* name)
    : QWidget(0,name,0)
{
    _docked = false;
    _mainwin = mainwin;

    // ------------------------------------------------------------------------
    // Load up our docking pixmap.
    // ------------------------------------------------------------------------
    if (_pixmap.load( kapp->kde_icondir() + "/ktimeclock.xpm" ))
    {
        // --------------------------------------------------------------------
        // Scale the pixmap to be 24x24
        // --------------------------------------------------------------------
        QWMatrix matrix;
        float height_scl = 24.0 / float(_pixmap.height());
        float width_scl  = 24.0 / float(_pixmap.width());
        matrix.scale( width_scl, height_scl );

        _pixmap = _pixmap.xForm( matrix );
    }
    else
    {
        debug( "UNABLE TO LOAD PIXMAP!!!" );
    }
}

// ----------------------------------------------------------------------------
// Function:    DockWidget::~DockWidget ()
// ----------------------------------------------------------------------------
// Destructor.
// ----------------------------------------------------------------------------
DockWidget::~DockWidget ()
{
}

// ----------------------------------------------------------------------------
// Function:    DockWidget::isDocked ()
// ----------------------------------------------------------------------------
// Returns a boolean value stating whether or not the window is currently
// docked into KPanel.
// ----------------------------------------------------------------------------
const bool DockWidget::isDocked ()
{
    return _docked;
}

// ----------------------------------------------------------------------------
// Function:    DockWidget::dock ()
// ----------------------------------------------------------------------------
// Docks the application into KPanel.
// ----------------------------------------------------------------------------
void DockWidget::dock ()
{
    if (!_docked)
    {
        // --------------------------------------------------------------------
        // Prepare panel for docking
        // --------------------------------------------------------------------
        KWM::setDockWindow( this->winId() );

        // --------------------------------------------------------------------
        // Set our fixed size (that's all we've got in the panel).
        // --------------------------------------------------------------------
        this->setFixedSize( 24, 24 );

        // --------------------------------------------------------------------
        // Dock the widget.
        // --------------------------------------------------------------------
        this->show();

        // --------------------------------------------------------------------
        // Remember that we've just been docked.
        // --------------------------------------------------------------------
        _docked = true;
    }
}

// ----------------------------------------------------------------------------
// Function:    DockWidget::undock ()
// ----------------------------------------------------------------------------
// Un-docks the application from KPanel.
// ----------------------------------------------------------------------------
void DockWidget::undock ()
{
    if (_docked)
    {
        // --------------------------------------------------------------------
        // We've got to destroy the window to undock from the panel; 'hide()'
        // just doesn't cut it.
        // --------------------------------------------------------------------
        this->destroy( true, true );

        // --------------------------------------------------------------------
        // Create another window so that we can dock again in the future.
        // --------------------------------------------------------------------
        this->create( 0, false, false );

        // --------------------------------------------------------------------
        // Remember that we're no longer docked.
        // --------------------------------------------------------------------
        _docked = false;
    }
}

// ----------------------------------------------------------------------------
// Function:    DockWidget::paintEvent (QPaintEvent*)
// ----------------------------------------------------------------------------
// Over-ridden painting event; we use this to paint our own icon onto our
// display in the KPanel.
// ----------------------------------------------------------------------------
void DockWidget::paintEvent (QPaintEvent*)
{
    bitBlt( this, 0, 0, &_pixmap );
}

// ----------------------------------------------------------------------------
// Function:    DockWidget::mousePressEvent (QMouseEvent* e)
// Parameters:  e           - Event to respond to
// ----------------------------------------------------------------------------
// Over-ridden mouse press event; used to toggle our main window in and out of
// hiding.
// ----------------------------------------------------------------------------
void DockWidget::mousePressEvent (QMouseEvent* e)
{
    // ------------------------------------------------------------------------
    // Only respond to left mouse button requests.
    // ------------------------------------------------------------------------
    if (e->button() == LeftButton)
    {
        // --------------------------------------------------------------------
        // Only do something if we've got a main window to toggle in and out of
        // hiding.
        // --------------------------------------------------------------------
        if (_mainwin != 0L)
        {
            // ----------------------------------------------------------------
            // Toggle the visibility of the main window.
            // ----------------------------------------------------------------
            if (_mainwin->isVisible())
            {
                _mainwin->hide();
                _mainwin->recreate( 0, 0,
                                    QPoint(_mainwin->x(), _mainwin->y()),
                                    FALSE );
                kapp->setTopWidget( _mainwin );
            }
            else
            {
                _mainwin->show();
                KWM::activate( _mainwin->winId() );
            }
        }
    }
}
