#!/usr/bin/perl

#
# Compiles a KDDL dialog specification into a C++ class
#
# Copyright Richard J. Moore 1998
# Email rich@kde.org
#
# Rolf Jakob (rjakob@duffy1.franken.de) : some i4l() added

$buttonlabel= "button1";
$labeltext= "label1";
$pagetitle= "page1";

# Globals
$dlgName= "";
@listItems= ();
$listName= "";


sub parseAttrs {
    my($input)= @_;
    my(%attrs);
    my($i);

    while (length($input) > 0) {
	$input=~ s/^\s*//; # Trim leading whitespace
	$input=~ s/\s*$//; # Trim following whitespace

	if ($input=~ /name\s*=\s*\"(.*?)\"/i) {
	    $attrs{name}= $1;
	    $input=~ s/name\s*=\s*\".*?\"//i;
	}
	elsif ($input=~ /type\s*=\s*\"(.*?)\"/i) {
	    $attrs{type}= $1;
	    $input=~ s/type\s*=\s*\"(.*?)\"//i;
	}
	elsif ($input=~ /title\s*=\s*\"(.*?)\"/i) {
	    $attrs{title}= $1;
	    $input=~ s/title\s*=\s*\"(.*?)\"//i;
	}
	elsif ($input=~ /border\s*=\s*\"(.*?)\"/i) {
	    $attrs{border}= $1;
	    $input=~ s/border\s*=\s*\"(.*?)\"//i;
	}
	elsif ($input=~ /maxlength\s*=\s*(\d+)/i) {
	    $attrs{maxlength}= $1;
	    $input=~ s/maxlength\s*=\s*(\d+?)//i;
	}
	elsif ($input=~ /colspan\s*=\s*(\d+)/i) {
	    $attrs{colspan}= $1;
	    $input=~ s/colspan\s*=\s*(\d+?)//i;
	}
	elsif ($input=~ /rowspan\s*=\s*(\d+)/i) {
	    $attrs{rowspan}= $1;
	    $input=~ s/rowspan\s*=\s*(\d+?)//i;
	}
	elsif ($input=~ /minrows\s*=\s*(\d+)/i) {
	    $attrs{minrows}= $1;
	    $input=~ s/minrows\s*=\s*(\d+?)//i;
	}
	elsif ($input=~ /checked\s*=\s*\"(.*?)\"/i) {
	    $attrs{checked}= $1;
	    $input=~ s/checked\s*=\s*\"(.*?)\"//i;
	}
	elsif ($input=~ /id\s*=\s*\"(.*?)\"/i) {
	    $attrs{id}= $1;
	    $input=~ s/id\s*=\s*\"(.*?)\"//i;
	}
	elsif ($input=~ /group\s*=\s*\"(.*?)\"/i) {
	    $attrs{group}= $1;
	    $input=~ s/group\s*=\s*\"(.*?)\"//i;
	}
	elsif ($input=~ /align\s*=\s*\"(.*?)\"/i) {
	    $attrs{align}= $1;
	    $input=~ s/align\s*=\s*\"(.*?)\"//i;
	}
    }

    $i= \%attrs;
    return $i;
}

($basename)= $ARGV[0] =~ /(.*).kdlg/;

open(HDR, ">$basename.h") || die "Could not open $basename.h: $!\n";
open(CPP, ">$basename.cpp") || die "Could not open $basename.cpp: $!\n";

while(<>) {
    while(length($_) > 0) {
	s/^\s*//; # Trim leading whitespace
	s/\s*$//; # Trim following whitespace

	if(/^<.*?>/) {
	    # Unpack the tag and it's attributes
	    ($tag, $attrstr)= /^<([\/\w]\w+)(.*?)>/;
	    s/^<[\/\w]\w+.*?>//;
	    $attrs= parseAttrs($attrstr);

#	    print "/* $tag ".$attrs->{name}." */\n";

	    # Handle the tag
	    if ($tag =~ m%/kddl%i) {
		select(CPP);
		print "    ktl->activate();\n";
		print "}\n";

		print "#include \"$basename.moc\"\n";
	    }
	    elsif ($tag =~ /kddl/i) {
		select(CPP);
		$title= $attrs->{title};
		$dlgName= $attrs->{name};
		print "#include <qdialog.h>\n";
		print "#include <qstrlist.h>\n";
		print "#include <kapp.h>\n";
		print "#include \"typelayout.h\"\n";
		print "#include \"tlform.h\"\n";
		print "#include \"$basename.h\"\n\n";
		print $dlgName."::".$dlgName."(QWidget *parent,const char *name, bool modal)  \n: QDialog(parent,name,modal) {\n";
		print "    TLForm *ktlform= new TLForm(\"$dlgName\", \"$title\", this);\n";
		print "    ktl= ktlform->layout;\n";
		
		select(HDR);
		print "#ifndef ".uc($basename)."_H\n";
		print "#define ".uc($basename)."_H\n\n";
		print "#include <qdialog.h>\n";
		print "#include \"typelayout.h\"\n\n";
		print "class $dlgName : public QDialog {\n";
		print "  Q_OBJECT\n";
		print "public:\n";
		print "  $dlgName(QWidget *parent=0, const char *name=0, bool modal=false);\n";
		print "  KTypeLayout *ktl;";
		print "};\n\n";
		print "#endif // ".uc($basename)."_H\n";
	    }
	    elsif ($tag =~ m%/group%i) {
		select(CPP);
		print "    ktl->endGroup();\n";
	    }
	    elsif ($tag =~ /group/i) {
		select(CPP);
		print "    ktl->addGroup(\"".$attrs->{name}."\", i18n(\"$attrs->{title}\"), $attrs->{border});\n";
	    }
	    elsif ($tag =~ m%/book%i) {
		select(CPP);
		print "    ktl->endGroup();\n";
	    }
	    elsif ($tag =~ /book/i) {
		select(CPP);
		print "    ktl->addBook(\"".$attrs->{name}."\");\n";
	    }
	    elsif ($tag =~ m%/page%i) {
		select(CPP);
		print "    ktl->endGroup();\n";
	    }
	    elsif ($tag =~ /page/i) {
		select(CPP);
		print "    ktl->addPage(\"".$attrs->{name}."\", \"$attrs->{title}\");\n";
	    }
	    elsif ($tag =~ m%/checkbox%i) {

	    }
	    elsif ($tag =~ /checkbox/i) {
		if (/^([^<]+?)</) {
		    $text= $1;
		    s/^[^<]+?</</;
		} else {
		    $text= "";
		}

		select(CPP);
		print "    ktl->addCheckBox(\"".$attrs->{name}."\", i18n(\"$text\"), $attrs->{checked});\n";

		if ($attrs->{colspan} || $attrs->{rowspan}) {
		    $cols= ( $attrs->{colspan} || 1);
		    $rows= ( $attrs->{rowspan} || 1);
		    print "    ktl->setSpawn(\"$attrs->{name}\", $cols, $rows);\n";
		}
	    }
	    elsif ($tag =~ m%/radiobutton%i) {

	    }
	    elsif ($tag =~ /radiobutton/i) {
		if (/^([^<]+?)</) {
		    $text= $1;
		    s/^[^<]+?</</;
		} else {
		    $text= "";
		}

		if ($attrs->{id} ne "") {
		    $id= $attrs->{id};
		}
		else {
		    $id= -1;
		};
		if ($attrs->{checked} ne "") {
		    $checked= $attrs->{checked};
		}
		else {
		    $checked= "false";
		};

		select(CPP);
		print "    ktl->addRadioButton(\"".$attrs->{name}."\"".
		    ", \"$attrs->{group}\", \"$text\", $checked, $id);\n";
		if ($attrs->{colspan} || $attrs->{rowspan}) {
		    $cols= ( $attrs->{colspan} || 1);
		    $rows= ( $attrs->{rowspan} || 1);
		    print "    ktl->setSpawn(\"$attrs->{name}\", $cols, $rows);\n";
		}
	    }
	    elsif ($tag =~ m%/button%i) {

	    }
	    elsif ($tag =~ /button/i) {
		if (/^([^<]+?)</) {
		    $label= $1;
		    s/^[^<]+?</</;
		} else {
		    $label= $buttonlabel++;
		}
		select(CPP);
		print "    ktl->addButton(\"".$attrs->{name}."\", i18n(\"$label\"));\n";
		if ($attrs->{colspan} || $attrs->{rowspan}) {
		    $cols= ( $attrs->{colspan} || 1);
		    $rows= ( $attrs->{rowspan} || 1);
		    print "    ktl->setSpawn(\"$attrs->{name}\", $cols, $rows);\n";
		}
	    }
	    elsif ($tag =~ m%/label%i) {

	    }
	    elsif ($tag =~ /label/i) {
		if (/^([^<]+?)</) {
		    $label= $1;
		    s/^[^<]+?</</;
		} else {
		    $label= $labeltext++;
		}
		select(CPP);
		print "    ktl->addLabel(\"".$attrs->{name}."\", i18n(\"$label\"));\n";
		if ($attrs->{colspan} || $attrs->{rowspan}) {
		    $cols= ( $attrs->{colspan} || 1);
		    $rows= ( $attrs->{rowspan} || 1);
		    print "    ktl->setSpawn(\"$attrs->{name}\", $cols, $rows);\n";
		}
	    }
	    elsif ($tag =~ m%/lineedit%i) {

	    }
	    elsif ($tag =~ /lineedit/i) {
		if (/^([^<]+?)</) {
		    $text= $1;
		    s/^[^<]+?</</;
		} else {
		    $text= "";
		}

		if ($attrs->{maxlength} =~ /^(\d+)$/) {
		    $maxlength= $1;
		}
		else {
		    $maxlength= -1;
		}

		select(CPP);
		if ($type eq "int") {
		    print "    ktl->addIntLineEdit(\"".$attrs->{name}."\", \"$text\", $maxlength);\n";
		}
		else {
		    print "    ktl->addLineEdit(\"".$attrs->{name}."\", \"$text\", $maxlength);\n";
		}
		if ($attrs->{colspan} || $attrs->{rowspan}) {
		    $cols= ( $attrs->{colspan} || 1);
		    $rows= ( $attrs->{rowspan} || 1);
		    print "    ktl->setSpawn(\"$attrs->{name}\", $cols, $rows);\n";
		}
	    }
	    elsif ($tag =~ m%/listbox%i) {
		$minrows= ( $attrs->{minrows} || 5);
		select(CPP);
		print "    ktl->addListBox(\"$listName\", &".$listName."Contents, $minrows);\n";
	    }
	    elsif ($tag =~ /listbox/i) {
		select(CPP);
		$listName= $attrs->{name};
		print "    QStrList $listName"."Contents;\n";
	    }
	    elsif ($tag =~ m%/combobox%i) {
		select(CPP);
		print "    ktl->addComboBox(\"$listName\", &".$listName."Contents);\n";
	    }
	    elsif ($tag =~ /combobox/i) {
		select(CPP);
		$listName= $attrs->{name};
		print "    QStrList $listName"."Contents;\n";
	    }
	    elsif ($tag =~ m%/li%i) {

	    }
	    elsif ($tag =~ /li/i) {
		if (/^([^<]+?)</) {
		    $text= $1;
		    s/^[^<]+?</</;
		} else {
		    $text= "";
		}
		select(CPP);
		print "    $listName"."Contents.append(\"$text\");\n";
	    }
	    elsif ($tag =~ m/colorbutton/i) {
		select(CPP);
#		print "    ktl->addColorButton();\n";
	    }
	    elsif ($tag =~ m/br/i) {
		select(CPP);
		print "    ktl->newLine();\n";
	    }
	    elsif ($tag =~ m/skip/i) {
		select(CPP);
		print "    ktl->skip();\n";
	    }
	    else {
		warn "Warning: Unknown tag $tag at line $.\n";
	    }
	}
	else {
	    die "Syntax error at line $.\n";
	}
    }
}

