/***************************************************************************
                          knd_mon.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include	"knd_mon.h"

/*  KNDMonitor								*/
/*  KNDMonitor	: Constructor for view object				*/
/*  parent	: QWidget *	: Parent widget				*/
/*  slot	: int		: Slot in parent view list		*/
/*  iflist	: QArray<char*>*: Interface list			*/
/*  eplist	: QArray<char*>*: Ethernet protocol list		*/
/*  oplist	: QArray<char*>*: Internet protocol list		*/
/*  svlist	: QArray<char*>*: Service list				*/
/*  multi	: KNDMulti *	: Multiple graph object			*/
/*  appconf	: KConfig *	: Configuration information		*/
/*  (returns)	: KNDMonitor	:					*/

KNDMonitor::KNDMonitor
	(	KNDApp		*parent,
		int		slot,
		QArray<char *>	*iflist,
		QArray<char *>	*eplist,
		QArray<char *>	*iplist,
		QArray<char *>	*svlist,
		KNDMulti	*multi,
		KConfig		*appconf
	)
	:
	KNDView	(parent, slot, "Monitor", appconf)
{
	capture = new KNDPCap	 (graphic, packets, multi, slot) ;

	config  = new KNDConfMon (this, capture,
					graphic,
					packets,
					multi,
					slot,
					name,
					iflist,
					eplist,
					iplist,
					svlist,
					appconf) ;

	addTab	(config,  "Configuration"  ) ;
	addTab	(graphic, "Graphic display") ;
	addTab	(packets, "Packet monitor" ) ;
}

/*  KNDMonitor								*/
/*  ~KNDMonitor	: Destructor for view object				*/
/*  (returns)	:		:					*/

KNDMonitor::~KNDMonitor ()
{
	delete	capture ;
	delete	config  ;
}

/*  KNDMonitor								*/
/*  timerTick	: Pass down a timer tick				*/
/*  second	: long		: Second				*/
/*  (returns)	: void		:					*/

void	KNDMonitor::timerTick
	(	long	second
	)
{
	if (graphic != NULL) graphic->timerTick (second) ;
	if (packets != NULL) packets->timerTick (second) ;
}

/*  KNDMonitor								*/
/*  viewStart	: Start monitor						*/
/*  (returns)	: void		:					*/

void	KNDMonitor::viewStart ()
{
	config->monitorStart () ;
}

/*  KNDMonitor								*/
/*  viewStop	: Stop monitor						*/
/*  (returns)	: void		:					*/

void	KNDMonitor::viewStop ()
{
	config->monitorStop () ;
}

/*  KNDMonitor								*/
/*  viewFreeze	: Freeze monitor					*/
/*  (returns)	: void		:					*/

void	KNDMonitor::viewFreeze ()
{
	config->monitorFreeze () ;
}

/*  KNDMonitor								*/
/*  viewResume	: Resume monitor					*/
/*  (returns)	: void		:					*/

void	KNDMonitor::viewResume ()
{
	config->monitorResume () ;
}

/*  KNDMonitor								*/
/*  writeConfig	: Write monitor configuration				*/
/*  _config	: KConfig *	: Configuration object			*/
/*  (returns)	: void		:					*/

void	KNDMonitor::writeConfig
	(	KConfig	*_config
	)
{
	if (config != NULL) config->writeConfig (_config) ;
}

