/***************************************************************************
                          knd_setup.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include	<pwd.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>

#include	"knd_setup.h"

#define	CMDPATH	BINDIR "/ksnuffle"

bool	d_addr	   ;		/* Decode IP addresses to names		*/
bool	d_port	   ;		/* Decode IP ports to service names	*/
bool	j_priv	   ;		/* Just list privileged ports/services	*/
int	g_pauseat  ;
int	g_pausefor ;

/*  KNDSetup								*/
/*  KNDSetup	: Constructor for general selup object			*/
/*  parent	: KNDApp *	: Parent widget				*/
/*  uconf	: KConfig *	: Privileged user configuration		*/
/*  (returns)	: KNDSetup	:					*/

KNDSetup::KNDSetup
	(	KNDApp	*parent,
		KConfig	*uconf
	)
	:
	QWidget	(parent),
	g_opts	(this),
	g_users	(this),
	g_setuid(this),
	c_addr	(this),
	c_port	(this),
	c_privp	(this),
	l_pat	(this),
	s_pat	(this),
	l_pfor	(this),
	s_pfor	(this),
	b_savec	(this),
	u_all	(this),
	u_priv	(this),
	b_add	(this),
	b_rem	(this),
	b_remall(this),
	b_saveu	(this),
	b_setuid(this),
	uconf	(uconf)
{
	struct	passwd	*pw	;
 	KConfig	*gconf = kapp->getConfig () ;

	hide	() ;

	g_opts	.setGeometry ( 10, 10, 170, 260) ;
	g_users	.setGeometry (190, 10, 350, 260) ;
	g_setuid.setGeometry (550, 10, 150,  55) ;

	g_opts	.setTitle    (i18n ("Options")) ;
	g_users	.setTitle    (i18n ("Privileged users")) ;
	g_setuid.setTitle    (i18n ("SetUID root")) ;

	c_addr	.setGeometry ( 20,  30, 150,  25) ;
	c_addr	.setText     (i18n ("Decode IP addresses") ) ;
	c_port	.setGeometry ( 20,  60, 150,  25) ;
	c_port	.setText     (i18n ("Decode port numbers") ) ;
	c_privp	.setGeometry ( 20,  90, 150,  25) ;
	c_privp	.setText     (i18n ("List priv ports only")) ;

	QToolTip::add (&c_addr,  i18n ("Decode IP addresses to names"   )) ;
	QToolTip::add (&c_port,  i18n ("Decode port numbers to services")) ;
	QToolTip::add (&c_privp, i18n ("List only privileged ports"	)) ;

	l_pat	.setGeometry (20, 120, 60, 25) ;
	l_pat	.setText     (i18n ("Pause at" )) ;
	s_pat	.setGeometry (90, 120, 60, 25) ;
	s_pat	.setRange    (1, 200) ;
	l_pfor	.setGeometry (20, 150, 60, 25) ;
	l_pfor	.setText     (i18n ("Pause for")) ;
	s_pfor	.setGeometry (90, 150, 60, 25) ;
	s_pfor	.setRange    (1,  10) ;

	gconf->setGroup (i18n ("Global")) ;
	c_addr	.setChecked  (d_addr     = gconf->readBoolEntry ("DecodeIP",      true)) ;
	c_port	.setChecked  (d_port     = gconf->readBoolEntry ("DecodePorts",   true)) ;
	c_privp	.setChecked  (j_priv     = gconf->readBoolEntry ("JustPrivPorts", true)) ;
	s_pat   .setValue    (g_pauseat  = gconf->readNumEntry  ("PauseAt",	  15  )) ;
	s_pfor  .setValue    (g_pausefor = gconf->readNumEntry  ("PauseFor",	  2   )) ;

	b_savec .setGeometry ( 20, 225, 70,  25) ;
	b_savec .setText     (i18n ("Save")) ;

	connect	(&b_savec, SIGNAL(clicked()), this, SLOT(clickSaveSetup())) ;
	QToolTip::add (&b_savec, i18n ("Save global options")) ;

	/* If both the real and the effective UIDs are root, so that we	*/
	/* have been invoked by root (rather than being setuid-root)	*/
	/* then display and fill in the privileged user part of the	*/
	/* setup page. If not then this part is hidden.			*/
	if ((getuid () == 0) && (geteuid () == 0))
	{
		struct	stat	statb	;

		u_all	.setGeometry (200, 30, 120, 220) ;
		u_priv	.setGeometry (410, 30, 120, 220) ;
		b_add	.setGeometry (330, 30,  70,  25) ;
		b_add	.setText     (i18n ("Add >")    ) ;
		b_rem	.setGeometry (330, 60,  70,  25) ;
		b_rem	.setText     (i18n ("< Remove") ) ;
		b_remall.setGeometry (330, 90,  70,  25) ;
		b_remall.setText     (i18n ("<< RemAll")) ;

		b_setuid.setGeometry (560, 30, 130,  25) ;
		b_setuid.hide 	     () ;
		g_setuid.hide 	     () ;

		/* See about showing the setuid button. Only do this if	*/
		/* the command exists as expected, it has UID and GID	*/
		/* root, and cannot be written by anyone else. These	*/
		/* checks minimize hacking ....				*/
		if ( (stat (CMDPATH, &statb)    == 0) &&
		     (statb.st_uid              == 0) &&
		     (statb.st_gid              == 0) &&
		     ((statb.st_mode & S_IWOTH) == 0) )
		{
			setuid	= (statb.st_mode & (S_ISUID|S_ISGID)) == (S_ISUID|S_ISGID) ;
			b_setuid.show    () ;
			g_setuid.show    () ;
			b_setuid.setText (setuid ? i18n ("Disable SetUID Root") :
						   i18n ("Enable SetUID Root")) ;
			connect	(&b_setuid, SIGNAL(clicked()), this, SLOT(clickSetUID()))  ;
			QToolTip::add (&b_setuid, i18n ("Set/Unset setUid-root")) ;
		}

		QToolTip::add (&b_add,    i18n ("Add user to privileged list")) ;
		QToolTip::add (&b_rem,    i18n ("Remove user from privileged list")) ;
		QToolTip::add (&b_remall, i18n ("Remove all users from privileged list")) ;

		uconf->setGroup   ("Privilege") ;
		QString	priv	= uconf->readEntry ("users") ;
		char	*pptr	;

		if (!priv.isNull())
			for (pptr = strtok (priv, ",\n") ; pptr != NULL ; pptr = strtok (NULL, ",\n"))
				u_priv.insertItem (pptr) ;

		while ((pw = getpwent ()) != NULL)
			if ( (pw->pw_passwd[0] != '*') &&
			     (pw->pw_uid       !=   0) &&
			     (QLBFindItem (u_priv, pw->pw_name, -1) < 0) )
				u_all .insertItem (pw->pw_name) ;

		endpwent () ;

		b_saveu	.setGeometry (330, 225,  70,  25) ;
		b_saveu .setText     ("Save") ;
		QToolTip::add (&b_saveu, i18n ("Save privileged users")) ;

		/* Wire up the buttons. We also arrange that double-	*/
		/* clicking can add or remove users.			*/
		connect	(&b_saveu,  SIGNAL(clicked()),     this, SLOT(clickSaveUsers())) ;

		connect	(&b_add,    SIGNAL(clicked()),     this, SLOT(clickAddUser  ())) ;
		connect	(&b_rem,    SIGNAL(clicked()),     this, SLOT(clickRemUser  ())) ;
		connect	(&b_remall, SIGNAL(clicked()),     this, SLOT(clickRemAll   ())) ;

		connect	(&u_all,    SIGNAL(selected(int)), this, SLOT(clickAddUser  ())) ;
		connect	(&u_priv,   SIGNAL(selected(int)), this, SLOT(clickRemUser  ())) ;
	}
	else
	{
		g_users .hide () ;
		g_setuid.hide () ;
		u_all	.hide () ;
		u_priv	.hide () ;
		b_add	.hide () ;
		b_rem	.hide () ;
		b_remall.hide () ;
		b_saveu .hide () ;
		b_setuid.hide () ;
	}
}

/*  KNDSetup								*/
/*  ~KNDSetup	: Destructor for view object				*/
/*  (returns)	:		:					*/

KNDSetup::~KNDSetup ()
{
}


/*  KNDSetup								*/
/*  clickAddUser: Add selected user					*/
/*  (returns)	: void		:					*/

void	KNDSetup::clickAddUser ()
{
	int	item	;
	QString	name	;

	if ((item = u_all.currentItem()) >= 0)
	{	name = u_all.text  (item) ;
		u_all .removeItem  (item) ;
		u_priv.insertItem  (name) ;
	}
}

/*  KNDSetup								*/
/*  clickRemUser: Remove selected user					*/
/*  (returns)	: void		:					*/

void	KNDSetup::clickRemUser ()
{
	int	item	;
	QString	name	;

	if ((item = u_priv.currentItem()) >= 0)
	{	name = u_priv.text (item) ;
		u_priv.removeItem  (item) ;
		u_all .insertItem  (name) ;
	}
}

/*  KNDSetup								*/
/*  clickRemAll	: Remove all privileged users				*/
/*  (returns)	: void		:					*/

void	KNDSetup::clickRemAll ()
{
	while (u_priv.count () > 0)
	{	QString	name = u_priv.text (0) ;
		u_priv.removeItem (0) ;
		u_all .insertItem (name) ;
	}
}

/*  KNDSetup								*/
/*  clickSaveUsers: Save the privileged users setup			*/
/*  (returns)	  : void	:					*/

void	KNDSetup::clickSaveUsers ()
{

	if ((getuid () == 0) && (geteuid () == 0))
	{
		unsigned int slot  ;
		QString	     users ;

		for (users = "", slot = 0 ; slot < u_priv.count() ; slot += 1)
		{	if (slot > 0) users  += "," ;
			users += u_priv.text (slot) ;
		}

		uconf->setGroup   ("Privilege")     ;
		uconf->writeEntry ("users", users)  ;
		uconf->sync	  ()		    ;
	}
}

/*  KNDSetup								*/
/*  clickSaveSetup: Save the global setup options			*/
/*  (returns)	  : void	:					*/

void	KNDSetup::clickSaveSetup ()
{
 	KConfig	*gconf = kapp->getConfig () ;

	gconf->setGroup   ("Global") ;

	gconf->writeEntry ("DecodeIP",	    d_addr     = c_addr .isChecked()) ;
	gconf->writeEntry ("DecodePorts",   d_port     = c_port .isChecked()) ;
	gconf->writeEntry ("JustPrivPorts", j_priv     = c_privp.isChecked()) ;
	gconf->writeEntry ("PauseAt", 	    g_pauseat  = s_pat  .value()) ;
	gconf->writeEntry ("PauseFor", 	    g_pausefor = s_pfor .value()) ;

	gconf->sync () ;
}

/*  KNDSetup								*/
/*  clickSetUID	: Toggle setUID state					*/
/*  (returns)	: void		:					*/

void	KNDSetup::clickSetUID ()
{
	struct	stat	statb	;
	int	mode		;

	if ( (stat (CMDPATH, &statb)    == 0) &&
	     (statb.st_uid              == 0) &&
	     (statb.st_gid              == 0) &&
	     ((statb.st_mode & S_IWOTH) == 0) )
	{
		if (setuid)
			mode	= statb.st_mode & ~(S_ISUID|S_ISGID) ;
		else	mode	= statb.st_mode |  (S_ISUID|S_ISGID) ;

		if (chmod (CMDPATH, mode) != 0)
		{	Error	("KSnuffle setUid error", strerror(errno)) ;
			return	;
		}

		setuid	= !setuid ;
		b_setuid.setText (setuid ? i18n ("Disable SetUID Root") :
					   i18n ("Enable SetUID Root")) ;
	}
}

