/***************************************************************************
                          knd_multi.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 14:26:46 GMT 1999
                                           
    copyright            : (C) 1999 by Mike Richardson                         
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include	<stdio.h>

#include	"knd_multi.h"

#define	LOFFSETX	(10)
#define	LWIDTH		(80)
#define	LDEPTH		(20)
#define	HOFFSETX	(100)
#define	HOFFSETY	(10)
#define	HDEPTH		(50)
#define	HWIDTH		(500)
#define	HSPACE		(HDEPTH+10)
#define	NCDISP		(4)

extern	bool	checkBounds (int, int &, int &, int) ;


/*  QDragListBox							*/
/*  QDragListBox: Constructor for dragable list box			*/
/*  parent	: KNDMulti *	: Parent object				*/
/*  (returns)	: QDragListBox	:					*/

QDragListBox::QDragListBox
	(	KNDMulti	*parent
	)
	:
	QListBox (parent),
	parent	 (parent)
{
	mouseDownAt = -1 ;
	mouseUpAt   = -1 ;
}

/*  QDragListBox							*/
/*  mousePressEvent : Handle mouse press				*/
/*  e		    : QMouseEvent *	: Mouse event			*/
/*  (returns)	    : void		:				*/

void	QDragListBox::mousePressEvent
	(	QMouseEvent *e
	)
{
	/* Simply note the mouse position in terms of the offest into	*/
	/* the displayed list, then do the default processing.		*/
	mouseDownAt = findItem (e->y()) ;
	QListBox::mousePressEvent (e)   ;
}

void	QDragListBox::mouseReleaseEvent
	(	QMouseEvent *e
	)
{
	/* First, note the mouse position in terms of the offest into	*/
	/* the displayed list, then do the default processing.		*/
	mouseUpAt   = findItem (e->y()) ;
	QListBox::mousePressEvent (e)   ;

	/* If we now have mouse down and up positions, and they are	*/
	/* different, then move the entry at the down position to the	*/
	/* up position, and emit a signal to the outside world.		*/
	if ( (mouseUpAt   >= 0) &&
	     (mouseDownAt >= 0) && (mouseUpAt != mouseDownAt) )
	{
		QString	name	= text (mouseDownAt) ;

		removeItem (mouseDownAt) ;

		if (mouseUpAt < mouseDownAt)
			insertItem (name, mouseUpAt    ) ;
		else	insertItem (name, mouseUpAt - 1) ;

		emit moved (mouseDownAt, mouseUpAt) ;
	}

	/* All down for now so clear the positions for the next time	*/
	/* round.							*/
	mouseDownAt = -1 ;
	mouseUpAt   = -1 ;
}

/*  KNDClient								*/
/*  KNDClient	: Constructor for client histogram display		*/
/*  parent	: KNDMulti *	: Parent object				*/
/*  slot	: int		: Client slot				*/
/*  name	: const char *	: Client name				*/
/*  (returns)	: KNDClient	:					*/

KNDClient::KNDClient
	(	KNDMulti	*parent,
		int		slot,
		const char	*name
	)
	:
	parent	(parent),
	label	(parent),
	slot	(slot),
	name	(name)
{
	posn	= 0	;
	hist	= new KNDLoadHist (parent, HOFFSETX,
					   HOFFSETY,
					   HWIDTH,
					   HDEPTH, 1, false) ;

	label.setGeometry (LOFFSETX, HOFFSETY, LWIDTH, LDEPTH) ;
	label.setText	  (name) ;

	connect	(hist, SIGNAL(doubleClick()), this, SLOT(doubleClick())) ;
}

/*  KNDClient								*/
/*  KNDClient	: Destructor for client histogram display		*/
/*  (returns)	:		:					*/

KNDClient::~KNDClient ()
{
	delete	hist	;
}

/*  KNDClient								*/
/*  setOrder	: Set display order					*/
/*  _posn	: int		: Position				*/
/*  (returns)	: void		:					*/

void	KNDClient::setOrder
	(	int	_posn
	)
{
	/* If the position is within the range of clients that can	*/
	/* actually be displayed, set the positions of the histogram	*/
	/* and label, and make sure that both are shown. If not then	*/
	/* just hide them.						*/
	if ((posn = _posn) < NCDISP)
	{
		hist->setGeometry (HOFFSETX,
				   HOFFSETY + HSPACE * posn,
				   HWIDTH,
				   HDEPTH) ;
		label.setGeometry (LOFFSETX,
				   HOFFSETY + HSPACE * posn,
				   LWIDTH,
				   LDEPTH) ;
		hist->show () ;
		label.show () ;
	}
	else
	{	hist->hide () ;
		label.hide () ;
	}
}

/*  KNDClient								*/
/*  addPacket	: Add a packet to the display				*/
/*  pktinfo	: PktInfo *	: Packet information			*/
/*  (returns)	: void		:					*/

void	KNDClient::addPacket
	(	PktInfo	*pktinfo
	)
{
	hist->addPacket (pktinfo) ;
}

/*  KNDClient								*/
/*  setScale	: Pass new scale to histogram				*/
/*  scale	: int		: New scale				*/
/*  (returns)	: void		:					*/


void	KNDClient::setScale
	(	int	scale
	)
{
	hist->setScale (scale) ;
}

/*  KNDClient								*/
/*  timerTick	: Handle a timer tick					*/
/*  second	: long		: Second				*/
/*  (returns)	: int		: Current scale				*/

int	KNDClient::timerTick
	(	long	second
	)
{
	return	hist->timerTick (second) ;
}

/*  KNDClient								*/
/*  repaint	: Pass repaint on to histogram				*/
/*  (returns)	: void		:					*/

void	KNDClient::repaint ()
{
	if (posn < NCDISP) hist->repaint () ;
}

/*  KNDClient								*/
/*  doubleClick	: Handle double clock fromnload histogram		*/
/*  (returns)	: void		:					*/

void	KNDClient::doubleClick ()
{
	/* The event is passed to the KNDMulti parent, specifying the	*/
	/* slot associated with this client.				*/
	parent->showClient (slot) ;
}


/*  KNDMulti								*/
/*  KNDMulti	: Constructor for multiple load graph object		*/
/*  parent	: KNDApp *	: Parent widget				*/
/*  (returns)	: KNDMulti	:					*/

KNDMulti::KNDMulti
	(	KNDApp		*parent
	)
	:
	QWidget	(parent),
	parent	(parent),
	period	(this),
	scale	(this),
	order	(this)
{
	char	text[32]	;

	clients.resize (MAXMON) ;
	clients.fill   (NULL  ) ;

	sccurr	= MINLOAD  ;
	scdown	= MINLOAD  ;

	order.setGeometry (HOFFSETX + HWIDTH + 30,
			   HOFFSETY,
			   100,
			   HSPACE * (NCDISP-1) + HDEPTH) ;

	connect	(&order, SIGNAL(selected(int)),  this, SLOT(selected(int))) ;
	connect	(&order, SIGNAL(moved(int,int)), this, SLOT(reOrder(int, int))) ;

	period.setGeometry (HOFFSETX, 	    HOFFSETY + NCDISP * HSPACE,	100, 25) ;
	scale .setGeometry (HOFFSETX + 110, HOFFSETY + NCDISP * HSPACE, 150, 25) ;

	sprintf	(text, "%d secs",	HWIDTH) ;
	period.setText (text) ;
	sprintf	(text, "%d bytes/sec",	sccurr) ;
	scale .setText (text) ;
}

/*  KNDMulti								*/
/*  ~KNDMulti	: Destructor for view object				*/
/*  (returns)	:		:					*/

KNDMulti::~KNDMulti ()
{
}

/*  KNDMulti								*/
/*  rePlace	: Replace clients on display				*/
/*  (returns)	: void		:					*/

void	KNDMulti::rePlace ()
{
	KNDClient	*client	= ondisp.first () ;
	int		posn	= 0 ;

	while (client != NULL)
	{	client->setOrder (posn) ;
		client = ondisp.next () ;
		posn  += 1 ;
	}
}

/*  KNDMulti								*/
/*  reOrder	: Completely reorder clients				*/
/*  (returns)	: void		:					*/

void	KNDMulti::reOrder
	(	int	removeAt,
		int	insertAt
	)
{
	KNDClient *client = ondisp.at (removeAt) ;
printf ("move %s\n", (const char *)client->getName()) ;
	ondisp.remove (removeAt) ;
	if (insertAt < removeAt)
		ondisp.insert (insertAt,     client) ;
	else	ondisp.insert (insertAt - 1, client) ;

	rePlace	() ;
}

/*  KNDMulti								*/
/*  Register	: Register a new client					*/
/*  slot	: int		: Unique slot number			*/
/*  name	: const char *	: Client name				*/
/*  (returns)	: void		:					*/

void	KNDMulti::Register
	(	int		slot,
		const char	*name
	)
{
	order .insertItem (name, 0) ;
	ondisp.insert     (0, clients[slot] = new KNDClient (this, slot, name)) ;
	rePlace	() ;
}

/*  KNDMulti								*/
/*  unRegister	: Unregister a new client				*/
/*  slot	: int		: Slot number of client			*/
/*  (returns)	: void		:					*/

void	KNDMulti::unRegister
	(	int	slot
	)
{
	KNDClient	*client	;

	if ((client = clients[slot]) != NULL)
	{
		order .removeItem (QLBFindItem (order, client->getName())) ;
		ondisp.remove     (client) ;

		delete	       client ;
		clients[slot]  = NULL ;

		rePlace	() ;
	}
}

/*  KNDMulti								*/
/*  addPacket	: Add a packet						*/
/*  pktinfo	: PktInfo *	: Packet information			*/
/*  slot	: int		: Client slot number			*/
/*  (returns)	: void		:					*/

void	KNDMulti::addPacket
	(	PktInfo	*pktinfo,
		int	slot
	)
{
	if (clients[slot] != NULL) clients[slot]->addPacket (pktinfo) ;
}

/*  KNDMulti								*/
/*  timerTick	: Handle a timer tick					*/
/*  second	: long		: Second				*/
/*  (returns)	: void		:					*/

void	KNDMulti::timerTick
	(	long	second
	)
{
	KNDClient	*client	;
	int		posn	;
	int		scmax	;
	int		schist	;
	bool		changed	;

	/* First pass is to hand the timer tick to each of the client	*/
	/* load histograms. As we go, note the maximum scale over those	*/
	/* that are actually visible (or would be if this is the	*/
	/* current display).						*/
	client	= ondisp.first () ;
	scmax	= 0		  ;
	posn	= 0		  ;

	while (client != NULL)
	{
		schist	= client->timerTick (second) ;
		assert	(schist < 2000000) ;
		if ((posn < NCDISP) && (schist > scmax)) scmax = schist ;

		client	= ondisp.next () ;
		posn   += 1 ;
	}

	/* Now, if we are on display, repaint all those histograms	*/
	/* that are currently visible.					*/
	if (onview)
	{
		changed	= checkBounds (scmax, sccurr, scdown, MINLOAD) ;

		for (client = ondisp.first () ; client != NULL ; client = ondisp.next ())
		{	if (changed) client->setScale (sccurr) ;
			client->repaint  () ;
		}

		if (changed && (ondisp.first() != NULL))
		{	char	text[32] ;
			sprintf	(text, "%d bytes/sec", sccurr) ;
			scale.setText (text) ;
		}
	}
}

/*  KNDMulti								*/
/*  setOnview	: Set the on-view state					*/
/*  _onview	: bool		: New state				*/
/*  (returns)	: void		:					*/

void	KNDMulti::setOnview
	(	bool	_onview
	)
{
	onview	= _onview ;
}

/*  KNDMulti								*/
/*  selected	: Notification for selection in client list		*/
/*  (returns)	: void		:					*/

void	KNDMulti::selected
	(	int	slot
	)
{
	QString	  name	  ;
	KNDClient *client ;

	/* Get the name of the selected client and scan the display	*/
	/* list to find it. Assu,ing that it is (and it really should	*/
	/* be) then it is moved to the top of this display, and the	*/
	/* clients reordered.						*/
	name	= order .text  (slot) ;
	client	= ondisp.first () ;

	while (client != NULL)
		if (strcmp (name, client->getName()) == 0)
			break	;
		else	client	= ondisp.next () ;

	if (client == NULL) return ;

	ondisp.remove (client) ;
	ondisp.insert (0, client) ;
	rePlace () ;

	/* Mirror the change by bringing the name to the top of the	*/
	/* list.							*/
	order .removeItem (slot) ;
	order .insertItem (name, 0) ;
}

/*  KNDMulti								*/
/*  showClient	: Request to show client				*/
/*  slot	: int		: Client slot				*/
/*  (returns)	: void		:					*/

void	KNDMulti::showClient
	(	int	slot
	)
{
	parent->showClient (slot) ;
}
