#ifndef _KIFSTATS_H
#define _KIFSTATS_H


#include <qsocketnotifier.h> 
#include <qlistview.h>
#include <qlayout.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <netdb.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h> 
 
#include "ipcsum.h"
#include "options.h"
/***

ifstats.h - structure definitions for interface counts
	
***/

struct iflist {
    char ifname[8];
    unsigned int encap;
    unsigned long iptotal;
    unsigned long badtotal;
    unsigned long noniptotal;
    unsigned long total;
    unsigned int spanbr;
    unsigned long br;
    float rate;
    float peakrate;
    unsigned int index;
    struct iflist *prev_entry;
    struct iflist *next_entry;

    unsigned long starttime;
    QListViewItem *listviewitem;
};

struct iftab {
    struct iflist *head;
    struct iflist *tail;
    struct iflist *firstvisible;
    struct iflist *lastvisible;
};

struct ifstat_brackets {
    unsigned int floor;
    unsigned int ceil;
    unsigned long count;
};

struct iftotals {
    unsigned long total;
    unsigned long bytestotal;
    unsigned long iptotal;
    unsigned long ipbtotal;
    unsigned long noniptotal;
    unsigned long nonipbtotal;
    unsigned long tcptotal;
    unsigned long tcpbtotal;
    unsigned long udptotal;
    unsigned long udpbtotal;
    unsigned long icmptotal;
    unsigned long icmpbtotal;
    unsigned long othtotal;
    unsigned long othbtotal;
    unsigned long badtotal;

    unsigned long arptotal;
    unsigned long arpbtotal;
    unsigned long rarptotal;
    unsigned long rarpbtotal;
    unsigned long ipxtotal;
    unsigned long ipxbtotal;
   

    unsigned int interval;
    struct ifstat_brackets brackets[16];
};


/* Struct to tell us how to manage the dynamic 
   Number of columns to display.  Each val in 
   struct holds the column # for each stat.   */
struct gen_col {
    int numcols;
    int total;
    int total_ip;
    int non_ip;
    int bad_ip;
    int activity;
};

/* Struct to tell us how to manage the dynamic 
   Number of columns to display.  Each val in 
   struct holds the column # for each stat.   */
struct det_col {
    int numcols;
    int pkts;
    int bytes;
    int activity;
};

//This starts up the Generic stats 
class IfStatsGeneral : public QWidget
{
  Q_OBJECT;

  public:
    struct iftab table;
    QListView *mylistview;
    QTimer *mytimer;
    QGridLayout *mylayout;

    unsigned long starttime;
    unsigned long statbegin;
    unsigned long now;
    unsigned long long unow;
    unsigned long startlog;
    unsigned long updtime;
    unsigned long long updtime_usec;
    struct timeval tv;
    struct OPTIONS *options;
    int fd;

    IfStatsGeneral(QWidget *parent, struct OPTIONS *appoptions);
    ~IfStatsGeneral(void);

    void updateOptions(struct OPTIONS *appoptions);

  private:
    QString *tempstr, *tempstr2;
    struct gen_col gencolumns;

  protected:
    QSocketNotifier *mycallback;
    void initiflist(struct iflist **list);

  protected slots:
    void dataReceived(int);
    void timerDone();
};



//This starts up the Generic stats 
class IfStatsDetailed : QWidget
{
  Q_OBJECT;

  public:
    struct iftab table;
    QListView *mylistview;
    QTimer *mytimer;

    unsigned long starttime;
    unsigned long statbegin;
    unsigned long now;
    unsigned long long unow;
    unsigned long startlog;
    unsigned long updtime;
    unsigned long long updtime_usec;
    struct timeval tv;
    struct OPTIONS *options;
    int fd;
    char ifname[8];

    IfStatsDetailed(QWidget *parent, char *iface, struct OPTIONS *appoptions);
    ~IfStatsDetailed(void);
    void updateOptions(struct OPTIONS *appoptions);

  private:
    QListViewItem *totalsitem;
    QListViewItem *ipitem;
    QListViewItem *tcpitem;
    QListViewItem *udpitem;
    QListViewItem *icmpitem;
    QListViewItem *otheripitem;
    QListViewItem *nonipitem;
    QListViewItem *arpitem;
    QListViewItem *rarpitem;
    QListViewItem *ipxitem;
    QString *rcvstr;
    QString *timerstr;
    struct iftotals totals;
    float spanbr;
    float spanpkt;
    float activity;
    float peakactivity;
    float pps;
    float peakpps;
    struct det_col detcolumns;
    int initialize_brackets(char *ifname, struct iftotals *ttmp);


  protected:
    QSocketNotifier *mycallback;

    void initiflist(struct iflist **list);

  protected slots:
    void dataReceived(int);
    void timerDone();
};
#endif
