#ifndef _KPORTSTATS_H
#define _KPORTSTATS_H

#include <ktopwidget.h>
#include <kmenubar.h>
#include <qmultilinedit.h>
#include <qobject.h>
#include <qsocketnotifier.h> 
#include <qframe.h>
#include <qlistview.h>
#include <qstring.h>
#include <termios.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>

#include "options.h"

/***

serv.h  - TCP/UDP port statistics header file
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997

***/
void initportlist(struct portlist *list);
struct portlistent *inportlist(struct portlist *list, unsigned int protocol,
			       unsigned int port);
int goodport(unsigned int port, struct porttab *table);
int portinlist(struct porttab *table, unsigned int port);
void printportent(struct portlist *list, struct portlistent *entry,
		  unsigned int idx);
void destroyportlist(struct portlist *list);
void addmoreports(struct porttab **table);
int loadaddports(struct porttab **table);
void destroyporttab(struct porttab *table);
void removeaport(struct porttab **table);


struct portlistent {
    unsigned int port;
    unsigned int protocol;
    char servname[11];
    unsigned int idx;
    unsigned long count;
    unsigned long bcount;
    unsigned long icount;
    unsigned long ibcount;
    unsigned long ocount;
    unsigned long obcount;
    struct portlistent *prev_entry;
    struct portlistent *next_entry;
 
    unsigned long starttime;
    unsigned int spanbr;
    QListViewItem *listviewitem;
};

struct portlist {
    struct portlistent *head;
    struct portlistent *tail;
    struct portlistent *firstvisible;
    struct portlistent *lastvisible;
    unsigned int count;
    unsigned long bcount;
};

struct porttab {
    unsigned int port_min;
    unsigned int port_max;
    struct porttab *prev_entry;
    struct porttab *next_entry;
    QListViewItem *listviewitem;
};

/* Struct to tell us how to manage the dynamic 
   Number of columns to display.  Each val in 
   struct holds the column # for each stat.   */
struct port_col {
    int numcols;
    int pkts;
    int bytes;
    int pkts_to;
    int bytes_to;
    int pkts_from;
    int bytes_from;
    int activity;
};


//This starts up the Generic stats 
class IpPortStats : QWidget
{
  Q_OBJECT;

  public:
    //struct iftab table;
    QListView *mylistview;

    unsigned long starttime;
    unsigned long timeint;
    unsigned long startlog;
    unsigned long statbegin;
    unsigned long now;
    unsigned long long unow;
    unsigned long updtime;
    unsigned long long updtime_usec;
    struct timeval tv;
    struct OPTIONS *options;
    struct porttab *ports;
    int fd;
    char ifname[8];
    int csum, ck, ch, br;
    int logging;
    unsigned int sport, dport;
    unsigned int firstin;
    struct portlist list;


    IpPortStats(QWidget *parent, char *ifname, struct OPTIONS *appoptions);
    ~IpPortStats(void);

    void updateOptions(struct OPTIONS *appoptions);



  private:
    QString *tmpstr;
    struct port_col portcol;
    QTimer *mytimer;
    QString *tempstr;

    struct portlistent *addtoportlist(struct portlist *list,
          unsigned int protocol, unsigned int port, int *nomem, int servnames);

    void printport(struct portlist *list, unsigned int protocol,
             unsigned int port, int br, unsigned int idx, int fromto,
             struct porttab *ports, int servnames);

    struct portlistent *inportlist(struct portlist *list,
             unsigned int protocol, unsigned int port);

    void printportent(struct portlist *list, struct portlistent *entry,
		  unsigned int idx);

    int portinlist(struct porttab *table, unsigned int port);
    int goodport(unsigned int port, struct porttab *table);
    void initportlist(struct portlist *list);
 

  protected:
    QSocketNotifier *mycallback;

    void initiflist(struct iflist **list);

  protected slots:
    void dataReceived(int fd);
    void timerDone();
};

#endif
