// -*- c++ -*-

#ifndef PSION_H
#define PSION_H

#include "protocol.h"
#include "kio_errors.h"
#include <bufferstore.h>
#include <bufferarray.h>
#include <rfsv32.h>

class ppsocket;

/**
 * @short Access to EPOC hand-held devices such as the Psion 5.
 *
 * Makes the drives on a Psion 5 (or other EPOC handheld) available to KDE applications.
 * This class provides a KProtocol binding to the rsfv32 implementation of the Psion
 * Link Protocol, it requires Phil Proudman's ncpd to be running. This is all based
 * on the code from the plptools-0.3 package.
 *
 * This class makes use of code by:
 * <UL>
 * <LI>Fritz Elfert
 * <LI>Rudolf Koenig (rfkoenig@immd4.informatik.uni-erlangen.de)
 * <LI>Philip Proudman
 * </UL>
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id$
 */
class KProtocolPsion : public KProtocol
{
  Q_OBJECT

 public:
  KProtocolPsion();
  ~KProtocolPsion();

  //
  // Utilities
  //
  const QString &urlToPath( const KURL &url );
  bool hasQuery( const KURL &url );
  void buildEntry( bufferStore &store );
  int throwError( long psionErrCode );
  int mapErrorCode( long psionErrCode );
  int openQuery( const KURL &url );

  //
  // Protocol API
  //

  // File access

  virtual int Open(KURL *url, int mode);
  virtual long Read(void *buffer, long nbytes);
  virtual long Write(void *buffer, long nbytes);
  virtual int Close();
  virtual int atEOF();
  virtual long Size();

  virtual int Delete(KURL *url);

  // Dir access

  virtual int OpenDir(KURL *url);
  /**
   * @return TRUE if one made a call to @ref #OpenDir and if the result of
   *              this is some HTML. For example the file protocol will
   *              devliver HTML code if it finds some "index.html" file in
   *              the directory.
   */
  virtual bool isHTML();

  /**
   * Allows or disallows @ref #OpenDir to deliver HTML code instead of
   * @ref #KProtocolDirEntry items.
   */
  virtual void AllowHTML( bool );
  /**
   * Call this function if a call top @ref #OpenDir results in some HTML code.
   * This function will use '_ipc' to emit this HTML code.
   * This is the alternative to @ref #ReadDir depending on @ref #isHTML.
   */
  //  virtual void EmitData( KIOSlaveIPC* );
  virtual KProtocolDirEntry *ReadDir();
  virtual int CloseDir();
  virtual int MkDir(KURL *url);

  /**
   * @return -1 if we dont know about permissions
   */
  //  virtual int GetPermissions( KURL &_u );
  /**
   * If '_perm' is -1, then we wont set any permissions here.
   */
  //  virtual void SetPermissions( KURL &_u, int _perm );   

signals:
  void mimeType( const char* );
  void info( const char* );


private:
  //* The currently active file or directory path
  QString filename;
  //* Are we at the end of this file?
  bool reachedEOF;
  //* Structure returned by rfsv32 dir() method
  bufferArray dirContents;

  QString path;
  bool allowHTML;
  bool readingDir;
  long handle;
  KProtocolDirEntry entry;
  rfsv32 *psion;
  ppsocket *psionSocket;
};

#endif // PSION_H
