/*
 * keyring.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __KPGPKEYRING_H__
#define __KPGPKEYRING_H__

#include <stdio.h>
#include <iostream.h>

#include <qframe.h>
#include <qmsgbox.h>
#include <qradiobt.h> 
#include <qpixmap.h>
#include <qgrpbox.h> 
#include <qpainter.h>
#include <qbttngrp.h>
#include <qlcdnum.h>

#include <qbttngrp.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlayout.h>
#include <qdict.h>

#include <ktreelist.h>
#include <kiconloader.h>
#include <kcontrol.h>

#include "key.h"
#include "mytreelist.h"

class KPGPKeyring : public KConfigWidget
{
  Q_OBJECT;
  
public:
  
  KPGPKeyring( QWidget *parent=0, const char* name=0 );
  ~KPGPKeyring( );
  
  void  resizeEvent(QResizeEvent *e);
  
  void loadSettings();
  void applySettings();
  
public slots:
  
  void slotKeyPopup(int menu);
  void slotUserPopup(int menu);
  void slotSigPopup(int menu);
  
  void slotRightPopupMenu(int index, QPoint pos);
  void slotLeftPopupMenu(int index, QPoint pos);
  
private:
  
  bool            openConfig(QString name);
  void            readKeyList(QFile &file);
  
  MyTreeList      *list;
  
  bool            config_found;
  QString         config_name;
  
  KSimpleConfig   *config;
  
  QPopupMenu      *keyLeftPopup;
  QPopupMenu      *keyRightPopup;
  QPopupMenu      *seckeyRightPopup;
  QPopupMenu      *userPopup;
  QPopupMenu      *sigPopup;
  QPopupMenu      *popup;
  
  QDict<KPGPKey>  keyDict;
  
  QString         MYNAME;
};

#endif

