// -*- C++ -*-

//
//  konserver
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <mystring.h>

char MyString::empty = 0;

MyString::MyString()
{
  buf = &empty;
  len = 0;
}

MyString::MyString(const MyString &s)
{
  unsigned long i;
  if( s.len == 0 )
    {
      buf = &empty;
      len = 0;
    }
  else 
    {
      len = s.len;
      buf = new char[len+1];
      for( i = 0; i <= len; i++ )
	buf[i] = s.buf[i];
    }
}

MyString::MyString(const char *s)
{
  unsigned long i = 0;
  if( s[0] == 0 )
    {
      buf = &empty;
      len = 0;
    }
  else
    {
      while( s[i] != 0 )
	i++;
      len = i;
      buf = new char[len+1];
      for( i = 0; i <= len; i++ )
	{
	buf[i] = s[i];
	}
    }
}

MyString::MyString(unsigned long l, char c)
{
  unsigned long i;
  len = l;
  buf = new char[len+1];
  for( i = 0; i < len; i++ )
    buf[i] = c;
  buf[len] = 0;
}

MyString MyString::substr(unsigned long begin, unsigned long l)
{
  MyString new_str;
  new_str.assign( *this, begin, l );
  return new_str;
} 

MyString& MyString::assign( const MyString &s, unsigned long begin, unsigned long l)
{
  unsigned long i;
  if( len != 0 )
    delete [] buf;
  if( begin >= s.len || l == 0 )
    {
      len = 0;
      buf = &empty;
    }
  else
    {
      if( begin+l > s.len )
	len = s.len - begin ;
      else
	len = l;
      buf = new char[len+1];
      for( i = 0; i < len; i++ )
	buf[i] = s.buf[begin+i];
      buf[len] = 0;
    }
  return *this;
}

unsigned long MyString::find(char c)
{
  unsigned long i;
  for( i = 0; i < len; i++ )
    {
      if( buf[i] == c )
	return i;
    }
  return 0;
}

MyString::operator ==(const MyString &s)
{
  unsigned long i;
  if( len != s.len )
    return 0;
  for( i = 0; i < len; i++ )
    {
      if( buf[i] != s.buf[i] )
	return 0;
    }
  return 1;
}









