#ifndef konline_included
#define konline_included

/*---------- headerfile for konline.ddl ----------*/
/* alignment is 4 */

/*---------- structures ----------*/
struct users {  /* size 215 */
    unsigned long    user_id;
    char    name[41];
    char    vname[41];
    char    nick[21];
    char    date[16];
    char    email[81];
    char    passwd[11];
};

struct message {  /* size 284 */
    short   msg_id;
    unsigned long    send_id;
    unsigned long    recv_id;
    char    msg[256];
    char    date[16];
};

struct watch {  /* size 8 */
    unsigned long    wuser_id;
    unsigned long    watch_id;
};

struct watch_key {  /* size 8 */
    unsigned long    wuser_id;
    unsigned long    watch_id;
};

/*---------- record names ----------*/
#define USERS 1000L
#define MESSAGE 2000L
#define WATCH 3000L

/*---------- field names ----------*/
#define USER_ID 1001L
#define NAME 1002L
#define VNAME 1003L
#define NICK 1004L
#define USERS_DATE 1005L
#define EMAIL 1006L
#define PASSWD 1007L
#define MSG_ID 2001L
#define SEND_ID 2002L
#define RECV_ID 2003L
#define MSG 2004L
#define MESSAGE_DATE 2005L
#define WUSER_ID 3001L
#define WATCH_ID 3002L

/*---------- key names ----------*/
#define WATCH_KEY 6

/*---------- sequence names ----------*/
#define UUSER_ID 0
#define UMSG_ID 1

/*---------- integer constants ----------*/

#endif
