// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef confdialog_included
#define confdialog_included

#include <qdialog.h>

class KTabCtl;
class QPushButton;
class QLineEdit;
class QLabel;
class QComboBox;
class QRadioButton;
class QCheckBox;
class QButtonGroup;
class KHeader;
class MyRowTable;

class PasswdDialog : public QDialog
{
  Q_OBJECT
public:
  PasswdDialog (QWidget *parent, int mode = 0);
  ~PasswdDialog () {}

  QString getPasswd() { return le_passwd->text(); }
  unsigned long getId();
  void restart();

protected slots:
  void accept();

protected:
  int          newpasswd;
  QPushButton *b_ok;
  QPushButton *b_cancel;
  QLineEdit   *le_passwd;
  QLineEdit   *le_passwd2;
  QLineEdit   *le_id;
};

class RegisterUser : public QDialog
{
  Q_OBJECT
public:
  RegisterUser (QWidget *parent, QString pass);
  ~RegisterUser () {}

  void writeConfig();
  int exec();
  QString getPasswd() { return passwd; }

protected slots:
  void createAccount();
  void changeAccount();
  void removeAccount();
  void chooseAccount();

protected:
  void readConfig();

  QPushButton *b_ok;
  QPushButton *b_cancel;
  QLineEdit   *le_name;
  QLineEdit   *le_fname;
  QLineEdit   *le_nname;
  QLineEdit   *le_email;
  QLineEdit   *le_id;
  QPushButton *b_create;
  QPushButton *b_remove;
  QPushButton *b_change;
  QPushButton *b_account;

  QString        ip;
  QString        passwd;
  unsigned short port;
};

class AddWatchList : public QDialog
{
  Q_OBJECT
public:
  AddWatchList (QWidget *parent);
  ~AddWatchList () {}

protected slots:
  void subSearch();
  void addWatchList();
  void doubleClick(int, int) { addWatchList(); }

protected:
  void readConfig();

  QPushButton *b_ok;
  QComboBox   *c_w_key;
  QLineEdit   *le_w_name;
  QLineEdit   *le_w_fname;
  QLineEdit   *le_w_nname;
  QLineEdit   *le_w_email;
  QLineEdit   *le_w_id;
  QPushButton *b_w_add;
  QPushButton *b_w_search;
  MyRowTable  *lb_w_list;
  KHeader     *h_w_list;
  
  QString        ip;
  QString        passwd;
  unsigned short port;
  unsigned long  my_id;
};

class ConfDialog : public QDialog
{
  Q_OBJECT
public:
  ConfDialog (QWidget *parent);
  ~ConfDialog () {}

  void writeConfig();

protected slots:

protected:
  void readConfig();
  
  KTabCtl     *tabbar;
  QPushButton *b_ok;
  QPushButton *b_cancel;

  // account
  QLineEdit   *le_port;
  QLineEdit   *le_ip;

  // secure
  QButtonGroup *bb_ip;
  QCheckBox    *cb_passwd;
  QRadioButton *rb_never;
  QRadioButton *rb_ask;
  QRadioButton *rb_always;

};



#endif //confdialog_included
