// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.imv.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qpixmap.h>

#include <kapp.h>
#include <kiconloader.h>

#include "users.h"
#include "watchlist.h"
#include "watchlist.moc"

extern QPixmap *online_pix;
extern QPixmap *offline_pix;

#define global_pix_loader KApplication::getKApplication()->getIconLoader()

MyRow::MyRow(User *row, bool a)
{
  active = a;
  name.setStr(row->name);
  fname.setStr(row->fname);
  nname.setStr(row->nname);
  email.setStr(row->email);
  id = row->id;
}

void MyRow::paint( QPainter *p, int col, int width )
{
  int fontpos = ( p->fontMetrics().lineSpacing() - p->fontMetrics().lineSpacing())/2;
  QString id_str;
  int dx, dy;
  switch( col )
    {
    case 0: // active
      dx = ( width - 16 ) / 2;
      dy = 0; //( QTableView::cellHeight() - 16 ) / 2;
      if( active )
	p->drawPixmap(dx, dy, *online_pix );
      else
	p->drawPixmap(dx, dy, *offline_pix );
      break;
    case 1: // name
      p->drawText( 3, fontpos, width, p->fontMetrics().lineSpacing(),
		   AlignLeft,
		   name );
      break;
    case 2: // fname
      p->drawText( 3, fontpos, width, p->fontMetrics().lineSpacing(),
		   AlignLeft,
		   fname );
      break;
    case 3: // nname
      p->drawText( 3, fontpos, width, p->fontMetrics().lineSpacing(),
		   AlignLeft,
		   nname );
      break;
    case 4: // email
      p->drawText( 3, fontpos, width, p->fontMetrics().lineSpacing(),
		   AlignLeft,
		   email );
      break;
    case 5: // id
      id_str.setNum(id);
      p->drawText( 3, fontpos, width, p->fontMetrics().lineSpacing(),
		   AlignLeft,
		   id_str );
      break;
    }
}

//-------------------------------------------
//  myRowTable
//-------------------------------------------

MyRowTable::MyRowTable( QWidget *parent, const char *name )
  : KRowTable( SelectRow, parent, name )
{
  setCellHeight( fontMetrics().lineSpacing() );
  setNumCols( 6 );
  setStyle(MotifStyle);
}

void MyRowTable::insertItem( User *row, bool active )
{
  MyRow *new_row = new MyRow(row, active);
  setNumRows( numRows() + 1 );
  insertRow( new_row, numRows()-1 );
  if( isUpdatesEnabled() )
    repaint();
}

void MyRowTable::clear()
{
  setTopCell( 0 );
  setNumRows( 0 );
  if( isUpdatesEnabled() )
    updateScrollBars();
  KRowTable::clear();
}

void MyRowTable::setCurrentItem(int row)
{
  setCurrentRow( row, -1 );
}

unsigned long MyRowTable::accId(int row)
{
  return ((MyRow *) getRow(row))->accId();
}



