/***************************************************************************
                          knetdump.cpp  -  description                              
                             -------------------         
    begin                : Mon Mar 29 14:39:40 CEST 1999
                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <knetdump.h>

KnetdumpApp::KnetdumpApp()
{
  setCaption("Knetdump " VERSION);

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  
  pdoc = new KnetdumpDoc(this);
  connect(pdoc, SIGNAL(stoppedDoc()), this, SLOT(slotDocIsStopped()));
  connect(pdoc, SIGNAL(startedDoc()), this, SLOT(slotDocIsStarted()));
  connect(pdoc, SIGNAL(pausedDoc()), this, SLOT(slotDocIsPaused()));
  // pdoc->start();
  setMinimumWidth(500);

  // uid == root ?
  if (geteuid()!= 0) {
      KMsgBox::message( this, i18n("Message"), i18n("Knetdump won't work without uid root!"));
      close();
      exit(1);
  }

  /* // starts annoying welcome screen on startup
     if (welcome) {
     KMsgBox::message( this, i18n("Welcome to knetdump-"VERSION), i18n(""));
     close();
     exit(1);
     }  */ 

  // start ktrafficview
  initView(TRAFFIC);
}

KnetdumpApp::~KnetdumpApp() {
}

void KnetdumpApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KnetdumpApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KnetdumpApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertItem(i18n("New &Window"), ID_FILE_NEW_WINDOW );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("C&lose Window"), ID_FILE_CLOSE_WINDOW);
  file_menu->insertSeparator();
  
  file_menu->insertItem(i18n("Exit"), ID_FILE_QUIT );

  // file_menu key accelerators
  file_menu->setAccel(CTRL+Key_W, ID_FILE_CLOSE_WINDOW);
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );
  view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  view_menu->insertSeparator();
  view_menu->insertItem(Icon("mini/mini-ksniffer.xpm"), "K&Sniffer", ID_VIEW_KSNIFFER);
  view_menu->insertSeparator();
  view_menu->insertItem(Icon("mini/kblackbox.xpm"), i18n("ISO/OSI Layermodel"), ID_VIEW_OSI);
  view_menu->insertSeparator();
  view_menu->insertItem("&TrafficView", ID_VIEW_TRAFFIC);
  view_menu->insertItem("&HeaderView", ID_VIEW_HEADER);
  view_menu->insertItem("&ChatView", ID_VIEW_CHAT);
  view_menu->insertItem("&StatsView", ID_VIEW_STATS);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry option_menu
  option_menu = new QPopupMenu();
  option_menu->insertItem(Icon("mini/kcontrol.xpm"), i18n("Configure & Filter"), ID_OPTION_CONF);
  // option_menu->insertItem(i18n("Filter"), ID_OPTION_FILTER);
  file_menu->insertSeparator();
  option_menu->insertItem(Icon("mini/play.xpm"), i18n("Start Sniffing"), ID_PROCEEDDOC);
  option_menu->insertItem(Icon("mini/pause.xpm"), i18n("Pause Sniffing"), ID_PAUSEDOC);
  file_menu->insertSeparator();
  option_menu->insertItem(i18n("Delete ARP table entry"), ID_OPTION_DARP);
  option_menu->insertItem(i18n("Clears statistics of devices"), ID_OPTION_CSTATS);
  option_menu->insertItem(i18n("Delete all stored packets"), ID_OPTION_DPACKET);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(IDS_APP_ABOUT));

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File"), file_menu);
  //menuBar()->insertItem(i18n("&Edit"), edit_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);
  menuBar()->insertItem(i18n("&Options"), option_menu);
  
  menuBar()->insertSeparator();
  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu);
  CONNECT_CMD(view_menu);
  CONNECT_CMD(option_menu);

}
void KnetdumpApp::initToolBar()
{
    
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file

    toolBar()->insertButton(Icon("mini/mini-ksniffer.xpm"), ID_VIEW_KSNIFFER, true, "KSniffer");
    toolBar()->insertButton(Icon("mini/traffic.xpm"), ID_VIEW_TRAFFIC, true, "TrafficView");	
    toolBar()->insertButton(Icon("mini/header.xpm"), ID_VIEW_HEADER, true, "HeaderView");	
    toolBar()->insertButton(Icon("mini/chat.xpm"), ID_VIEW_CHAT, true, "ChatView");	
    toolBar()->insertButton(Icon("mini/stats.xpm"), ID_VIEW_STATS, true, "StatsView");	
    toolBar()->insertSeparator();
    toolBar()->insertSeparator();
    toolBar()->insertButton(Icon("mini/kblackbox.xpm"), ID_VIEW_OSI, true, i18n("ISO/OSI Layermodel"));
    toolBar()->insertSeparator();
    toolBar()->insertSeparator();
    toolBar()->insertButton(Icon("mini/kcontrol.xpm"), ID_OPTION_CONF, true, i18n("&Configure and Filter"));
    
    toolBar()->insertSeparator();
    toolBar()->insertSeparator();
    toolBar()->insertButton(Icon("mini/pause.xpm"), ID_PAUSEDOC, false, i18n("Pause Sniffing"));
    toolBar()->insertButton(Icon("mini/play.xpm"), ID_PROCEEDDOC, false, i18n("Start Sniffing"));
    
    toolBar()->insertSeparator();
    toolBar()->insertSeparator();
    toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));
    
    initStatsToolBar();

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

void KnetdumpApp::initStatsToolBar() {
    toolBar(1)->insertCombo("bimbo", ID_VIEW_STATSTOOLBAR, false, SIGNAL(activated(int)), this, SLOT(slotChangeComboInterface(int)), true , i18n("Interfaces"));
    enableToolBar(KToolBar::Hide, 1);
    //CONNECT_TOOLBAR(toolBar(1));
}

void  KnetdumpApp::slotChangeComboInterface(int index) {
  KCombo* classCombo = toolBar(1)->getCombo(ID_VIEW_STATSTOOLBAR);
  if (classCombo->count()) {
      QString name = classCombo->text( index );
      emit slotChangeInterface(name);
  }
}

QString KnetdumpApp::fillStatsCombo() {
  KCombo* classCombo = toolBar(1)->getCombo(ID_VIEW_STATSTOOLBAR);
  register int i=0;

  classCombo->clear();
  
  if (pdoc->getInterfaces("eth0")) 
    classCombo->insertItem("eth0", i++); 
                       
  if (pdoc->getInterfaces("eth1")) {
    classCombo->insertItem("eth1", i++); }
                        
  if (pdoc->getInterfaces("tr0")) {
 classCombo->insertItem("tr0", i++); }
                          
  if (pdoc->getInterfaces("lo")) {
   classCombo->insertItem("lo", i++); }
                          
  if (pdoc->getInterfaces("slip0")) {
   classCombo->insertItem("slip0", i++); }
                          
  if (pdoc->getInterfaces("ppp0")) {
   classCombo->insertItem("ppp0", i++); }

  if (classCombo->count())
      return (classCombo->text(0));
  else
      return 0;
}

void KnetdumpApp::showStatsToolBar() {
    toolBar(1)->enable(KToolBar::Show);
}		

void KnetdumpApp::hideStatsToolBar() {
	toolBar(1)->enable(KToolBar::Hide);
}		

void KnetdumpApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);
}

void KnetdumpApp::initView(const int name) {
    ////////////////////////////////////////////////////////////////////
    // set the main widget here
    // KApplication *app=KApplication::getKApplication();

    disableCommand(ID_PROCEEDDOC);
    
    // delete old class and stop doc
    switch (active_view) {
    case KOSI:
        delete (pKOsiView);
        break;
    case STATS:
	pdoc->stop();
	hideStatsToolBar();
	delete (pKStatsView);
	break;
    case TRAFFIC:
        pdoc->stop();
        delete (pKTrafficView);
        break;
    case CHAT:
        pdoc->stop();
        delete (pKChatView);
        break;
    case HEADER:
        pdoc->stop();
        delete (pKHeaderView);
        break;
    default:
        break;
    } 

    active_view = NOTHING;
    // erase();
    // start view==name
    // initiate class-pointer, set signals to slots, setView, move view, resize view and show
    switch (name) {
    case KOSI:
        active_view=KOSI;
        pKOsiView= new KOsiView(this, "KOsiView");
        // SIGNAL&SLOT for htmlHelp
        connect(pKOsiView, SIGNAL(htmlHelp(char*, char*)), this, SLOT(slotHTMLHelp(char*,char*)));
        setView(pKOsiView);
        move(x(),5);
        resize(750,380);
        pKOsiView->show();	
        break;
    case STATS:
      active_view=STATS;
      pKStatsView = new KStatsView(this, pdoc, "KStatsView");
      // if a packet is received in doc , send SIG to statsview's startslot
      connect(pdoc, SIGNAL(viewPacket()), pKStatsView, SLOT(startslot()));
      //connect(pdoc, SIGNAL(viewOldPacket()), pKStatsView, SLOT(showslot()));
      // if the packet is handled, send the SIG back
      connect(pKStatsView, SIGNAL(gotData()), pdoc, SLOT(hasShown()));
      // if Doc deletes packets, we'll inform KStatsView in order to reset ipnumbers
      //connect(pdoc, SIGNAL(deletedPackets()), pKStatsView, SLOT(slotResetIP()));
      // Signal to get packet i
      //connect(pKStatsView, SIGNAL(fetchPacket(int)), pdoc, SLOT(getPacket(int)));
      showStatsToolBar();
      // if the interface in the combobox is changed, inform pKStatsView:
      connect(this, SIGNAL(slotChangeInterface(QString)), pKStatsView, SLOT(slotChangeInterface(QString)));
      pKStatsView->slotChangeInterface(fillStatsCombo());
      // start the sniff-process
      pdoc->start();
      setView(pKStatsView);
      move(x(),5);
      resize(700, 680);
      pKStatsView->draw();
      pKStatsView->show();
      break;
    case CHAT:
        active_view=CHAT;
        pKChatView = new KChatView(this, pdoc, "KChatView");
        // if a packet is received in doc , send SIG to chatview's startslot
        connect(pdoc, SIGNAL(viewPacket()), pKChatView, SLOT(startslot()));
        connect(pdoc, SIGNAL(viewOldPacket()), pKChatView, SLOT(showslot()));
        // if the packet is handled, send the SIG back
        connect(pKChatView, SIGNAL(gotData()), pdoc, SLOT(hasShown()));
        // if Doc deletes packets, we'll inform KChatView in order to reset ipnumbers
        connect(pdoc, SIGNAL(deletedPackets()), pKChatView, SLOT(slotResetIP()));
        // Signal to get packet i
        connect(pKChatView, SIGNAL(fetchPacket(int)), pdoc, SLOT(getPacket(int)));
        // if a node was cleaned by inactivecounter, send SIG to CHAT's slotResetIP()
        connect(pdoc, SIGNAL(cleaned()), pKChatView, SLOT(slotResetIP()));
        // start the sniff-process
        pdoc->start();
        setView(pKChatView);
        move(x(),5);
        resize(700, 680);
        pKChatView->show();
        break;
    case TRAFFIC:
        active_view=TRAFFIC;
        pKTrafficView= new KTrafficView(this, pdoc, "KTrafficView");
        // if a packet is received in doc , send SIG to trafficview's startslot
        connect(pdoc, SIGNAL(viewPacket()), pKTrafficView, SLOT(startslot()));
        // if the packet is handled, send the SIG back
        connect(pKTrafficView, SIGNAL(gotData()), pdoc, SLOT(hasShown()));
        // start the sniff-process
        pdoc->start(); 
        // set view:
        setView(pKTrafficView);        
        move(x(),5);
        resize(700,500);
        pKTrafficView->show();
        break;
    case HEADER:
        active_view=HEADER;
        pKHeaderView= new KHeaderView(this, pdoc, "KHeaderView");
        // if a packet is received in doc , send SIG to headerview's startslot
        connect(pdoc, SIGNAL(viewPacket()), pKHeaderView, SLOT(startslot()));
        connect(pdoc, SIGNAL(viewOldPacket()), pKHeaderView, SLOT(startslot()));
        // if the packet is handled, send the SIG back
        connect(pKHeaderView, SIGNAL(gotData()), pdoc, SLOT(hasShown()));
        // if Doc starts/stops, we'll inform KHeaderView in order to scroll old packets
        connect(pdoc, SIGNAL(startedDoc()), pKHeaderView, SLOT(slotDocIsStarted()));
        connect(pdoc, SIGNAL(pausedDoc()), pKHeaderView, SLOT(slotDocIsPaused()));
        // if Doc deletes packets, we'll inform KHeaderView in order to erase view
        connect(pdoc, SIGNAL(deletedPackets()), pKHeaderView, SLOT(slotErase()));
        // start the sniff-process
        pdoc->start(); 
        // set view:
        setView(pKHeaderView);
        move(x(),5);
        resize(700,680);
        //updateRects();
        pKHeaderView->draw();
        pKHeaderView->show();
        break;
    default:
        break;
    }
    updateRects();
}


bool KnetdumpApp::queryExit()
{
  // int exit=KMsgBox::yesNo(this, i18n("Exit"), i18n("Really Quit ?"));
  const int exit=1;

  if(exit==1)
    return true;
  else
    return false;
}

void KnetdumpApp::saveOptions()
{
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar",toolBar()->isVisible());
  config->writeEntry("ShowStatusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos", (int)toolBar()->barPos());
  config->writeEntry("WelcomeScreen", welcome);
}

void KnetdumpApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  bViewToolbar = config->readBoolEntry("ShowToolbar", true);
  bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
  menu_bar_pos = (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top); 
  tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);
  welcome = config->readBoolEntry("WelcomeScreen", true);
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KnetdumpApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KnetdumpApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotFileCloseWindow()
{
  close();
}
void KnetdumpApp::slotFileQuit()
{ 

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

void KnetdumpApp::slotHTMLHelp (char *name, char *chapter=0) {
    kapp->invokeHTMLHelp(name,chapter);
}

void KnetdumpApp::slotViewChat()
{
   slotStatusMsg(i18n("Starts ChatView..."));

   initView(CHAT);
   
   slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotViewStats()
{
   slotStatusMsg(i18n("Starts StatsView..."));

   initView(STATS);
   
   slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotViewTraffic()
{
   slotStatusMsg(i18n("Starts TrafficView..."));

   initView(TRAFFIC);
   
   slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotViewHeader()
{
   slotStatusMsg(i18n("Starts HeaderView..."));

   initView(HEADER);
   
   slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotViewKsniffer() {
    bool found=false;
    register QString file;
    KProcess proc_ksniffer;
    const char *pathstr = getenv( "PATH" );
    const char *appname="ksniffer";
    QString onepath;
    QFileInfo info;

    QString p = pathstr;

    slotStatusMsg(i18n("Starts Ksniffer..."));

    // split path using : or \b as delimiters
    while( (p = tokenize( onepath, p, ":\b") ) != 0 ) {
        onepath += "/";
        onepath += appname;

        // Check for executable in this tokenized path
        info.setFile( onepath );

        if( info.exists() && info.isExecutable() && info.isFile() ) {
            proc_ksniffer << appname;
            proc_ksniffer.start(KProcess::DontCare,KProcess::All);
            found=true;
            break;
        }
    }

    if (!found) KMsgBox::message( this, i18n("Message"), i18n("Ksniffer seems not to be installed"));
    
    slotStatusMsg(IDS_DEFAULT);
}

const char* KnetdumpApp::tokenize( QString& token, const char *str, const char *delim) {
    // 
    // help member-funktion to tokenize $path
    //
    token = "";

    if( !str || !*str ) {
        return 0;
    }

    // find first non-delimiter character
    while( *str && strchr( delim, *str ) ) {
        str++;
    }
    
    if( !*str ) {
        return 0;
    }
    
    // find first delimiter or end, storing each non-qualifier into token
    while( *str && !strchr( delim, *str ) ) {
        token += *str;
        str++;
    }
    
    return str;
}                              

void KnetdumpApp::slotViewOSI()
{
   slotStatusMsg(i18n("Starts OSI-Layermodel..."));
	 initView(KOSI);
   slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotOptionConf() {
    // 
    // dialog for configuration and filter
    //
    slotStatusMsg(i18n("Starts configuration/filter dialog..."));
    
    KConf *pKConf=new KConf(this, pdoc, "Configure");
    // if a packet was received in doc , send SIG to Conf's slotNewAddr
    connect(pdoc, SIGNAL(viewPacket()), pKConf, SLOT(slotNewAddr()));
    // if the packet was handled, send the SIG back
    connect(pKConf, SIGNAL(gotData()), pdoc, SLOT(hasShown()));
    // if a node was cleaned by inactivecounter, send SIG to Conf's slotNewAddr
    connect(pdoc, SIGNAL(cleaned()), pKConf, SLOT(slotNewAddr()));
    pKConf->exec();
    delete (pKConf);
    
    // if StatsView is running, update the StatsCombo by fillStatsCombo()
    fillStatsCombo();
    slotChangeComboInterface(0);
    slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotOptionDARP() {
    // 
    // deletes ARP-Cache-Table 
    //
   slotStatusMsg(i18n("Deletes ARP table entry"));
   
   pdoc->delARPcache();
   
   slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotOptionCSTATS() {
    // 
    // clears statistics of devices
    //
    slotStatusMsg(i18n("Clears statistics of devices"));
   
    pdoc->clearStats();
    
    slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotOptionDPacket() {
    // 
    // deletes and dismisses all stored packets
    //
    slotStatusMsg(i18n("Deletes all stored Packets"));
    pdoc->delPackets();
    slotStatusMsg(IDS_DEFAULT);
}

void KnetdumpApp::slotPauseDoc() {  // slot for toolbar_button
    // set pause_button inactive & proceed_button active and pause Doc
    pdoc->pause();
    slotDocIsPaused();
}

void KnetdumpApp::slotProceedDoc() {  // slot for toolbar_button
    // set pause_button active & proceed_button inactive and proceed Doc
    pdoc->proceed();
    slotDocIsStarted();
}

void KnetdumpApp::slotDocIsStarted() { // slot for views
    // set pause_button active
    enableCommand(ID_PAUSEDOC);
    disableCommand(ID_PROCEEDDOC);
}

void KnetdumpApp::slotDocIsPaused() {
    // set play/proceed_button active
    disableCommand(ID_PAUSEDOC);
    enableCommand(ID_PROCEEDDOC);
}

void KnetdumpApp::slotDocIsStopped() {
    disableCommand(ID_PAUSEDOC);
    disableCommand(ID_PROCEEDDOC);
}

void KnetdumpApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);
}

/* void KnetdumpApp::slotViewStatsToolBar()
{
    ///////////////////////////////////////////////////////////////////
    // turn Toolbar on or off
    sViewToolbar=!sViewToolbar;
    //menuBar()->setItemChecked(ID_VIEW_STATSTOOLBAR, sViewToolbar);
    //enableToolBar(KToolBar::Toggle,1);
    toolBar(1)->enable(KToolBar::Toggle);
    slotStatusMsg(IDS_DEFAULT);
} */

void KnetdumpApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KnetdumpApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KnetdumpApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void KnetdumpApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_NEW_WINDOW,          slotFileNewWindow())
    ON_CMD(ID_FILE_CLOSE_WINDOW,        slotFileCloseWindow())
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())
    ON_CMD(ID_VIEW_KSNIFFER,         slotViewKsniffer())
    ON_CMD(ID_VIEW_CHAT,             slotViewChat())
    ON_CMD(ID_VIEW_STATS,             slotViewStats())
    ON_CMD(ID_VIEW_TRAFFIC,          slotViewTraffic())
    ON_CMD(ID_VIEW_HEADER,          slotViewHeader())
    
    ON_CMD(ID_VIEW_OSI,               slotViewOSI())
    ON_CMD(ID_OPTION_CONF,               slotOptionConf())
    ON_CMD(ID_OPTION_DARP,               slotOptionDARP())
    ON_CMD(ID_OPTION_CSTATS,               slotOptionCSTATS())
    ON_CMD(ID_OPTION_DPACKET,               slotOptionDPacket())
    ON_CMD(ID_PROCEEDDOC,                  slotProceedDoc())
    ON_CMD(ID_PAUSEDOC,                  slotPauseDoc())
    
    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
	//ON_CMD(ID_VIEW_STATSTOOLBAR,        slotViewStatsToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())
  }
}

void KnetdumpApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_NEW_WINDOW,   i18n("Opens a new application window"))
   
    ON_STATUS_MSG(ID_FILE_CLOSE_WINDOW, i18n("Closes the current window"))
    ON_STATUS_MSG(ID_FILE_QUIT,         i18n("Exits the program"))
   
    ON_STATUS_MSG(ID_VIEW_KSNIFFER,   i18n("Starts Ksniffer..."))
    ON_STATUS_MSG(ID_VIEW_CHAT,       i18n("Starts ChatView..."))
    ON_STATUS_MSG(ID_VIEW_STATS,       i18n("Starts StatsView..."))
    ON_STATUS_MSG(ID_VIEW_TRAFFIC,       i18n("Starts TrafficView..."))
    ON_STATUS_MSG(ID_VIEW_HEADER,       i18n("Starts HeaderView..."))

    ON_STATUS_MSG(ID_VIEW_OSI,   i18n("Starts OSI-Layermodel..."))
	
    ON_STATUS_MSG(ID_OPTION_CONF,   i18n("Starts configuration/filter dialog..."))
    ON_STATUS_MSG(ID_OPTION_DARP,   i18n("Deletes ARP table entry"))
    ON_STATUS_MSG(ID_OPTION_CSTATS,   i18n("Clears statistics of devices"))
    ON_STATUS_MSG(ID_OPTION_DPACKET,   i18n("Deletes all stored packets"))
    ON_STATUS_MSG(ID_PROCEEDDOC,       i18n("Proceeds Sniffing"))
    ON_STATUS_MSG(ID_PAUSEDOC,        i18n("Pauses Sniffing"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATSTOOLBAR,  i18n("Enables / disables the actual Stats-Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    i18n("Enables / disables the Statusbar"))
  }
}

