/***************************************************************************
                          voicemessagesdialog.cpp  -  description
                             -------------------
    begin                : Wed Dec 29 1999
    copyright            : (C) 1999 by Torsten Uhlmann
    email                : TUhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qmessagebox.h>
#include <kapp.h>
#include <kfiledialog.h>
#include "voicemessagesdialog.h"


VoiceMessagesDialog::VoiceMessagesDialog(KMsgModemApp *app, USRModem *modem, QWidget *parent, const char *name) : QDialog(parent,name,false){
	initDialog();
	_modem = modem;
	_app = app;
	
	connect( closeButton				, SIGNAL(clicked()), SLOT(hide()) );
	connect( uploadFileButton		, SIGNAL(clicked()), SLOT(slotGetUploadFile()) );
	connect( playbackFileButton	, SIGNAL(clicked()), SLOT(slotPlaybackUploadFile()) );
	connect( actionButton				, SIGNAL(clicked()), SLOT(slotPerformAction()) );
	connect( stopButton					, SIGNAL(clicked()), SLOT(slotStopRecording()) );
	connect( playInternalButton	, SIGNAL(clicked()), SLOT(slotPlayInternal()) );
	connect( playSoundcardButton, SIGNAL(clicked()), SLOT(slotPlaySoundcard()) );
	
	bgroup1 = new QButtonGroup();
	bgroup1->insert(outgoingMessageRadio);	
	bgroup1->insert(fullMessageRadio);	
	bgroup2 = new QButtonGroup();
	bgroup2->insert(modemInternalRadio);	
	bgroup2->insert(uploadFileRadio);	

	connect( bgroup2					, SIGNAL(clicked(int)), SLOT(slotRecordTypeChanged(int)) );
	slotRecordTypeChanged(0);
	stopButton->setEnabled(false);
	// playSoundcardButton->setEnabled(false);
}

VoiceMessagesDialog::~VoiceMessagesDialog(){
}

QString VoiceMessagesDialog::checkUploadFile()
{
	QString filename = uploadFile->text();
	if (filename.isEmpty())
	{
	   QMessageBox::information(0,i18n("Upload Message File"),
      i18n("You need to select a message file!"),
   	  QMessageBox::Ok | QMessageBox::Default);
	 	return QString("");
	}
	// check if file exists
	QFile file(filename);
	if (!file.exists())
	{
	   QMessageBox::information(0,i18n("Upload Message File"),
      i18n("The selected file does not exist!"),
   	  QMessageBox::Ok | QMessageBox::Default);
	 	return QString("");
	}
	if (!file.open(IO_ReadOnly))
	{
	   QMessageBox::information(0,i18n("Upload Message File"),
      i18n("The selected file could not be opened!"),
   	  QMessageBox::Ok | QMessageBox::Default);
	 	return QString("");
	}
	file.close();
	// everything seems to be ok with the file
	return filename;
}


void VoiceMessagesDialog::slotGetUploadFile()
{
  QString fileName = KFileDialog::getOpenFileName(getenv("HOME"),"*.gsm");

	if (!fileName.isEmpty())
  {
  	uploadFile->setText(fileName.data());
 	}

}

void VoiceMessagesDialog::slotPerformAction()
{
	if (uploadFileRadio->isChecked())
	{
		QString filename = checkUploadFile();
		if (!filename.isEmpty())
			_app->uploadVoiceMessage(filename,outgoingMessageRadio->isChecked());
	} else {
		// record message via internal microphone
		_modem->setMessageInternal(true,outgoingMessageRadio->isChecked());
		// change button text
		actionButton->setEnabled(false);
		stopButton->setEnabled(true);
	}
}

void VoiceMessagesDialog::slotStopRecording()
{
	_modem->setMessageInternal(false,outgoingMessageRadio->isChecked());
	// change button text
	actionButton->setEnabled(true);
	stopButton->setEnabled(false);
}

void VoiceMessagesDialog::slotRecordTypeChanged(int id)
{
	switch(id)
	{
		case 0:
			uploadFileButton->setEnabled(false);
			playbackFileButton->setEnabled(false);
			uploadFile->setEnabled(false);
			break;
		case 1:
			uploadFileButton->setEnabled(true);
			playbackFileButton->setEnabled(true);
			uploadFile->setEnabled(true);
			break;
		default: break;
	}
}

void VoiceMessagesDialog::slotPlaybackUploadFile()
{
	QString filename = checkUploadFile();
	if (!filename.isEmpty())
		_app->playFileSoundcard(filename);
}

void VoiceMessagesDialog::slotPlayInternal()
{
	_modem->playVoiceIntern(((outgoingMessageRadio->isChecked())?0:255) );
}

void VoiceMessagesDialog::slotPlaySoundcard()
{
	_app->playVoiceSoundcard(((outgoingMessageRadio->isChecked())?0:255) );	
}

