/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef PREVIEW_H
#define PREVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qwidget.h>
#include <qevent.h>
#include <qpopupmenu.h>
#include <qscrollbar.h>
#include <qstring.h>

#include <ktmainwindow.h>
#include <kconfig.h>
#include <kaccel.h>

#include "mlofile.h"

#include <X11/Xlib.h>


#define ID_PRE_FILE_PRINT         10010
#define ID_PRE_FILE_EXPORT        10020
#define ID_PRE_FILE_MAIL          10030
#define ID_PRE_FILE_CLOSE         10040

#define ID_PRE_GOTO_PREVIOUS      11010
#define ID_PRE_GOTO_NEXT          11020
#define ID_PRE_GOTO_FIRST         11030
#define ID_PRE_GOTO_LAST          11040

#define ID_PRE_VIEW_ZOOM_IN       12010
#define ID_PRE_VIEW_ZOOM_OUT      12020
#define ID_PRE_VIEW_ROTATE        12030

#define ID_PRE_OPTIONS_TOOLBAR    13010
#define ID_PRE_OPTIONS_STATUSBAR  13020

#define ID_PRE_STATUS_NAME         1001
#define ID_PRE_STATUS_SIZE         1002
#define ID_PRE_STATUS_PAGE         1003
#define ID_PRE_STATUS_ANGLE        1004
#define ID_PRE_STATUS_SENDER       1005



class FaxWidget : public QWidget
{
	Q_OBJECT
public:
	FaxWidget(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~FaxWidget();

	bool lsbFirst();

	void setImage(int w, int h, char *data);
	void deleteImage();

	bool x11EventFilter(XEvent *ev);

	Window window;

public slots:
	void setXScroll(int x);
	void setYScroll(int y);
	void keyLeft();
	void keyRight();
	void keyUp();
	void keyDown();
	void keyPageUp();
	void keyPageDown();
	void keyHome();
	void keyEnd();

protected:
	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);

protected slots:
	virtual void updateRects();

private:
	int scrollx, scrolly;

	QScrollBar *hscroll, *vscroll;

	Display *display;
	GC gc;
	bool lsb_first;
	XImage *image;
	int im_width, im_height;
	Cursor move_cursor;
	bool moving;
	int move_x, move_y;
};


inline bool FaxWidget::lsbFirst()
{ return lsb_first; }



extern FaxWidget *fw;



class Preview : public KTMainWindow
{
	Q_OBJECT
public:
	Preview(const char *name = 0);
	~Preview();

	void showFax(const QString& name, const QString& alias);

	void enableCommand(int id_, bool enable);

protected:
	void readOptions();
	void saveOptions();

	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void initKeyAccel();

public slots:
	void commandCallback(int id_);

	void slotFilePrint();
	void slotFileExport();
	void slotFileMail();

	void slotGotoFirstPage();
	void slotGotoPreviousPage();
	void slotGotoNextPage();
	void slotGotoLastPage();
	
	void slotViewZoomIn();
	void slotViewZoomOut();
	void slotViewRotate();

	void slotOptionsShowToolbar();
	void slotOptionsShowStatusbar();
	
	void slotStatusName(const QString& text);
	void slotStatusSize(int page_width, int page_height, bool normal);
	void slotStatusPage(int page_, int pages_);
	void slotStatusAngle();
	void slotStatusSender(const QString& text);
	
	virtual void hide();

private:
	void deletePages();
	void showPage();
	void loadPage(int p);

protected:
	virtual void closeEvent(QCloseEvent *);


private:
	KConfig *config;

	KAccel *keyAccel;

	QString fname, salias;
	MLOFile file;

	char *page_datas[3];
	int page, pages;
	int page_width, page_height;
	int zoom_width, zoom_height;
	int zoom;
	int angle;

	QPopupMenu *fileMenu;
	QPopupMenu *gotoMenu;
	QPopupMenu *viewMenu;
	QPopupMenu *optionsMenu;

	FaxWidget *view;

};


#endif // PREVIEW_H
