/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef PREFERENCES_H 
#define PREFERENCES_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdialog.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qcombobox.h>

#include <kconfig.h>



class Preferences : public QTabDialog
{
	Q_OBJECT
public:
	Preferences(QWidget *parent = 0, const char *name = 0);
	~Preferences();

	void addToolTips(bool on);

public slots:
	void reset();
	void apply();

signals:
	void apply_clicked();

private:
	KConfig *config;

	bool gotToolTips;

	QWidget *page1, *page2, *page3, *page4;

	QCheckBox *gen_tooltips;
	QCheckBox *gen_loadnew;
	QCheckBox *gen_deletefax;

	QLineEdit *mod_device;
	QComboBox *mod_speed;

	QLineEdit *prt_command;
	QButtonGroup *prt_paper;
	QSpinBox *prt_lmargin;
	QSpinBox *prt_rmargin;
	QSpinBox *prt_tmargin;
	QSpinBox *prt_bmargin;
	QCheckBox *prt_level2;
	QCheckBox *prt_interpolate;

	QLineEdit *mail_server;
	QLineEdit *mail_port;
	QLineEdit *mail_name;
	QLineEdit *mail_org;
	QLineEdit *mail_email;
	QLineEdit *mail_reply;
};


extern Preferences *prefs;

#endif // PREFERENCES_H
