
#include <qwidget.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qlayout.h>
#include <qtabdlg.h>
#include <qgrpbox.h>
#include <qstring.h>

#include <kapp.h>
#include "myintegerline.h"
#include <kcolorbtn.h>

#include "dialogs.h"
#include "mem_zone.h"

/*************************************************
 *** class ConfigureWidget ***********************
 *************************************************/

ConfigureWidget::ConfigureWidget( QWidget *parent, const char *name )
	: QTabDialog( parent, name, TRUE )
{
	display_tab = new DisplayDialog( this, 0 ) ;
	color_tab = new ColorDialog( this, 0 ) ;

	this->addTab( display_tab, i18n("Configure display") ) ;
	this->addTab( color_tab, i18n("Configure colors") ) ;

	setMinimumSize(160, 420 ) ;
}

ConfigureWidget::~ConfigureWidget()
{}

/*************************************************
 *** class DisplayDialog *************************
 *************************************************/

DisplayDialog::DisplayDialog( QWidget *parent, const char *name )
	: QWidget( parent, name ),
		pages_on_row(MemZone::DEFAULT_PAGES_ON_ROW),
		update_time(MemData::DEFAULT_UPDATE_TIME ) 
{
	QLabel *por_label = new QLabel( i18n("Number of pages on a row:") , this ) ;
 	pagesOnRowLine = new MyIntegerLine( this ) ;
	pagesOnRowLine->setValue(pages_on_row) ;
	connect( pagesOnRowLine, SIGNAL(valueChanged(int)),
			this, SLOT( pagesOnRow(int)) ) ;
	pagesOnRowLine->setMaximumValue( MemZone::MAX_PAGES_ON_ROW ) ;
	pagesOnRowLine->setMinimumValue( MemZone::MIN_PAGES_ON_ROW ) ;

	QLabel *ut_label = new QLabel( i18n("Update time (msecs):") , this ) ;
  	updateTimeLine = new MyIntegerLine( this ) ;
	updateTimeLine->setValue(update_time) ;
	connect( updateTimeLine, SIGNAL(valueChanged(int)),
			this, SLOT( updateTime(int)) ) ;
	updateTimeLine->setMaximumValue( MemData::MAX_UPDATE_TIME ) ;
	updateTimeLine->setMinimumValue( MemData::MIN_UPDATE_TIME ) ;

	int offset=10, w  ;
	int s;

	por_label->adjustSize() ;
	ut_label->adjustSize() ;

	w = por_label->width() ;
	s = ut_label->width() ;
	w = w>s ? w: s ;

	por_label->move( 10, offset ) ;
	pagesOnRowLine->resize( 60, 20 ) ;
	pagesOnRowLine->move( 10+w+10, offset ) ;

	offset+=30 ;

	ut_label->move( 10, offset ) ;
	updateTimeLine->resize( 60, 20 ) ;
	updateTimeLine->move( 10+w+10, offset ) ;

	offset+=30 ;
 
	setMinimumSize( 10+w+10+60+10, offset ) ;
}

DisplayDialog::~DisplayDialog()
{
}

void DisplayDialog::pagesOnRow( int v )
{
	pages_on_row=v ;

	pagesOnRowLine->setValue( v ) ;
}

int DisplayDialog::pagesOnRow()
{
	return pages_on_row ;
}

void DisplayDialog::updateTime( int v )
{
	update_time=v;

	updateTimeLine->setValue( v ) ;
}

int DisplayDialog::updateTime()
{
	return update_time ;
}


/*************************************************
 *** class ColorDialog ***************************
 *************************************************/

ColorDialog::ColorDialog( QWidget *parent, const char *name )
	: QWidget( parent, name ) 
{
	const int rows = 8 ;
	const int nr = MemZone::number_of_colors ;
	const int offset=10 ;
	int i ;
	QString tmp ;

	labels = new QLabel *[nr] ;
	colors = new KColorButton *[nr] ;
	
	for(i=0; i<nr; i++)
	{
		tmp.sprintf( "%s:", MemZone::getMemoryType(i) ) ;

		labels[i] = new QLabel( tmp, this ) ;
		colors[i] = new KColorButton(this,0) ;

		labels[i]->adjustSize() ;
		labels[i]->move(10, offset+30*i) ;
		colors[i]->setGeometry( 140, offset+30*i, 40, 20 ) ;
	}

	setMinimumSize( 30, 30 ) ;
}

ColorDialog::~ColorDialog()
{
}

QColor ColorDialog::getColor( int pos )
{
	if( pos>=0 && pos<MemZone::number_of_colors )
		return colors[pos]->color() ;
	else	return (void)0 ;
} 

void ColorDialog::setColor( const QColor &c, int pos ) 
{
	if( pos>=0 && pos<MemZone::number_of_colors )
		colors[pos]->setColor( c ) ;
}


