/*
    look@seti
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#include "chart.h"
#include "toplevel.h"
#include "dlgdetails.h"
#include "dlgadditem.h"
#include "dlgoptions.h"
#include "dlgskymap.h"
#include "dlgpnlopt.h"
#include "pnldock.h"

#define MAXNCFFT2 9024
#define MAXNCFFT3 18036

TChart *Chart;

extern SkymapDlg* Skymap;
extern int FirstLineType,SecondLineType;  // Was wird in den Zeilen angezeigt
extern DoubleDock *pdk;                   // Panelanzeige
extern TopLevel *toplevel;

TChart::TChart( QWidget* parent=0, const char* name=0, WFlags f=0)
        : QWindow( parent, name, f )
{
int Lauf;
//QListViewItem* QL;

   Paint = new QPainter();
   for (Lauf=0; Lauf<MAXSETI; Lauf++)
      SetiArr[Lauf]=NULL;
   SetiCount=0;
   Skymap=NULL;
   pdk=NULL;

   ProgressLab=new QLabel("",this);
   ProgressLab->setGeometry(10,10,100,40);
   ProgressLab->setFont(QFont("Times", 18, QFont::Bold));

   CurrentTab=0;
   TabBar = new KTabCtl(this);
   TabBar->setGeometry(5,5,width()-10,height()-10);
   connect(TabBar,SIGNAL(tabSelected(int)), this, SLOT(TabSelectClick(int)));

   SetiList = new QListView(TabBar, "SetiList");
   SetiList->addColumn(i18n("Stat"),25);
   SetiList->addColumn(i18n("Name"),80);
   SetiList->addColumn("OrdNumber",0);
   SetiList->addColumn(i18n("User"),100);
   SetiList->addColumn(i18n("Complete"),75);
   SetiList->addColumn(i18n("T. remain"),75);
   SetiList->addColumn(i18n("T. finish"),75);
   SetiList->addColumn(i18n("Path"),235);
   SetiList->setColumnAlignment(COMPLETE, AlignBottom+AlignRight);
   SetiList->setAllColumnsShowFocus(TRUE);
   SetiList->setFocusPolicy(QWidget::StrongFocus);
   connect(SetiList, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   UserList = new QListView(TabBar, "UserList");
   UserList->addColumn(i18n("Name"),80);
   UserList->addColumn("Number",0);
   UserList->addColumn(i18n("User"),100);
   UserList->addColumn(i18n("Country"),80);
   UserList->addColumn(i18n("Postal"),60);
   UserList->addColumn(i18n("WU's"),50);
   UserList->addColumn(i18n("Total CPU"),115);
   UserList->addColumn(i18n("email"),180);
   UserList->setAllColumnsShowFocus(TRUE);
   UserList->setFocusPolicy(QWidget::StrongFocus);
   connect(UserList, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   TimesList=new QListView(TabBar,"TimesList");
   TimesList->addColumn(i18n("Name"),80);
   TimesList->addColumn("Number",0);
   TimesList->addColumn(i18n("Complete"),80);
   TimesList->addColumn(i18n("Elapsed"),80);
   TimesList->addColumn(i18n("Remain"),80);
   TimesList->addColumn(i18n("Finish"),80);
   TimesList->addColumn(i18n("Total"),80);
   TimesList->addColumn(i18n("% per hour"),80);
   TimesList->setColumnAlignment(T_COMPLETE, AlignBottom+AlignRight);
   TimesList->setColumnAlignment(T_PERCENTHOUR, AlignBottom+AlignRight);
   TimesList->setAllColumnsShowFocus(TRUE);
   TimesList->setFocusPolicy(QWidget::StrongFocus);
   connect(TimesList, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   UnitList1 = new QListView(TabBar,"UnitList1");
   UnitList1->addColumn(i18n("Name"),80);
   UnitList1->addColumn(i18n("Number"),0);
   UnitList1->addColumn("%",50);
   UnitList1->addColumn(i18n("Peak Power"),95);
   UnitList1->addColumn(i18n("Peak Score"),95);
   UnitList1->addColumn(i18n("Gauss. Peak"),95);
   UnitList1->addColumn(i18n("Gauss. Score"),95);
   UnitList1->addColumn(i18n("Gauss. Fit"),95);
   UnitList1->setColumnAlignment(N1_COMPLETE, AlignBottom+AlignRight);
   UnitList1->setColumnAlignment(N1_PEAK_POWER, AlignBottom+AlignRight);
   UnitList1->setColumnAlignment(N1_PEAK_SCORE, AlignBottom+AlignRight);
   UnitList1->setColumnAlignment(N1_GAUSSIAN_POWER, AlignBottom+AlignRight);
   UnitList1->setColumnAlignment(N1_GAUSSIAN_SCORE, AlignBottom+AlignRight);
   UnitList1->setColumnAlignment(N1_GAUSSIAN_FIT, AlignBottom+AlignRight);
   UnitList1->setAllColumnsShowFocus(TRUE);
   UnitList1->setFocusPolicy(QWidget::StrongFocus);
   connect(UnitList1, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   UnitList2 = new QListView(TabBar,"UnitList2");
   UnitList2->addColumn(i18n("Name"),80);
   UnitList2->addColumn(i18n("Number"),0);
   UnitList2->addColumn("%",50);
   UnitList2->addColumn(i18n("Pulse Power"),95);
   UnitList2->addColumn(i18n("Pulse Score"),95);
   UnitList2->addColumn(i18n("Pulse Period"),95);
   UnitList2->addColumn(i18n("Triplet Power"),95);
   UnitList2->addColumn(i18n("Triplet Period"),95);
   UnitList2->setColumnAlignment(N2_COMPLETE, AlignBottom+AlignRight);
   UnitList2->setColumnAlignment(N2_PULSE_POWER, AlignBottom+AlignRight);
   UnitList2->setColumnAlignment(N2_PULSE_SCORE, AlignBottom+AlignRight);
   UnitList2->setColumnAlignment(N2_PULSE_PERIOD, AlignBottom+AlignRight);
   UnitList2->setColumnAlignment(N2_TRIPLET_POWER, AlignBottom+AlignRight);
   UnitList2->setColumnAlignment(N2_TRIPLET_PERIOD, AlignBottom+AlignRight);
   UnitList2->setAllColumnsShowFocus(TRUE);
   UnitList2->setFocusPolicy(QWidget::StrongFocus);
   connect(UnitList2, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   UnitTimesList = new QListView(TabBar,"UnitTimesList");
   UnitTimesList->addColumn(i18n("Name"),65);
   UnitTimesList->addColumn("Number",0);
   UnitTimesList->addColumn(i18n("User"),65);
   UnitTimesList->addColumn(i18n("Register Time"),178);
   UnitTimesList->addColumn(i18n("Last WU Received"),178);
   UnitTimesList->addColumn(i18n("Last Result Send"),178);
   UnitTimesList->setAllColumnsShowFocus(TRUE);
   UnitTimesList->setFocusPolicy(QWidget::StrongFocus);
   connect(UnitTimesList, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   LocationList = new QListView(TabBar,"LocationList");
   LocationList->addColumn(i18n("Name"),80);
   LocationList->addColumn("Number",0);
   LocationList->addColumn(i18n("Source"),65);
   LocationList->addColumn(i18n("Location"),250);
   LocationList->addColumn(i18n("Recording Time"),180);
   LocationList->addColumn(i18n("Basefrequency"),100);
   LocationList->addColumn(i18n("Unit Name"),250);
   LocationList->setAllColumnsShowFocus(TRUE);
   LocationList->setFocusPolicy(QWidget::StrongFocus);
   connect(LocationList, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   VersionList = new QListView(TabBar,"VersionList");
   VersionList->addColumn(i18n("Name"),80);
   VersionList->addColumn("Number",0);
   VersionList->addColumn(i18n("Client"),100);
   VersionList->addColumn(i18n("Workunit"),100);
   VersionList->addColumn(i18n("Splitter"),100);
   VersionList->addColumn(i18n("Tape"),100);
   VersionList->setAllColumnsShowFocus(TRUE);
   VersionList->setFocusPolicy(QWidget::StrongFocus);
   connect(VersionList, SIGNAL(rightButtonClicked ( QListViewItem *, const QPoint &, int )),
           this,     SLOT(MouseClick( QListViewItem *, const QPoint &, int )));

   TabBar->addTab(SetiList,i18n("Workunits"));
   TabBar->addTab(UserList,i18n("Userinfo"));
   TabBar->addTab(TimesList,i18n("Times"));
   TabBar->addTab(UnitList1,i18n("Analysis1"));
   TabBar->addTab(UnitList2,i18n("Analysis2"));
   TabBar->addTab(UnitTimesList,i18n("Transfertimes"));
   TabBar->addTab(LocationList,i18n("Location"));
   TabBar->addTab(VersionList,i18n("Versions"));

   Popup = new QPopupMenu(NULL);
   Popup->insertItem(i18n("&Displaying"), this, SLOT(PanelViewOptions()));
   Popup->insertSeparator();
   Popup->insertItem(i18n("&Exit"), kapp, SLOT(quit()));
   
   ListPopup = new QPopupMenu(NULL);
   ListPopup->insertItem(i18n("&Add"), this, SLOT(AddWatch()));
   ListPopup->insertItem(i18n("&Edit"), this, SLOT(EditWatch()));
   ListPopup->insertItem(i18n("&Delete"), this, SLOT(RemoveWatch()));
   ListPopup->insertItem(i18n("&Panel View"), this, SLOT(ShowPanelIcon()));

   StartupFile = "";
   Intervall=5000;
   Timer = new QTimer(this);

   ReadConfig();
   Timer->start(Intervall);
   //Timer->stop();
   connect(Timer,SIGNAL(timeout()),SLOT(TimerTic()));

}

TChart::~TChart() {
   delete Paint;
}

void TChart::paintEvent( QPaintEvent *) {
}

void TChart::resizeEvent( QResizeEvent * ) {
   TabBar->setGeometry(5,5,width()-10, height()-10);
//   SetiList->setGeometry(10,30,width()-20, height()-50);
}

void TChart::AddWatch()
{
   AddItemDlg AID(0,"ADD ITEM");
   if (AID.exec()) {
      debug("ADD");
      AddSeti(AID.NameEdit->text(), AID.PfadEdit->text());
   }
}

void TChart::EditWatch()
{
SetiPtr SP;
QListViewItem *QL;
AddItemDlg AID(0,"Edit Item");
QString Strg;

   SP=GetCurrentSeti();
   if (SP==NULL) return;
   AID.NameEdit->setText(SP->Name);
   AID.PfadEdit->setText(SP->Path);
   if (AID.exec()) {
      debug("EDIT");
      //AddSeti(AID.NameEdit->text(), AID.PfadEdit->text());
      if (strlen(AID.NameEdit->text())==0) {
         QMessageBox::warning(this, i18n("Empty Field"),
                     i18n("Name must be given"),
                     i18n("Ok"), 0, 0,
                     0,0);
         return;
      }
      if (strlen(AID.PfadEdit->text())==0) {
         QMessageBox::warning(this, i18n("Empty Field"),
                     i18n("Path must be given"),
                     i18n("Ok"), 0, 0,
                     0,0);
         return;
      }
      strcpy(SP->Name, AID.NameEdit->text());
      strcpy(SP->Path, AID.PfadEdit->text());

      // Setilist updaten
      QL = SetiList->firstChild();
      while (QL) {
         Strg=QL->text(NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(NAME, SP->Name);
            QL->setText(PFAD, SP->Path);
            break;
         }
         QL = QL->nextSibling();
      }
      // Userlist updaten
      QL = UserList->firstChild();
      while (QL) {
         Strg=QL->text(U_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(U_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
      // Unitlist1 updaten
      QL = UnitList1->firstChild();
      while (QL) {
         Strg=QL->text(N1_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(N1_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
      // Unitlist2 updaten
      QL = UnitList2->firstChild();
      while (QL) {
         Strg=QL->text(N2_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(N2_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
      // Timeslist updaten
      QL = TimesList->firstChild();
      while (QL) {
         Strg=QL->text(T_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(T_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
      // Unittimeslist updaten
      QL = UnitTimesList->firstChild();
      while (QL) {
         Strg=QL->text(UT_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(UT_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
      // Userlist updaten
      QL = LocationList->firstChild();
      while (QL) {
         Strg=QL->text(L_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(L_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
      // Versionlist updaten
      QL = VersionList->firstChild();
      while (QL) {
         Strg=QL->text(L_NUMBER);
         if (SP==(SetiPtr)(Strg.toULong())) {
            QL->setText(L_NAME, SP->Name);
            break;
         }
         QL = QL->nextSibling();
      }
   }
}

void TChart::RemoveWatch()
{
SetiPtr SP;
QListViewItem* QL=NULL;
QString Strg;
bool Ok;

debug("RemoveWatch-Start");
/*   switch (CUrrentTab) {
      if (SetiList->hasFocus()) {
         QL=SetiList->currentItem();
         if (QL)
            Strg=QL->text(NUMBER);
      } else
      if (UserList->hasFocus()) {
         QL=UserList->currentItem();
         if (QL)
            Strg=QL->text(U_NUMBER);
      } else
      if (UnitList1->hasFocus()) {
         QL=UnitList1->currentItem();
         if (QL)
            Strg=QL->text(N1_NUMBER);
         else
            return;
      } else
      if (TimesList->hasFocus()) {
         QL=TimesList->currentItem();
         if (QL)
            Strg=QL->text(T_NUMBER);
         else
            return;
      } else
      if (UnitTimesList->hasFocus()) {
         QL=UnitTimesList->currentItem();
         if (QL)
            Strg=QL->text(UT_NUMBER);
         else
            return;
      } else
      if (LocationList->hasFocus()) {
         QL=LocationList->currentItem();
         if (QL)
            Strg=QL->text(L_NUMBER);
         else
            return;
      }
   }*/
   
debug("Currenttyb=%d",CurrentTab);
   switch (CurrentTab) {
      case 0 :  QL=SetiList->currentItem();
                if (QL)
                   Strg=QL->text(NUMBER);
                break;
      case 1 :  // userlist
                QL=UserList->currentItem();
                if (QL)
                   Strg=QL->text(U_NUMBER);
                break;
      case 2 :  // Timeslist
                QL=TimesList->currentItem();
                if (QL)
                   Strg=QL->text(T_NUMBER);
                break;
      case 3 :  // Unitlist1
                QL=UnitList1->currentItem();
                if (QL)
                   Strg=QL->text(N1_NUMBER);
                break;
      case 4 :  // Unitlist2
                QL=UnitList2->currentItem();
                if (QL)
                   Strg=QL->text(N2_NUMBER);
                break;
      case 5  : // UnitTimesList
                QL=UnitTimesList->currentItem();
                if (QL)
                   Strg=QL->text(UT_NUMBER);
                break;
      case 6 :  // Locationlist
                QL=LocationList->currentItem();
                if (QL)
                   Strg=QL->text(L_NUMBER);
                break;
      case 7 :  // Versionlist
                QL=VersionList->currentItem();
                if (QL)
                   Strg=QL->text(L_NUMBER);
                break;
      default : debug ("Invalid Tab %d",CurrentTab);
   }

   if (QL) {
debug("QL<>NULL");
      // Zeiger auf die Datenstruktur ermitteln
      SP=(SetiPtr)(Strg.toULong(&Ok));

      // Eintrag in der SetiList suchen und lschen
      // Suche nach dem eindeutigen Pointer SP
      QL = SetiList->firstChild();
      while (QL) {
         if (Strg==QL->text(NUMBER)) {
            delete QL;
debug("delete QL");
            break;
         }
         QL = QL->nextSibling();
      }
      // Eintrag in der UserList suchen und lschen
      // Suche nach dem eindeutigen Pointer SP
      QL = UserList->firstChild();
      while (QL) {
         if (Strg==QL->text(U_NUMBER)) {
            delete QL;
            //UserList->remove(QL);
            break;
         }
         QL = QL->nextSibling();
      }
      // Eintrag in der TimesList suchen und lschen
      QL = TimesList->firstChild();
      while (QL) {
         if (Strg==QL->text(T_NUMBER)) {
            delete QL;
            break;
         }
         QL = QL->nextSibling();
      }

      // Eintrag in der UnitList1 suchen und lschen
      QL = UnitList1->firstChild();
      while (QL) {
         if (Strg==QL->text(U_NUMBER)) {
            delete QL;
            break;
         }
         QL = QL->nextSibling();
      }

      // Eintrag in der UnitList2 suchen und lschen
      QL = UnitList2->firstChild();
      while (QL) {
         if (Strg==QL->text(U_NUMBER)) {
            delete QL;
            break;
         }
         QL = QL->nextSibling();
      }

      // Eintrag in der Unit-TimesList suchen und lschen
      QL = UnitTimesList->firstChild();
      while (QL) {
         if (Strg==QL->text(UT_NUMBER)) {
            delete QL;
            break;
         }
         QL = QL->nextSibling();
      }

      // Eintrag in der LocationList suchen und lschen
      QL = LocationList->firstChild();
      while (QL) {
         if (Strg==QL->text(L_NUMBER)) {
            delete QL;
            break;
         }
         QL = QL->nextSibling();
      }

      // Eintrag in der VersionList suchen und lschen
      QL = VersionList->firstChild();
      while (QL) {
         if (Strg==QL->text(L_NUMBER)) {
            delete QL;
            break;
         }
         QL = QL->nextSibling();
      }

      // Detailfenster entfernen, wenn ein zu diesem Watch offen ist
      if (SP->DetailWindow) {
         DetailsDlg* ddlg;
         ddlg=(DetailsDlg*)(SP->DetailWindow);
         ddlg->close();
      }
      // Panelanzeige entfernen, wenn dieser Watch dort angezeigt wird
      if (SP->PanelDisplay) {
         if (pdk) {
            delete(pdk);
            pdk=NULL;
         }
      }
      free(SP);
      SetiCount--;
   }
}

void TChart::RemoveAllWatches()
{
QListViewItem* QL;
SetiPtr SP;
QString Strg;

   Timer->stop();

   // Panelanzeige entfernen
   if (pdk) {
      delete pdk;
      pdk=NULL;
   }

   // Lschen der Pointer
   QL = SetiList->firstChild();
   while (QL) {
      Strg = QL->text(NUMBER);
      SP = (SetiPtr)(Strg.toULong());

      if (SP->DetailWindow) {
         DetailsDlg* ddlg;
         ddlg=(DetailsDlg*)(SP->DetailWindow);
         ddlg->close();
      }
      free(SP);
      QL = QL->nextSibling();
   }

   // Leeren der Listen
   SetiList->clear();
   UserList->clear();
   TimesList->clear();
   UnitList1->clear();
   UnitList2->clear();
   UnitTimesList->clear();
   LocationList->clear();
   VersionList->clear();

   // Timer wieder starten
   SetiCount=0;
   Timer->start(Intervall);
}

void TChart::LoadWatches()
// Neue berwachung zufgen
{
QString DateiName = KFileDialog::getOpenFileName("./", "*.seti", this, i18n("Open Watchlist"));

   AddWatches(DateiName);
}

void TChart::AddWatches(QString DateiName) {
int Ret;
FILE *F;
char Name[100], Pfad[512];

   if (!DateiName.isEmpty()) {
      debug("open...");
      if (DateiName.right(5)!=".seti")
         DateiName+=".seti";
      // Datei vorhanden ????
      if (!QFile::exists(DateiName)) {
         QMessageBox::warning(this, i18n("File Not Found"),
                     i18n("Cannot find file '")+DateiName+"'?",
                     i18n("Ok"), 0, 0,
                     0,0);
         return;
      }
      F=fopen(DateiName.data(), "rt");
      if (F) {
         while (!feof(F)) {
            Ret = fscanf(F,"%s %s", Name, Pfad);
            if (Ret>0) {
               AddSeti(Name, Pfad);
            }
         }
         fclose(F);
      } else
         QMessageBox::critical(this, i18n("File Open Error"),
                     i18n("Unable to open file '")+DateiName+"'",
                     i18n("Ok"));
   }
   TimerTic();
}

void TChart::SaveWatches()
{
FILE *F;
QString DateiName = KFileDialog::getSaveFileName("./", "*.seti", this, i18n("Save Watches"));
QListViewItem *QL;

   if (!DateiName.isEmpty()) {
      debug("save...");
      if (DateiName.right(5)!=".seti")
         DateiName+=".seti";
      // Datei vorhanden ????
      if (QFile::exists(DateiName)) {
         if (QMessageBox::warning(this, i18n("File Overwrite"),
                     i18n("Overwrite file '")+DateiName+"'?",
                     i18n("Yes"), i18n("No"), 0,
                     0,1)!=0)
            return; // nicht berschreiben
      }
      F=fopen(DateiName.data(), "wt");
      if (F) {
         QL = SetiList->firstChild();
         while (QL) {
            fprintf(F,"%s %s\n", QL->text(NAME),
                                 QL->text(PFAD));
            QL = QL->nextSibling();
         }
         fclose(F);
      } else
         QMessageBox::critical(this, i18n("File Create Error"),
                     i18n("Unable to create file '")+DateiName+"'",
                     0,-1,-1);
   }
}

void TChart::mousePressEvent( QMouseEvent * mev) {
}

void TChart::TimerTic() {
QString S;
QDir SD;
QListViewItem* QL;

   if (SetiCount==0) return;   // kein Eintrach
   QL = SetiList->firstChild();
   while (QL) {
      SD = QL->text(PFAD);
      ScanSeti(QL, SD);
      QL = QL->nextSibling();
   }
   UpdateUserGrid();
   UpdateTimesGrid();
   UpdateUnitsGrid();
   UpdateUnitTimesGrid();
   UpdateLocationGrid();
   UpdateVersionGrid();
   if (pdk)
      pdk->Update();
}

int TChart::SetStatus(QListViewItem* QL, int Status) {
KIconLoader IconLoader;
//debug("Statuzs=%d",Status);
   switch (Status) {
      case S_NONE    : // unbekannter Status
                       QL->setPixmap(STATUS, IconLoader.loadIcon("help.xpm"));
                       break;
      case S_READY   : // Berechnung fertig
                       QL->setPixmap(STATUS, IconLoader.loadIcon("flag.xpm"));
                       break;
      case S_WORKING : // Berechnung luft
                       QL->setPixmap(STATUS, IconLoader.loadIcon("running.xpm"));
                       break;
      case S_NODATA  : // kein Seti hier :-((
                       QL->setPixmap(STATUS, IconLoader.loadIcon("filedel.xpm"));
                       break;
      case S_WAITING : // keine Berechnung
                       QL->setPixmap(STATUS, IconLoader.loadIcon("waiting.xpm"));
                       break;
      case S_RECEIVING : // Datenbertragung
                       QL->setPixmap(STATUS, IconLoader.loadIcon("reload.xpm"));
                       break;
   }
   return 0;
}

int TChart::ScanState(QString Datei, SetiPtr SP) { // State.txt scannen
FILE *F;
char Line[1100];
bool ok;
QString Strg;
int BgCount=0;  // Zhler fr Gaussian-Werte
int MaxNcfft;

//debug("ScanState");
   QFile qf(Datei);
   if (!qf.exists()) {  // state.txt nicht vorhanden
//debug("MISSING");
      StateStatus=STATE_MISSING;
      SP->Ncfft=0;
      SP->Cpu=0;
      SP->Progress=SP->p1=SP->p2=SP->p3=-1;
      SP->TotalCpu=0;
      return 0;
   }
   if (qf.size()==0) {
//debug("LEER");
      StateStatus=STATE_EMPTY;
      SP->Ncfft=0;
      SP->Cpu=0;
      SP->Progress=SP->p1=SP->p2=SP->p3=-1;
      SP->TotalCpu=0;
      return 0;
   }

   
   F=fopen(Datei.data(),"rt");
   if (F) {
      while (!feof(F)) {
         memset(Line, 0, sizeof(Line));
         fgets(Line,1100,F);
         //debug("%s",Line);

         if (strncmp("ncfft=", Line, 6)==0) {
            Strg=&(Line[6]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Ncfft=Strg.toInt(&ok);
            if (!ok) SP->Ncfft=0;
            if (SP->Major_Version < 3) MaxNcfft=MAXNCFFT2; else MaxNcfft=MAXNCFFT3;
            if (SP->Ncfft==MaxNcfft) SP->Status=S_READY;
         } else
         if (strncmp("cr=", Line, 3)==0) {
            Strg=&(Line[3]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Cr=Strg.toDouble(&ok);
            if (!ok) SP->Cr=0;
         } else
         if (strncmp("fl=", Line, 3)==0) {
            Strg=&(Line[3]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Fl=Strg.toLong(&ok);
            if (!ok) SP->Fl=0;
         } else
         if (strncmp("cpu=", Line, 4)==0) {
            Strg=&(Line[4]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Cpu=Strg.toDouble(&ok);
            if (!ok) SP->Cpu=0;
         } else
         if (strncmp("prog=", Line, 5)==0) {
            SP->p3=SP->p2;
            SP->p2=SP->p1;
            SP->p1=SP->Progress;
            Strg=&(Line[5]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Progress=Strg.toDouble(&ok);
            if (!ok) SP->Progress=-1;
         } else
         if (strncmp("bs_power=", Line, 9)==0) {
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bs_Power=Strg.toDouble(&ok);
            if (!ok) SP->Bs_Power=0;
         } else
         if (strncmp("bs_score=", Line, 9)==0) {
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bs_Score=Strg.toDouble(&ok);
            if (!ok) SP->Bs_Score=0;
         } else
         if (strncmp("bs_chirp_rate=", Line, 14)==0) {
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bs_Chirp_Rate=Strg.toDouble(&ok);
            if (!ok) SP->Bs_Chirp_Rate=0;
         } else
         if (strncmp("bg_score=", Line, 9)==0) {
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bg_Score=Strg.toDouble(&ok);
            if (!ok) SP->Bg_Score=0;
         } else
         if (strncmp("bg_power=", Line, 9)==0) {
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bg_Power=Strg.toDouble(&ok);
            if (!ok) SP->Bg_Power=0;
         } else
         if (strncmp("bg_chisq=", Line, 9)==0) {
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bg_Chisq=Strg.toDouble(&ok);
            if (!ok) SP->Bg_Chisq=0;
         } else
         if (strncmp("bg_chirp_rate=", Line, 14)==0) {
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bg_Chirp_Rate=Strg.toDouble(&ok);
            if (!ok) SP->Bg_Chirp_Rate=0;
         } else
         if (strncmp("bg_fft_ind=", Line, 11)==0) {
            Strg=&(Line[11]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bg_Fft_Ind=Strg.toInt(&ok);
            if (!ok) SP->Bg_Fft_Ind=0;
            //debug("fft_ind=%d",SP->Bg_Fft_Ind);
         } else
         if (strncmp("bp_score=", Line, 9)==0) {  // Pulse Score
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bp_Score=Strg.toDouble(&ok);
            if (!ok) SP->Bp_Score=0;
         } else
         if (strncmp("bp_power=", Line, 9)==0) {  // Pulse Power
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bp_Power=Strg.toDouble(&ok);
            if (!ok) SP->Bp_Power=0;
         } else
         if (strncmp("bp_period=", Line, 10)==0) {  // Pulse Period
            Strg=&(Line[10]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bp_Period=Strg.toDouble(&ok);
            if (!ok) SP->Bp_Period=0;
         } else
         if (strncmp("bp_pot=", Line, 7)==0) {  // Pulse data
            Strg=&(Line[7]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->Bp_Data,Strg.data(),1100);
         } else
         if (strncmp("bt_power=", Line, 9)==0) {  // Triplet Power
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bt_Power=Strg.toDouble(&ok);
            if (!ok) SP->Bp_Power=0;
         } else
         if (strncmp("bt_period=", Line, 10)==0) {  // Triplet Period
            Strg=&(Line[10]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bt_Period=Strg.toDouble(&ok);
            if (!ok) SP->Bp_Period=0;
         } else
         if (strncmp("bt_tpotind0_0=", Line, 14)==0) {  // Triplet Index 0
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bt_Ind0=Strg.toInt(&ok);
            if (!ok) SP->Bt_Ind0=0;
         } else
         if (strncmp("bt_tpotind1_0=", Line, 14)==0) {  // Triplet Index 1
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bt_Ind1=Strg.toInt(&ok);
            if (!ok) SP->Bt_Ind1=0;
         } else
         if (strncmp("bt_tpotind2_0=", Line, 14)==0) {  // Triplet Index 2
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Bt_Ind2=Strg.toInt(&ok);
            if (!ok) SP->Bt_Ind2=0;
         } else
         if (strncmp("bt_pot=", Line, 7)==0) {  // Pulse data
            Strg=&(Line[7]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->Bt_Data,Strg.data(),1100);
         } else
         if (SP->Bg_Power!=0.0) {
            // "Skyline" der Gaussian-Werte scannen
            if (BgCount<GARRMAX)
            if (strncmp("bg_pot", Line, 6)==0) {
               char* S;
               S=strchr(Line,'=');
               if (S) {
                  float Flt;
                  S++;
                  Strg=S;
                  Strg.remove(Strg.length()-1,2); // LF entfernen
                  //debug("%s",Strg.data());
                  Flt=Strg.toDouble(&ok);
                  if (Flt==SP->GArr[BgCount]) {
                     // Werte sind gleich, keine weitere bernahme
                     BgCount=GARRMAX;
                  } else {
                     SP->GArr[BgCount]=Strg.toDouble(&ok);
                     //debug("%0.5f",SP->GArr[BgCount]);
                 }
                  if (!ok) SP->GArr[BgCount]=0;
                  BgCount++;
               }
            }
         }
      }
      StateStatus=STATE_OK;
      fclose(F);
   } else {
      StateStatus = STATE_MISSING;
      return -1;
   }
/*debug("ncfft=%d",SP->Ncfft);
debug("cr=%0.2f",SP->Cr);
debug("fl=%d",SP->Fl);
debug("cpu=%0.2f",SP->Cpu);
debug("prog=%0.2f",SP->Progress);
debug("bs_power=%0.2f",SP->Bs_Power);
debug("bs_score=%0.2f",SP->Bs_Score);
debug("bs_chirp_rate=%0.2f",SP->Bs_Chirp_Rate);
debug("bg_score=%0.2f",SP->Bg_Score);
debug("bg_power=%0.2f",SP->Bg_Power);
debug("bg_chisq=%0.2f",SP->Bg_Chisq);
debug("bg_chirp_rate=%0.2f",SP->Bg_Chirp_Rate);*/
   return 0;
}

int TChart::ScanWTemp(QString Datei, SetiPtr SP){
// wtemp.txt scannen
int Flag=TRUE;
FILE *F;
char Line[128];

   WTempStatus=WTEMP_MISSING;

   if (QFile::exists(Datei)) {
      F=fopen(Datei.data(),"rt");
      if (F) {
         fgets(Line,128,F);
         if (strstr(Line,"result")) {
            Flag=FALSE;
            WTempStatus=WTEMP_RESULT;
         }
         fclose(F);
      }
      if (Flag) {
         QFile qf(Datei);
         SP->Progress=qf.size()/1024.0;
         SP->Status=S_RECEIVING;  //neue WU kommt
         WTempStatus=WTEMP_WU;
      }
   }
}

int TChart::ScanUserInfo(QString Datei, SetiPtr SP) {
// user_info.txt scannen
FILE *F;
char Line[256];
bool ok;
QString Strg;
int Pos1,Pos2;

   QFile qf(Datei);
   if (!qf.exists()) {  // user.txt nicht vorhanden
      return 0;
   }
   if (qf.size()==0) {
      return 0;
   }

   
   F=fopen(Datei.data(),"rt");
   if (F) {
      while (!feof(F)) {
         memset(Line, 0, sizeof(Line));
         fgets(Line,255,F);
         //debug("%s",Line);

         if (strncmp("id=", Line, 3)==0) {
            Strg=&(Line[3]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Id=Strg.toULong(&ok);
            if (!ok) SP->Id=0;
         } else
         if (strncmp("key=", Line, 4)==0) {
            // Key=
            Strg=&(Line[4]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Key=Strg.toULong(&ok);
            if (!ok) SP->Key=0;
         } else
         if (strncmp("email_addr=", Line, 11)==0) {
            // email_addr=
            Strg=&(Line[11]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->Email,Strg.data(),256);
         } else
         if (strncmp("name=", Line, 5)==0) {
            // name=
            Strg=&(Line[5]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->UserName,Strg.data(),256);
         } else
         if (strncmp("country=", Line, 8)==0) {
            // country=
            Strg=&(Line[8]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->Country,Strg.data(),64);
         } else
         if (strncmp("postal_code=", Line, 12)==0) {
            // postal_code=
            Strg=&(Line[12]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->Plz,Strg.data(),16);
         } else
         if (strncmp("register_time=", Line, 12)==0) {
            // register_time=
            Strg=&(Line[12]);
            Pos1=Strg.find('(');
            if (Pos1>0) {
               Pos2=Strg.find(')');
               Strg=Strg.mid(Pos1+1,Pos2+1-Pos1-2);
               strncpy(SP->RegTime,Strg.data(),64);
            }
         } else
         if (strncmp("last_wu_time=", Line, 13)==0) {
            // last_wu_time=
            Strg=&(Line[13]);
            Pos1=Strg.find('(');
            if (Pos1>0) {
               Pos2=Strg.find(')');
               Strg=Strg.mid(Pos1+1,Pos2+1-Pos1-2);
               strncpy(SP->LastWuTime,Strg.data(),64);
            }
         } else
         if (strncmp("last_result_time=", Line, 17)==0) {
            // last_result_time=
            Strg=&(Line[17]);
            Pos1=Strg.find('(');
            if (Pos1>0) {
               Pos2=Strg.find(')');
               Strg=Strg.mid(Pos1+1,Pos2+1-Pos1-2);
               strncpy(SP->LastResultTime,Strg.data(),64);
            }
         } else
         if (strncmp("nwus=", Line, 5)==0) {
            // nwus=
            Strg=&(Line[5]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->NumWu=Strg.toULong(&ok);
            if (!ok) SP->NumWu=0;
         } else
         if (strncmp("nresults=", Line, 9)==0) {
            // nresults=
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->NumResults=Strg.toULong(&ok);
            if (!ok) SP->NumResults=0;
         } else
         if (strncmp("total_cpu=", Line, 10)==0) {
            // total_cpu=
            Strg=&(Line[10]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->TotalCpu=Strg.toDouble(&ok);
            if (!ok) SP->TotalCpu=0;
         }
      }
      fclose(F);
   } else {
      return -1;
   }
/*debug("id=%ld",SP->Id);
debug("Key=%ld",SP->Key);
debug("email=%s",SP->Email);
debug("name=%s",SP->UserName);
debug("country=%s",SP->Country);
debug("postal=%s",SP->Plz);
debug("register=%s",SP->RegTime);
debug("last wu=%s",SP->LastWuTime);
debug("last result=%s",SP->LastResultTime);
debug("nwus=%d",SP->NumWu);
debug("nresults=%d",SP->NumResults);
debug("totalcpu=%0.2f",SP->TotalCpu);*/
   return 0;
}

int TChart::ScanVersion(QString Datei, SetiPtr SP) {
// version.sah scannen
FILE *F;
char Line[256];
bool ok;
QString Strg;

   QFile qf(Datei);
   if (!qf.exists()) {  // user.txt nicht vorhanden
      return 0;
   }
   if (qf.size()==0) {
      return 0;
   }


   F=fopen(Datei.data(),"rt");
   if (F) {
      while (!feof(F)) {
         memset(Line, 0, sizeof(Line));
         fgets(Line,255,F);
         //debug("%s",Line);

         if (strncmp("major_version=", Line, 14)==0) {
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Major_Version=Strg.toInt(&ok);
            if (!ok) SP->Major_Version=0;
         } else
         if (strncmp("minor_version=", Line, 14)==0) {
            Strg=&(Line[14]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Minor_Version=Strg.toInt(&ok);
            if (!ok) SP->Minor_Version=0;
         }
      }
      fclose(F);
   } else {
      return -1;
   }
   return 0;
}

int TChart::ScanWorkUnit(QString Datei, SetiPtr SP, int LinesToScan){
// work_unit.txt scannen
// Rckgabe "False", wenn Datei nicht gefunden
FILE *F;
char Line[256];
int LineCount=0;
bool ok;
QString Strg;
int Pos1,Pos2;

   QFile qf(Datei);
   if (!qf.exists()) {  // user.txt nicht vorhanden
      return FALSE;
   }
   if (qf.size()==0) {
      return FALSE;
   }

   
   F=fopen(Datei.data(),"rt");
   if (F) {
      while (!feof(F)) {
         memset(Line, 0, sizeof(Line));
         fgets(Line,255,F);
         //debug("%s",Line);

         if (strncmp("name=", Line, 5)==0) {
            // name=...
            Strg=&(Line[5]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->WuName,Strg.data(),40);
         } else
         if (strncmp("start_ra=", Line, 9)==0) {
            // start_ra=
            Strg=&(Line[9]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Start_Ra=Strg.toDouble(&ok);
            if (!ok) SP->Start_Ra=0;
         } else
         if (strncmp("start_dec=", Line, 10)==0) {
            // start_dec=
            Strg=&(Line[10]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Start_Dec=Strg.toDouble(&ok);
            if (!ok) SP->Start_Dec=0;
         } else
         if (strncmp("end_ra=", Line, 7)==0) {
            // end_ra=
            Strg=&(Line[7]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->End_Ra=Strg.toDouble(&ok);
            if (!ok) SP->End_Ra=0;
         } else
         if (strncmp("end_dec=", Line, 8)==0) {
            // end_dec=
            Strg=&(Line[8]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->End_Dec=Strg.toDouble(&ok);
            if (!ok) SP->End_Dec=0;
         } else
         if (strncmp("angle_range=", Line, 12)==0) {
            // angle_range=
            Strg=&(Line[12]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Angle_Range=Strg.toDouble(&ok);
            if (!ok) SP->Angle_Range=0;
         } else
         if (strncmp("time_recorded=", Line, 14)==0) {
            // time_recorded=
            Strg=&(Line[14]);
            Pos1=Strg.find('(');
            if (Pos1>0) {
               Pos2=Strg.find(')');
               Strg=Strg.mid(Pos1+1,Pos2+1-Pos1-2);
               strncpy(SP->Time_Recorded,Strg.data(),40);
            }
         } else
         if (strncmp("subband_base=", Line, 13)==0) {
            // subband_base
            Strg=&(Line[13]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Subband_Base=Strg.toDouble(&ok);
            if (!ok) SP->Subband_Base=0;
         } else
         if (strncmp("subband_sample_rate=", Line, 20)==0) {
            // subband_sample_rate 
            Strg=&(Line[20]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Subband_Sample_Rate=Strg.toDouble(&ok);
            if (!ok) SP->Subband_Sample_Rate=0;
         } else
         if (strncmp("receiver=", Line, 9)==0) {
            // receiver=...
            Strg=&(Line[9]);
            if (Strg.left(2)="ao")
               strcpy(SP->Receiver,"Arecibo");
         } else
         if (strncmp("version=", Line, 8)==0) {
            Strg=&(Line[8]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Seti_Version=Strg.toInt(&ok);
            if (!ok) SP->Seti_Version=0;
         } else
         if (strncmp("splitter_version=", Line, 17)==0) {
            Strg=&(Line[17]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            strncpy(SP->Splitter_Version,Strg.data(),10);
         } else
         if (strncmp("tape_version=", Line, 10)==0) {
            Strg=&(Line[13]);
            Strg.remove(Strg.length()-1,2); // LF entfernen
            SP->Tape_Version=Strg.toDouble(&ok);
            if (!ok) SP->Tape_Version=0;
         }
         LineCount++;
         if (LineCount>LinesToScan)
            break; // nicht alles scannen
      }
      fclose(F);
   } else {
      return FALSE;
   }
/*debug("WuName=%s",SP->WuName);
debug("start_ra=%0.2f",SP->Start_Ra);
debug("start_dec=%0.2f",SP->Start_Dec);
debug("end_ra=%0.2f",SP->End_Ra);
debug("end_dec=%0.2f",SP->End_Dec);
debug("angle_range=%0.2f",SP->Angle_Range);
debug("time_recorded=%s",SP->Time_Recorded);
debug("subband_base=%0.2f",SP->Subband_Base);
debug("subband_sample_rate=%0.2f",SP->Subband_Sample_Rate);
debug("receiver=%s",SP->Receiver);
debug("Seti=%d",SP->Seti_Version);
debug("Splitter=%s",SP->Splitter_Version);
debug("Tape=%0.3f",SP->Tape_Version);*/
   return TRUE;
}

void TChart::CalcStatus(SetiPtr SP) {
// Berechnungsstatus bestimmen
   switch (StateStatus) {
      case STATE_MISSING : switch (WTempStatus) {
                              case WTEMP_MISSING : SP->Status = S_NODATA;
                                                   break;
                              case WTEMP_WU      : SP->Status = S_RECEIVING;
                                                   break;
                              case WTEMP_RESULT  : SP->Status = S_READY;
                                                   break;
                           }
                           break;
      case STATE_EMPTY   : SP->Status= S_WAITING;
                           break;
      case STATE_OK      : {
                           int MaxNcfft;
                             if (SP->Major_Version < 3)
                               MaxNcfft=MAXNCFFT2;
                             else
                               MaxNcfft=MAXNCFFT3;

                             if (WTempStatus==WTEMP_WU)
                                SP->Status=S_RECEIVING;
                             else
                             if (SP->Ncfft==MaxNcfft)
                                SP->Status=S_READY;
                             else {
                                if ( (SP->Progress!=SP->p1) ||
                                     (SP->Progress!=SP->p2) ||
                                     (SP->Progress!=SP->p3) )
                                   SP->Status=S_WORKING;  // "luft"
                                else
                                if ( (SP->Progress==SP->p1) &&
                                     (SP->Progress==SP->p2) &&
                                     (SP->Progress==SP->p3) )
                                   SP->Status=S_WAITING;  // "steht"
                             }
                           }
                           break;  
   }
}

int TChart::ScanSeti(QListViewItem* QL, QDir D) {
// Einen Eintrag scannen (den im Verzeichnus "D"), und die Werte aktualisieren
SetiPtr SP;
QString Datei,Strg;
QString Ext;    // Dateierweiterung (.txt fr V<2.0, .sah fr >= V2.0)

//debug("Dir=%s",D.absPath().data());
   Strg=QL->text(NUMBER);
   SP=(SetiPtr)(Strg.toULong());
   SP->Status=S_NONE;
   StateStatus=STATE_MISSING;

   memset(&(SP->Ncfft), 0, sizeof(SetiRec)
                           -sizeof(SP->Name)
                           -sizeof(SP->Path)
                           -4*sizeof(double)
                           -sizeof(int)
                           -sizeof(void*)
                           -sizeof(int)
                           -sizeof(SP->GArr));

//debug("SP.Path=%s",SP->Path);

   // Dateiendung ermitteln
   if (QFile::exists(D.absPath()+"/pid.sah"))
      Ext=".sah";
   else
      Ext=".txt";
   // -------------------------------
   // Datei "version.sah" auswerten
   // -------------------------------
   ScanVersion(D.absPath()+"/version"+Ext, SP);

   // -----------------------------
   // Datei "state.txt/sah" analysieren
   // -----------------------------
   ScanState(D.absPath()+"/state"+Ext, SP);

   ScanWTemp(D.absPath()+"/wtemp"+Ext, SP);

   // -------------------------------
   // Datei "user_info.txt" auswerten
   // -------------------------------
   ScanUserInfo(D.absPath()+"/user_info"+Ext, SP);


   // -------------------------------
   // Datei "work_unit.txt" auswerten
   // -------------------------------
   if (!ScanWorkUnit(D.absPath()+"/work_unit"+Ext, SP, 25))
      ScanWorkUnit(D.absPath()+"/result"+Ext, SP, 42);


   CalcStatus(SP);

   // Grid  aktualisieren
   UpdateGrid(QL,SP);

   return 0;
}

void TChart::UpdateGrid(QListViewItem* QL, SetiPtr SP){
// Grid aktualisieren
char Progress[20];
double T;         // Zeit fr eine Unit
int Day,Hour,Minute,Second;
QTime QT;
QDateTime QDT;
QString Strg;
QDate QD;

   if (SP->Status==S_RECEIVING)
      sprintf(Progress,"%0.0f Kb", SP->Progress);
   else
      sprintf(Progress,"%0.3f %%", (SP->Progress<0)?0:SP->Progress*100.0);

   if ( ((SP->Status==S_WORKING)||(SP->Status==S_WAITING)||(SP->Status==S_READY))
        && (SP->Progress>0) ) {
      // verbleibende Zeit
      T=(1.0-SP->Progress)/SP->Progress*SP->Cpu;
      QDT = QDateTime::currentDateTime();
      QDT=QDT.addSecs(T);

      QT=QTime::currentTime();
      QT=QT.addSecs(T);
      Hour=(int)(T/3600);
      T-=(Hour*3600);
      Minute=(int)(T/60);
      T-=(Minute*60);
      Second=(int)T;
      if (SP->Status!=S_READY)
         sprintf(SP->Remain,"%02d:%02d.%02d",Hour,Minute,Second);
      else
         SP->Remain[0]=0;

      QT = QDT.time();
      Strg = QT.toString();
      Strg.truncate(5);
      Day=QDT.date().dayOfWeek();
      Strg = (QString)(QD.dayName(Day))+" "+Strg;
      if (SP->Status==S_WORKING)
         strcpy(SP->Finish, Strg.data() );
      else
         SP->Finish[0]=0;

      // GesamtZeit Zeit
      if (SP->Status==S_READY)  // fertige Unit, Gesamtzeit=verstichene Zeit
         T=SP->Cpu;
      else
         T=1.0/SP->Progress*SP->Cpu;
      if (T!=0)
         sprintf(SP->PercentHour,"%0.2f",360000.0/T);
      else
         SP->PercentHour[0]='\0';
      Hour=(int)(T/3600);
      T-=(Hour*3600);
      Minute=(int)(T/60);
      T-=(Minute*60);
      Second=(int)T;
      sprintf(SP->Total,"%02d:%02d.%02d",Hour,Minute,Second);

      // verstrichene Zeit
      T=SP->Cpu;
      Hour=(int)(T/3600);
      T-=(Hour*3600);
      Minute=(int)(T/60);
      T-=(Minute*60);
      Second=(int)T;
      sprintf(SP->Elapsed,"%02d:%02d.%02d",Hour,Minute,Second);
   } else {
      strcpy(SP->Elapsed, "\0");
      strcpy(SP->Remain, "\0");
      strcpy(SP->Finish, "\0");
      strcpy(SP->Total, "\0");
      strcpy(SP->PercentHour, "\0");
   }

/*   if (SP->Status==SP->StatusAlt) {
      if ( (SP->Status != S_WORKING) && (SP->Status!=S_RECEIVING) )
         return;  // keine nderung, nicht aktualisieren
   }*/

   switch (SP->Status) {
      case S_NONE    : // unbekannter Status
                       QL->setText(USER,SP->UserName);
                       QL->setText(COMPLETE,Progress);
                       QL->setText(TREMAIN,"");
                       QL->setText(TFINISH,"");
                       break;
      case S_READY   : // Berechnung fertig
                       QL->setText(USER,SP->UserName);
                       QL->setText(COMPLETE,Progress);
                       QL->setText(TREMAIN,"");
                       QL->setText(TFINISH,"");
                       break;
      case S_WORKING : // Berechnung luft
                       QL->setText(USER,SP->UserName);
                       QL->setText(COMPLETE,Progress);
                       QL->setText(TREMAIN,SP->Remain);
                       //QL->setText(TFINISH,QT.toString());
                       QL->setText(TFINISH,SP->Finish);
                       break;
      case S_NODATA  : // kein Seti hier :-((
                       QL->setText(USER,"");
                       QL->setText(COMPLETE,"");
                       QL->setText(TREMAIN,"");
                       QL->setText(TFINISH,"");
                       break;
      case S_WAITING : // keine Berechnung
                       QL->setText(USER,SP->UserName);
                       QL->setText(COMPLETE,Progress);
                       QL->setText(TREMAIN,"");
                       QL->setText(TFINISH,"");
                       break;
      case S_RECEIVING : // neue WU kommt
                       QL->setText(USER,SP->UserName);
                       QL->setText(COMPLETE,Progress);
                       QL->setText(TREMAIN,"");
                       QL->setText(TFINISH,"");
                       break;
   }
   if (SP->Status!=SP->StatusAlt)
      SetStatus(QL, SP->Status);
   SP->StatusAlt=SP->Status;
}

int TChart::AddSeti(QString Name, QString Dir) {
SetiPtr SP;
QString Strg;
QListViewItem *QL;

   debug("AddSeti %s  %s",Name.data(), Dir.data());
   if (Name.isEmpty()) return -1;  // kein Name angegeben
   if (Dir.isEmpty())  return -2;  // kein Verzeichnis angegeben
   SP = (SetiPtr)malloc(sizeof (SetiRec));
   if (SP==NULL) return -3;        // kein Speicher

   memset(SP, 0, sizeof(SetiRec));
   Strg.setNum((unsigned long int)(SP));
   strcpy(SP->Name, Name.data());
   strcpy(SP->Path, Dir.data());
   SP->DetailWindow=NULL;
   SP->Ncfft=-1;
   SP->Cpu=SP->Progress=SP->p1=SP->p2=SP->p3=-1;
   SP->Status=S_NONE;
   SP->StatusAlt=S_NONE;
   SP->PanelDisplay=FALSE;

   // Stringlisten eintragen
   // Setilist
   QL=new QListViewItem(SetiList);
   SetStatus(QL, S_NONE);
   QL->setText(NAME, Name);
   QL->setText(NUMBER, Strg);
   QL->setText(USER, "");
   QL->setText(PFAD, Dir);
   SetiCount++;

   // Userlist
   QL=new QListViewItem(UserList);
   QL->setText(U_NAME, Name);
   QL->setText(U_NUMBER, Strg);
   QL->setText(U_COUNTRY, "");
   QL->setText(U_POSTAL, "");
   QL->setText(U_EMAIL, "");

   // Timeslist
   QL=new QListViewItem(TimesList);
   QL->setText(T_NAME, Name);
   QL->setText(T_NUMBER, Strg);
   QL->setText(T_ELAPSED, "");
   QL->setText(T_REMAIN, "");
   QL->setText(T_FINISH, "");
   QL->setText(T_TOTAL, "");
   QL->setText(T_PERCENTHOUR, "");

   // UnitList1
   QL=new QListViewItem(UnitList1);
   QL->setText(N1_NAME, Name);
   QL->setText(N1_NUMBER, Strg);
   QL->setText(N1_COMPLETE, "");
   QL->setText(N1_PEAK_POWER, "");
   QL->setText(N1_PEAK_SCORE, "");
   QL->setText(N1_GAUSSIAN_POWER, "");
   QL->setText(N1_GAUSSIAN_SCORE, "");
   QL->setText(N1_GAUSSIAN_FIT, "");

   // UnitList2
   QL=new QListViewItem(UnitList2);
   QL->setText(N2_NAME, Name);
   QL->setText(N2_NUMBER, Strg);
   QL->setText(N2_COMPLETE, "");
   QL->setText(N2_PULSE_POWER, "");
   QL->setText(N2_PULSE_SCORE, "");
   QL->setText(N2_PULSE_PERIOD, "");
   QL->setText(N2_TRIPLET_POWER, "");
   QL->setText(N2_TRIPLET_PERIOD, "");

   // UnitTimesList
   QL=new QListViewItem(UnitTimesList);
   QL->setText(UT_NAME, Name);
   QL->setText(UT_NUMBER, Strg);
   QL->setText(UT_USER, "");
   QL->setText(UT_REGTIME, "");
   QL->setText(UT_LASTWUTIME, "");
   QL->setText(UT_LASTRESULTTIME, "");

   // LocationList
   QL=new QListViewItem(LocationList);
   QL->setText(L_NAME, Name);
   QL->setText(L_NUMBER, Strg);
/*   QL->setText(UT_USER, "");
   QL->setText(UT_REGTIME, "");
   QL->setText(UT_LASTWUTIME, "");
   QL->setText(UT_LASTRESULTTIME, "");*/

   // VersionList
   QL=new QListViewItem(VersionList);
   QL->setText(V_NAME, Name);
   QL->setText(V_NUMBER, Strg);
   QL->setText(V_CLIENT, "");
   QL->setText(V_WORKUNIT, "");
   QL->setText(V_SPLITTER, "");
   QL->setText(V_TAPE, "");
}

void TChart::UpdateUserGrid(){
// Userdaten-Grid aktualisieren
QListViewItem *QL;
SetiPtr SP;
QString Strg;
char S[128];

   QL = UserList->firstChild();
   while (QL) {
      Strg=QL->text(U_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if ( (SP->Status!=S_NONE) && (SP->Status!=S_NODATA) ) {
         QL->setText(U_USERNAME, SP->UserName);
         QL->setText(U_COUNTRY, SP->Country);
         QL->setText(U_POSTAL, SP->Plz);
         sprintf(S,"%d",SP->NumResults);
         QL->setText(U_NUM_RESULTS, S);
         if (SP->TotalCpu>31557600.0)
            sprintf(S,"%0.2f Yrs",(SP->TotalCpu)/31557600.0);
         else
            sprintf(S,"%0.2f Hrs",(SP->TotalCpu)/3600.0);
         QL->setText(U_TOT_CPU, S);
         QL->setText(U_EMAIL, SP->Email);
      }

      QL = QL->nextSibling();
   }
}

void TChart::UpdateTimesGrid(){
// Zeitendaten-Grid aktualisieren
QListViewItem *QL;
SetiPtr SP;
QString Strg;
char Progress[20];

   QL = TimesList->firstChild();
   while (QL) {
      Strg=QL->text(U_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if (SP->Status!=S_NODATA) {
         if (SP->Status==S_RECEIVING)
            sprintf(Progress,"%0.0f Kb", SP->Progress);
         else
            sprintf(Progress,"%0.3f %%", (SP->Progress<0)?0:SP->Progress*100.0);
         QL->setText(T_ELAPSED, SP->Elapsed);
         QL->setText(T_COMPLETE, Progress);
         QL->setText(T_REMAIN, SP->Remain);
         QL->setText(T_FINISH, SP->Finish);
         QL->setText(T_TOTAL, SP->Total);
         QL->setText(T_PERCENTHOUR, SP->PercentHour);
      }

      QL = QL->nextSibling();
   }
}

void TChart::UpdateUnitsGrid(){
// Unitdaten-Grid aktualisieren
QListViewItem *QL;
SetiPtr SP;
QString Strg;
char S[20];

   // --- Tab Analysis 1 -----
   QL = UnitList1->firstChild();
   while (QL) {
      Strg=QL->text(N1_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if (SP->Status!=S_NODATA) {
         if (SP->Status==S_RECEIVING)
            sprintf(S,"%0.0f Kb", SP->Progress);
         else
            sprintf(S,"%0.1f %%", (SP->Progress<0)?0:SP->Progress*100.0);
         QL->setText(N1_COMPLETE, S);

         // Die Peak-Werte nur anzeigen, wenn bereits ein Teil der
         // Unit berechnet wurde.
         if (SP->Progress>0) {
            sprintf(S,"%0.5f", SP->Bs_Power);
            QL->setText(N1_PEAK_POWER, S);
            sprintf(S,"%0.5f", SP->Bs_Score);
            QL->setText(N1_PEAK_SCORE, S);
            sprintf(S,"%0.5f", SP->Bg_Power);
            QL->setText(N1_GAUSSIAN_POWER, S);
            sprintf(S,"%0.5f", SP->Bg_Score);
            QL->setText(N1_GAUSSIAN_SCORE, S);
            sprintf(S,"%0.5f", SP->Bg_Chisq);
            QL->setText(N1_GAUSSIAN_FIT, S);
         } else {
            QL->setText(N1_PEAK_POWER, "");
            QL->setText(N1_PEAK_SCORE, "");
            QL->setText(N1_GAUSSIAN_POWER, "");
            QL->setText(N1_GAUSSIAN_SCORE, "");
            QL->setText(N1_GAUSSIAN_FIT, "");
         }
      }

      QL = QL->nextSibling();
   }


   // --- Tab Analysis 2 -----
   QL = UnitList2->firstChild();
   while (QL) {
      Strg=QL->text(N2_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if (SP->Status!=S_NODATA) {
         if (SP->Status==S_RECEIVING)
            sprintf(S,"%0.0f Kb", SP->Progress);
         else
            sprintf(S,"%0.1f %%", (SP->Progress<0)?0:SP->Progress*100.0);
         QL->setText(N2_COMPLETE, S);

         // Die Peak-Werte nur anzeigen, wenn bereits ein Teil der
         // Unit berechnet wurde.
         if (SP->Progress>0) {
            sprintf(S,"%0.5f", SP->Bp_Power);
            QL->setText(N2_PULSE_POWER, S);
            sprintf(S,"%0.5f", SP->Bp_Score);
            QL->setText(N2_PULSE_SCORE, S);
            sprintf(S,"%0.5f", SP->Bp_Period);
            QL->setText(N2_PULSE_PERIOD, S);
            sprintf(S,"%0.5f", SP->Bt_Power);
            QL->setText(N2_TRIPLET_POWER, S);
            sprintf(S,"%0.5f", SP->Bt_Period);
            QL->setText(N2_TRIPLET_PERIOD, S);
         } else {
            QL->setText(N2_PULSE_POWER, "");
            QL->setText(N2_PULSE_SCORE, "");
            QL->setText(N2_PULSE_PERIOD, "");
            QL->setText(N2_TRIPLET_POWER, "");
            QL->setText(N2_TRIPLET_PERIOD, "");
         }
      }

      QL = QL->nextSibling();
   }
}

void TChart::UpdateUnitTimesGrid(){
// Unit-Zeitendaten-Grid aktualisieren
QListViewItem *QL;
SetiPtr SP;
QString Strg;

   QL = UnitTimesList->firstChild();
   while (QL) {
      Strg=QL->text(UT_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if (SP->Status!=S_NODATA) {

         QL->setText(UT_USER, SP->UserName);
         QL->setText(UT_REGTIME, SP->RegTime);
         QL->setText(UT_LASTWUTIME, SP->LastWuTime);
         QL->setText(UT_LASTRESULTTIME, SP->LastResultTime);
      }

      QL = QL->nextSibling();
   }
}

void TChart::UpdateLocationGrid(){
// Unit-Zeitendaten-Grid aktualisieren
QListViewItem *QL;
SetiPtr SP;
QString Strg;
char S[64];
double t1,t2;
int h1,m1,s1,h2,m2,s2;

   QL = LocationList->firstChild();
   while (QL) {
      Strg=QL->text(L_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if (SP->Status!=S_NODATA) {

         QL->setText(L_SOURCE, SP->Receiver);
         t1=SP->Start_Ra;
         h1=(int)t1;
         t1-=h1;t1*=60.0;
         m1=(int)t1;
         t1-=m1;t1*=60.0;
         s1=(int)t1;

         t2=SP->End_Dec;
         h2=(int)t2;
         t2-=h2;t2*=60.0;
         m2=(int)t2;
         t2-=m2;t2*=60.0;
         s2=(int)t2;
         sprintf(S,"%dh %dm %ds RA, %ddeg %dm %ds dec",h1,m1,s1,h2,m2,s2);
         QL->setText(L_LOCATION, S);
         QL->setText(L_RECTIME, SP->Time_Recorded);
         sprintf(S,"%0.9f",0.000000001*SP->Subband_Base);
         QL->setText(L_BASEFREQ, S);
         QL->setText(L_WUNAME, SP->WuName);
      }

      QL = QL->nextSibling();
   }
}

void TChart::UpdateVersionGrid(){
// Versionen-Grid aktualisieren
QListViewItem *QL;
SetiPtr SP;
QString Strg;

   QL = VersionList->firstChild();
   while (QL) {
      Strg=QL->text(V_NUMBER);
      SP=(SetiPtr)(Strg.toULong());

      if (SP->Status!=S_NODATA) {

         Strg.sprintf("%d.%d",SP->Major_Version, SP->Minor_Version);
         QL->setText(V_CLIENT, Strg);
         Strg.sprintf("%d",SP->Seti_Version);
         QL->setText(V_WORKUNIT, Strg);
         QL->setText(V_SPLITTER, SP->Splitter_Version);
         Strg.sprintf("%0.3f",SP->Tape_Version);
         QL->setText(V_TAPE, Strg);
      }

      QL = QL->nextSibling();
   }
}

void TChart::ShowDetails() {
SetiPtr SP;
DetailsDlg *ddlg;

   SP=GetCurrentSeti();
   if (SP) {
      if (SP->DetailWindow==NULL) {
         ddlg = new DetailsDlg(SP, SP->Name);
         SP->DetailWindow=ddlg;
         ddlg->show();
      }
   }
}

void TChart::ShowSkymap() {

   if (Skymap==NULL)
      Skymap = new SkymapDlg(this, this, "Skymap");
   Skymap->show();
}

void TChart::ShowPanelIcon() {
SetiPtr SP;

   debug ("ShowPanelIcon");

   SP=GetCurrentSeti();
   if (SP) {
      if (pdk==NULL)
         pdk = new DoubleDock();
      if (pdk->SP)
         pdk->SP->PanelDisplay=FALSE;  // dieser wird nicht mehr angezeigt
      pdk->SetSeti(SP);
      SP->PanelDisplay=TRUE;
      pdk->Update();
   }
}

void TChart::SetupOptions() {
OptionsDlg odlg(this, this, "");

   if (odlg.exec()) {
      SetUpdateIntervall(odlg.IntervallSlider->value());
      StartupFile = odlg.LoadEdit->text();
   }
}

void TChart::PanelViewOptions() {
PanelOptDlg podlg(this, "");

   if (podlg.exec()) {
      podlg.SetData();
      if (pdk)
         pdk->Update();
      debug("ok");
   }
}

int TChart::GetUpdateIntervall() {
   return Intervall;
}

int TChart::SetUpdateIntervall(int Interv) {
// Updateintervall setzen ( Angabe in Sekunden)
int I;
int ret=0;

   I=Interv;
   if (I<1) {I=1; ret=-1; }
   if (I>30) {I=30; ret=-2; }
   I=I*1000;   // in ms umwandeln
   Intervall=I;
   Timer->changeInterval(I);
   return ret;
}

void TChart::ReadConfig() {
int i;

   Config = KApplication::getKApplication()->getConfig();
   Config->setGroup("General");
   StartupFile = Config->readEntry("Startupfile","");
   i = Config->readNumEntry("Updateintervall", 10);
   FirstLineType = Config->readNumEntry("PnlFirstLine", -1); //P1_NAME);
   SecondLineType = Config->readNumEntry("PnlSecondLine", -2);//P2_PERCENT);
   
   // Rangecheck
   if ( (FirstLineType<0) ||(FirstLineType>=FIRSTMAX)) FirstLineType=0;
   if ( (SecondLineType<0) ||(SecondLineType>=SECONDMAX)) SecondLineType=0;
   
   if (!StartupFile.isEmpty())
      AddWatches(StartupFile);
   SetUpdateIntervall(i);
}

void TChart::SaveConfig() {

   Config = KApplication::getKApplication()->getConfig();
   Config->setGroup("General");
   Config->writeEntry("Startupfile", StartupFile);
   Config->writeEntry("Updateintervall", Intervall/1000);
   Config->writeEntry("PnlFirstLine", FirstLineType);
   Config->writeEntry("PnlSecondLine", SecondLineType);
}

void TChart::SaveOptions() {
   SaveConfig();
}

void TChart::TabSelectClick(int Tab) {
   debug("Tab=%d",Tab);
   CurrentTab=Tab;
}

QListViewItem* TChart::GetCurrentWatch(void) {
// markierten Eintrag in der Liste bestimmen
QListViewItem* QL=NULL;

   switch (CurrentTab) {
      case 0 :  QL=SetiList->currentItem();
                break;
      case 1 :  // userlist
                QL=UserList->currentItem();
                break;
      case 2 :  // Timeslist
                QL=TimesList->currentItem();
                break;
      case 3 :  // Unitlist1
                QL=UnitList1->currentItem();
                break;
      case 4 :  // Unitlist2
                QL=UnitList2->currentItem();
                break;
      case 5  : // UnitTimesList
                QL=UnitTimesList->currentItem();
                break;
      case 6 :  // Locationlist
                QL=LocationList->currentItem();
                break;
      case 7 :  // Versionlist
                QL=VersionList->currentItem();
                break;
      default : debug ("Invalid Tab %d",CurrentTab);
   }

   return QL;
}

SetiPtr TChart::GetCurrentSeti(void) {
// markierten Eintrag in der Liste bestimmen
SetiPtr SP;
QListViewItem* QL=NULL;
QString Strg;
bool Ok;

   switch (CurrentTab) {
      case 0 :  QL=SetiList->currentItem();
                if (QL)
                   Strg=QL->text(NUMBER);
                break;
      case 1 :  // userlist
                QL=UserList->currentItem();
                if (QL)
                   Strg=QL->text(U_NUMBER);
                break;
      case 2 :  // Timeslist
                QL=TimesList->currentItem();
                if (QL)
                   Strg=QL->text(T_NUMBER);
                break;
      case 3 :  // Unitlist1
                QL=UnitList1->currentItem();
                if (QL)
                   Strg=QL->text(N1_NUMBER);
                break;
      case 4 :  // Unitlist2
                QL=UnitList2->currentItem();
                if (QL)
                   Strg=QL->text(N2_NUMBER);
                break;
      case 5  : // UnitTimesList
                QL=UnitTimesList->currentItem();
                if (QL)
                   Strg=QL->text(UT_NUMBER);
                break;
      case 6 :  // Locationlist
                QL=LocationList->currentItem();
                if (QL)
                   Strg=QL->text(L_NUMBER);
                break;
      case 7 :  // Versionlist
                QL=VersionList->currentItem();
                if (QL)
                   Strg=QL->text(L_NUMBER);
                break;
      default : debug ("Invalid Tab %d",CurrentTab);
   }

   
   if (QL) {
      // Zeiger auf die Datenstruktur ermitteln
      SP=(SetiPtr)(Strg.toULong(&Ok));
      if (Ok) {
         return SP;
      }
   }
   return NULL;
}

void TChart::ShowPnlPopup(QMouseEvent*e) {
   //debug("ShowPopup");
   if (e->button()==RightButton)
      Popup->popup(e->globalPos());
   else
   if (e->button()==LeftButton) {
      if (toplevel->isVisible())
         toplevel->hide();
      else
         toplevel->show();
   }
}

void TChart::MouseClick(QListViewItem *QL, const QPoint &QP, int) {
   switch (CurrentTab) {
      case 0 : SetiList->setCurrentItem(QL);
               SetiList->setSelected(QL,TRUE);
               break;
      case 1 : UserList->setCurrentItem(QL);
               UserList->setSelected(QL,TRUE);
               break;
      case 2 : TimesList->setCurrentItem(QL);
               TimesList->setSelected(QL,TRUE);
               break;
      case 3 : UnitList1->setCurrentItem(QL);
               UnitList1->setSelected(QL,TRUE);
               break;
      case 4 : UnitList2->setCurrentItem(QL);
               UnitList2->setSelected(QL,TRUE);
               break;
      case 5 : UnitTimesList->setCurrentItem(QL);
               UnitTimesList->setSelected(QL,TRUE);
               break;
      case 6 : LocationList->setCurrentItem(QL);
               LocationList->setSelected(QL,TRUE);
               break;
      case 7 : VersionList->setCurrentItem(QL);
               VersionList->setSelected(QL,TRUE);
               break;
   }
   debug("MouseEvent  %s",QL->text(0));
   ListPopup->popup(QP, 1);
}
