// globals.h
#ifndef _GLOBALS_H_
#define _GLOBALS_H_

#define MAXSETI 1024

// Anzeige im Panel
// 1. Zeile
#define P1_NAME 0      // Benutzername
#define P1_USER 1      // Anmeldename
#define P1_PERCENT 2   // % fertig
#define P1_ELAPSED 3   // bisher gebrauchte Zeit
#define P1_REMAINING 4 // noch bentigte Zeit
// 2.Zeile
#define P2_USER 0
#define P2_PERCENT 1
#define P2_ELAPSED 2
#define P2_REMAINING 3
#define P2_PEAK 4
#define P2_GAUSSIAN 5


// Berechnungsstatus
#define S_NONE 0       // unbekannter Status
#define S_READY 1      // Berechnung fertig
#define S_WORKING 2    // Berechnung luft
#define S_NODATA 3     // kein Seti hier :-((
#define S_WAITING 4    // keine Berechnung
#define S_RECEIVING 5  // neue WU-bertragung

// "state.txt" Status
#define STATE_MISSING -1  // state.txt nicht vorhanden
#define STATE_EMPTY   -2  //   "       ist leer (Dateigre 0)
#define STATE_OK      -3

// "wtemp.txt" Status
#define WTEMP_MISSING -1  // wtemp.txt nicht vorhanden
#define WTEMP_WU      -2  //   "       ist neue Unit
#define WTEMP_RESULT  -3  //   "       ist Ergebnisdatei

// Spaltenkoordinaten
#define STATUS 0
#define NAME 1
#define NUMBER 2
#define USER 3
#define COMPLETE 4
#define TREMAIN 5
#define TFINISH 6
#define PFAD 7

#define U_NAME 0
#define U_NUMBER 1
#define U_USERNAME 2
#define U_COUNTRY 3
#define U_POSTAL 4
#define U_NUM_RESULTS 5
#define U_TOT_CPU 6
#define U_EMAIL 7

#define N1_NAME 0
#define N1_NUMBER 1
#define N1_COMPLETE 2
#define N1_PEAK_POWER 3
#define N1_PEAK_SCORE 4
#define N1_GAUSSIAN_POWER 5
#define N1_GAUSSIAN_SCORE 6
#define N1_GAUSSIAN_FIT 7

#define N2_NAME 0
#define N2_NUMBER 1
#define N2_COMPLETE 2
#define N2_PULSE_SCORE 3
#define N2_PULSE_POWER 4
#define N2_PULSE_PERIOD 5
#define N2_TRIPLET_POWER 6
#define N2_TRIPLET_PERIOD 7

#define T_NAME 0
#define T_NUMBER 1
#define T_COMPLETE 2
#define T_ELAPSED 3
#define T_REMAIN 4
#define T_FINISH 5
#define T_TOTAL 6
#define T_PERCENTHOUR 7

#define UT_NAME 0
#define UT_NUMBER 1
#define UT_USER 2
#define UT_REGTIME 3
#define UT_LASTWUTIME 4
#define UT_LASTRESULTTIME 5

#define L_NAME 0
#define L_NUMBER 1
#define L_SOURCE 2
#define L_LOCATION 3
#define L_RECTIME 4
#define L_BASEFREQ 5
#define L_WUNAME 6

#define V_NAME 0
#define V_NUMBER 1
#define V_CLIENT 2
#define V_WORKUNIT 3
#define V_SPLITTER 4
#define V_TAPE 5

#define GARRMAX 64    // # Werte im Gaussian-Array
#define PARRMAX 512   // # Werte im Pulse-Array
#define TARRMAX 256   // # Werte im Triplet-Array

struct SetiRec {
   char Name[40];
   char Path[512];
   double Progress,p1,p2,p3;  // Progress 0..1
   int StatusAlt;
   void* DetailWindow;
   int PanelDisplay; // Anzeige dieses Seti im Panel
   float GArr[GARRMAX];   // Gaussian-Array
   // ab hier wird bei jeden Aktualisieren alles gelscht...
   int Ncfft;            // Progress 0..9024
   double Cr;            // Doppler Drift
   int Fl;               // Fouier length
   double Cpu;           // CPU time (seconds)
   double Bs_Power;      // strongest peak
   double Bs_Score;      // peak
   double Bs_Chirp_Rate; // Peak Drift Rate
   double Bg_Score;      // Gaussian Score
   double Bg_Power;      // Gaussian Power
   double Bg_Chisq;      // Gaussian Fit
   double Bg_Chirp_Rate; // Gaussian Drift Rate

   double Bp_Score,      // Pulse Score
          Bp_Power,      // Pulse Score
          Bp_Period,     // Pulse Period
          Bt_Power,      // Triplet Power
          Bt_Period,     // Troplet Period
          Bt_Ind0,
          Bt_Ind1,       // Positionen der drei Pulse
          Bt_Ind2;

   char Bp_Data[1100],   // Pulse data
        Bt_Data[1100];   // Triplet data

   int Bg_Fft_Ind;

   int Status;
   
   // Userdata
   unsigned long int Id,Key;
   char Email[256];
   char UserName[256];
   char Url[256];
   char Country[64];
   char Plz[16];
   char RegTime[64], LastWuTime[64],LastResultTime[64];
   int NumWu,NumResults;
   double TotalCpu;

   // Workunit-Data
   char WuName[40];
   double Start_Ra;              // From Time
   double Start_Dec;             // Degree Time
   double End_Ra;
   double End_Dec;
   double Angle_Range;
   char Time_Recorded[40];       // Recorded on Time
   double Subband_Base;          // Base Frequency
   double Subband_Sample_Rate;   // Sample Rate
   char Receiver[64];            // Arecibo

   // Versionsinfo
   int Major_Version,    // Programm
       Minor_Version;

   int Seti_Version;
   char Splitter_Version[10];
   double Tape_Version;

   // Times
   char Elapsed[16], Remain[16], Finish[16], Total[16], PercentHour[16];
};
typedef struct SetiRec *SetiPtr;

#endif