#ifndef __SHELLEXEC__
#define __SHELLEXEC__

#include <ktopwidget.h>
#include <kstatusbar.h>
#include <kprocess.h>
#include <qlist.h>
#include <qlistbox.h>
#include <qmlined.h>
#include <ktablistbox.h>
#include <qtimer.h>

class shellExec : public QObject
{
    Q_OBJECT;

public:
    shellExec();
    virtual ~shellExec();


    QList <QString> PrinterList;  // All Printer we have

    QList <QString>*lpqstdout;
    QString selectedPrinter;

    int lpqrunning;

private:    
	/* Bools*/
	int holdall;
	int LpcCommand;
	
	char *lpqbuf;
	char *lpqbufrun; // run Variable
	QString LpqBuffer;
	QString LpcBuffer;
	
	/* KProcess */

	KProcess *lpq;
	KProcess *lpc;
	KProcess *lprm;
	
public slots:


	/* Processes */
	void LpqReadStdout(KProcess *, char *, int);
	void LpqProcessExited(KProcess *);
	
	void LpcExecute();
	void LpcReadStdout(KProcess *, char *, int);
	void LpcProcessExited(KProcess *);

	void ListPrintQueue();
	void RemoveJob();
	
	void HoldAll();
	void ReleaseAll();
	void HoldAllStatus();

protected slots:
};
#endif
