/*
	This file is part of `klp', a KDE Line Printer queue manager

	Copyright (C) 1998
	Frans van Dorsselaer
	<dorssel@MolPhys.LeidenUniv.nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>

#include <kapp.h>

#include "mainw.h"
#include "inter.h"
#include "options.h"


int main(int argc, char **argv)
{
	if (!start_server()) {
		fprintf(stderr, "klp: could not start child process\n");
		return EXIT_FAILURE;
	}
	drop_root();

	KApplication app(argc, argv, "klp");

	if (app.isRestored()) {
		int n = 1;
		while (MainWindow::canBeRestored(n))
			(new MainWindow)->restore(n++);
	} else {
		struct options opts;
		parse_options(&opts, argc, argv);
		MainWindow *main_window = new MainWindow(&opts);
		if (main_window->shouldShow())
			main_window->show();
	}

	return app.exec();
}
