#ifndef QUEUEBOX_H
#define QUEUEBOX_H


#include <ktablistbox.h>


typedef struct {
	int rank;
	QString job_name;
	QString user;
	QString job_id;
	int size;
} QueueItem;


typedef QList<QueueItem> QueueItemList;


class QueueBox : public KTabListBox
{
	Q_OBJECT
public:
	QueueBox(QWidget *parent);
	void setQueueItemList(QueueItemList *new_list);
	QString & userAt(unsigned int i) { return queue_item_list.at(i)->user; };
	QString & jobIdAt(unsigned int i) { return queue_item_list.at(i)->job_id; };
	bool haveOwnedJob();
private:
	QueueItemList queue_item_list;
};


#endif QUEUEBOX_H
