#ifndef DOCK_H
#define DOCK_H

#include <qlabel.h>
#include <qstring.h>

#include "common.h"

class QMouseEvent;
class KDNDDropZone;
class MainWindow;


class DockWindow : public QLabel
{
	Q_OBJECT
public:
	DockWindow(MainWindow *mw);
	virtual ~DockWindow();
protected slots:
	void setPrinterState(PrinterState new_state);
	void setActivePrinter(int active);
	void setBusy(bool b);
protected:
	virtual void mousePressEvent(QMouseEvent *event);
	virtual void mouseDoubleClickEvent(QMouseEvent *event);
	void setPixmap();
private:
	bool busy;
	PrinterState printer_state;
	QString description;
	MainWindow *main_window;
	KDNDDropZone *drop_zone;
};


#endif // DOCK_H
