
/* memtest: testet, wie viel Hauptspeicher am Stueck durch
   malloc() angefordert werden kann. Ausgabe auf stdout.
*/

#undef MSDOOF

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef MSDOOF
  #include <alloc.h>
  #define xmalloc(n) farmalloc(n)
#else
  #define xmalloc(n) malloc(n)
#endif


void quael(char *anfang,long size)
{
    memset(anfang, 42, size);
    /* sleep(1);*/
}

void quael2(char *anfang,long size)
{
    long i,pp;
    for (i = 0;i < 1024;i++) {
	pp = i * (size / 1024);
	anfang[pp] = (char) 42;
    }
    /* sleep(1); */
}


int main(void)
{
    long amount,amount_min,amount_max;
    void *pv;

    amount = 1L;
    while (1) {
        printf("Amount: %ld (0x%x)",amount,amount);
        if ((pv = xmalloc(amount)) == NULL) {
            printf(" Failed!\n");
	    break;
        }	
        printf(" OK!\n");
	quael(pv,amount);
        amount_min = amount;
        amount *= 2;
        free(pv);
    }
    amount_max = 2 * amount_min;
    /* man weiss jetzt: amount_min <= amount < amount_max; */

    /* binaere Suche */
    do {
        amount = (amount_min + amount_max) / 2;
        printf("Amount: %ld (0x%x)",amount,amount);
        if ((pv = xmalloc(amount)) != NULL) {
            printf(" OK!\n");
	    quael(pv,amount);
            amount_min = amount;
            free(pv);
        }
        else {
            amount_max = amount;
            printf(" Failed!\n");
        }
    } while (amount_max > amount_min + 1024);

    printf("Available heap memory: %ld Bytes\n",amount_min);

    return 0;
}
