//
// $Id: kload.h,v 1.7 1998/10/23 11:59:08 pi Exp pi $
//
// $Log: kload.h,v $
// Revision 1.7  1998/10/23 11:59:08  pi
// Checkin for V 0.6
//
// Revision 1.6  1998/10/04 15:57:56  pi
// After first version of Options dialog
//
// Revision 1.5  1998/08/23 19:54:35  pi
// Optionen-Dialog eingebaut
//
// Revision 1.4  1998/08/09 13:53:33  pi
// Menu bar hideable, options menu on right mouse button
//
// Revision 1.3  1998/07/27 19:27:18  pi
// panel visibility mgmt. terminated
//
// 
// 
// Class definition for MyPanel
// 

#ifndef __KLOADH__
#define __KLOADH__

#include <ktopwidget.h>

#include "cpupanel.h"
#include "rampanel.h"
#include "loadpanel.h"
#include "pagepanel.h"

#include "optdialog.h"


class PanelSet: public QWidget
{
    Q_OBJECT
    
private:
    static const int QSECOND = 1000;
    static const int WIDTH    =  100;
    static const int HEIGHT   =  80;
    static const int BORDER   =  5;
        
    static const int maxPanels = 6;
    
    int nPanels; // This many panels form this widget
    
    int redrawInterval; // Seconds between sampling
    
    int alignment;
    
    int timerId; // remembers ID of timer to be killed
    
    LPanel *myPanel[maxPanels];
    bool panelVis[maxPanels];
    QString description[maxPanels];
    
    void doResize(void);
        
private slots:
    void childRightMouse(QPoint q);

protected:
    void resizeEvent(QResizeEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void timerEvent(QTimerEvent *);
    
public:
    PanelSet(QWidget *parent=0, const char *name=0 );
    ~PanelSet() { /* Do Nothing */ }
    
    int getAlignment() const   { return alignment; }
    void setAlignment(int);
    int getNPanels()    const   { return nPanels;   }
    int numVisPanels(void) const; 
    int setPanelVisibility(int, bool);
    bool getPanelVisibility(int i) const { return panelVis[i]; }
    
    const char *getDoubleClickCmd(int i) const 
                                     { return myPanel[i]->getDoubleClickCmd();}
    void setDoubleClickCmd(int i, const char *s) const 
                                     { myPanel[i]->setDoubleClickCmd(s);}
                                     
    const char *getLowBoundCmd(int i)  const { return myPanel[i]->getLowBoundCmd();}
    const char *getHighBoundCmd(int i) const { return myPanel[i]->getHighBoundCmd();}
    float getLowWM(int i)        const { return myPanel[i]->getLowWM();}
    float getHighWM(int i)       const { return myPanel[i]->getHighWM();}
    
    void setLowBoundCmd(int i, const char *l) {myPanel[i]->setLowBoundCmd(l);}
    void setHighBoundCmd(int i, const char *l){myPanel[i]->setHighBoundCmd(l);}
    void setLowWM(int i, float f)             {myPanel[i]->setLowWM(f);}
    void setHighWM(int i, float f)            {myPanel[i]->setHighWM(f);}
    
    const char *getDescription(int i) const { return description[i];}
    const char *getName(int i) const { return myPanel[i]->getName();}
    
    int  getRedrawInterval() const { return redrawInterval; }
    void setRedrawInterval(int);
    
signals:
    void rightMouseButtonPressed(QPoint);
};



class KLoad : public KTopLevelWidget
{
    Q_OBJECT 
    
public:
    KLoad(const char *name=0 );
    ~KLoad();

public slots:
    // This is triggered by the option dialog upon OK or Apply PB
    void applyOptions(OptionSet);
    
private slots:
    void writeConfig();
    void about();
    void popupMouseMenu(QPoint);
    void toggleMenuBar();
    void hideMenuBar();
    void showMenuBar();
    void doOptions();
    void odDestroyed();
    
protected:

private:    
    // The menu       
    KMenuBar *menu;
      QPopupMenu *mFile;      // File
                              //   Exit
      QPopupMenu *mOptions;   // Options
                              //   Preferences
        int mHideShowMenu;    //   Hide/Show Menu bar 
                              // Save Settings
      QPopupMenu *mHelp;      // Help
                              //   About
     
    // The top level widget
    PanelSet *panelSet;
    
    // Options dialog
    OptDialog *od;
    
    void readConfig();
};


#endif
