/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: UpDownButton.h,v 1.4 1999/01/09 18:55:58 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef UPDOWNBUTTON_H
#define UPDOWNBUTTON_H

#include "qframe.h"


class KButton;
class QBoxLayout; 


class UpDownButton : public QFrame
{
  Q_OBJECT
  
private:
  KButton     *up;
  KButton     *down;
  QBoxLayout  *qtarch_layout_1;
  
public:
  
  UpDownButton( 
    QWidget* parent,
    const char* name );
  
  ~UpDownButton();
  
signals:
  void upClicked();
  void downClicked();
  
protected slots:
  void upButtonClicked();
  void downButtonClicked();
  
};


#endif
