/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: DockWidget.cpp,v 1.12 1999/02/03 21:45:03 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <kwm.h>
#include <ktopwidget.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qlcdnum.h>
#include <qpopupmenu.h>

#include <klocale.h>

#include "DockWidget.h"
#include "klm.h"

#include "DynamicTip.h"

extern Klm *w;

DockWidget::DockWidget
(
  QWidget* parent,
  const char* name
  )
:
QLCDNumber( parent, name )
{
  // set the lcd display mode.	
  setFocusPolicy( QWidget::NoFocus );
  setFrameStyle( 49 );
  setSmallDecimalPoint( FALSE );
  setNumDigits( 2 );
  setMode( QLCDNumber::DEC );
  setSegmentStyle( QLCDNumber::Flat );
  
  backGround = QLCDNumber::backgroundColor();
  
  // generate a popup menu for the docked widget
  menu = new QPopupMenu();
  toggleID = menu->insertItem(
      klocale->translate("Show"), 
      this, SIGNAL(clicked()));	
  
  menu->insertItem(
    klocale->translate("Settings"),
    this,
    SIGNAL( showSettings() ));
  
  menu->insertSeparator();
  
  menu->insertItem(
    klocale->translate("Exit"), 
    this, SIGNAL( exit_cmd()));
  
  // create a dynimic tip widget for the dock
  dockTip = new DynamicTip( this );	
}


DockWidget::~DockWidget()
{
  delete menu;
  delete dockTip;
}

QRect DockWidget::tip( const QPoint &p )
{
  QRect r;
  
  r = rect();
  
  if ( r.contains( p ) )
  {
    return r;
  }
  else
  {
    return QRect( 0,0, -1,-1 );
  }
}

void DockWidget::display(int temp, bool alarm, QString &hint )
{
  dockTip->setTip( hint );
  setBackgroundColor( alarm ? red.light() : backGround);	
  QLCDNumber::display( temp );
}	

void DockWidget::mousePressEvent(QMouseEvent *e) {
  if(e->button() == LeftButton)
  {
    emit clicked();
  }
  else
  {
    if ( e->button() == RightButton )
    {
      int x = e->x() + this->x();
      int y = e->y() + this->y();
      
      QString text;
      if(w->isVisible())
      {
        text = klocale->translate("Minimize");
      }
      else
      {
        text = klocale->translate("Restore");
      }
      
      
      menu->changeItem(text, toggleID);
      menu->popup(QPoint(x, y));
      menu->exec();
    }
  }
}

void DockWidget::dock()
{
  KWM::setDockWindow(winId() ); 
  show();
}

#include <DockWidget.moc.cpp>
