//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Class   : AboutWindow 
// Author  : Norbert Drees
// E-Mail  : norbert@et-inf.fho-emden.de
//
//////////////////////////////////////////////////////////////////////////////
//
//  The Constructor:
//  ================
//  AboutWindow(	
//     const char *title,            // Window title
//     const char *text,             // text to scroll
//     const uint lines,             // number of lines to scroll
//     const uint speed,             // scroll speed
//     const uint width = 300,       // width of scroll widget
//     const uint height = 100,      // height of scroll widget
//     const char *picture = 0,      // full path and picture name
//     QWidget *parent = 0,
//     const char *name = 0                                 
//  );
//
//  Usage of AboutWindow:
//  =====================
//
//  QString s;
//  s = "This is a\nabout window";
// 
//  AboutWindow *dlg = new AboutWindow(
//    klocale->translate( "About Test" ),
//    s, 2, 50, 300, 70, about_picture
//  );
//  dlg->exec();
//  delete dlg;  
//
// If you wish to use the class AboutWindow in an KDE-Application,
// add to your CFLAGS the ABOUT_WITH_KDE switch for locale support. 
//
//////////////////////////////////////////////////////////////////////////////

#ifndef ABOUT_H
#define ABOUT_H

#include <qdialog.h>
#include <qpushbt.h>
#include <qtimer.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qlabel.h> 

#ifdef ABOUT_WITH_KDE
#include <kapp.h>
#include <klocale.h>
#endif

class AboutWindow : public QDialog {

	Q_OBJECT

public:
	AboutWindow(	
		const char *title,				// Window title
		const char *text, 				// text to scroll
		const uint lines,					// number of lines to scroll
		const uint speed,             // scroll speed
		const uint width = 300,       // width of scroll widget
		const uint height = 100,      // height of scroll widget 
		const char *picture = 0,      // full path and picture name
		QWidget *parent = 0,
		const char *name = 0
	);

protected:
	void paintEvent( QPaintEvent * );

private slots:
	void scrollText();
	void setScrolling( bool );

private:
	QString str;								// text to scroll
	uint    pos;								// scroll posistion 
	QPushButton  *scroll_label;			// scroll text 
	uint 	  w;									// breite scroll_label
	uint 	  h;									// hoehe scroll_label
	uint	  scroll_height;					// text lines * 100 (Tricki)
	QTimer  *timer;							// Timer for scrolling
	uint    sp;									// Speed for scrolling
};

#endif
