// $Id: prefsdlg.cc,v 1.2 1999/12/18 01:02:24 lord Exp $

#include <kfiledialog.h> 
#include "prefsdlg.h"

#define Inherited prefsdlgData

prefsdlg::prefsdlg(QWidget     *parent,
                   const char  *name,
                   KlavgPrefs  &data
):Inherited( parent, name )
{
    refresh_rate->setValue(data.refresh_rate);
    cmd->setText(data.cmd);

    bg_colour  ->setColor(data.bg_colour  );
    fg_colour  ->setColor(data.fg_colour  );
    grid_colour->setColor(data.grid_colour);
}

prefsdlg::~prefsdlg()
{
}

void prefsdlg::file_chooser_request()
{
    QString s(KFileDialog::getOpenFileName());
    if(s.isNull())
        return;
    else
        cmd->setText(s);
}

KlavgPrefs *prefsdlg::getData()
{
    KlavgPrefs *res=new KlavgPrefs();

    res->refresh_rate = refresh_rate ->value();
    res->cmd          = cmd          ->text()    ;
    res->bg_colour    = bg_colour    ->color()   ;
    res->fg_colour    = fg_colour    ->color()   ;
    res->grid_colour  = grid_colour  ->color()   ;

    return res;
}

#include "prefsdlgData.moc"
#include "prefsdlg.moc"
