#ifndef __PPPSTATUS_H
#define __PPPSTATUS_H

#include <sys/time.h>
#include <linux/isdn.h>

#include <qobject.h>
#include <qtimer.h>


typedef struct
{
  ulong ibytes;
  ulong obytes;
} Siobytes;


typedef struct
{
  ulong   totalBytesIn[2];
  ulong   totalBytesOut[2];
  float   inRate[2], outRate[2];
  ushort  timeHours, timeMins;
} PPPInfo;  


class PPPStatus : public QObject
{
  Q_OBJECT

  struct timeval TimeLast, TimeNow;

  QTimer     *Scanner;

  Siobytes   ioBytes[ISDN_MAX_CHANNELS];
  int        fd;

  PPPInfo    *Info;
  
  private slots:
  
  void slotScanRates();
  
  signals:
  
  void sigNewScan(PPPInfo *);
  
  public:
    
  PPPStatus();
  
};

#endif
