%define kdeprefix /opt/kde
Name: khotkeys
Summary: KHotKeys -- Assign commands to your favourite hotkeys
Version: 1.0.1
Release: 1
Copyright: Artistic License
Group: X11/KDE/Utilities
Source: http://dforce.sh.cvut.cz/~seli/khotkeys-1.0.1.tar.gz
URL: http://dforce.sh.cvut.cz/~seli/khotkeys.html
Distribution: KDE
Packager: Lubos Lunak <l.lunak@email.cz>
Prefix: %{kdeprefix}

%description
This application lets you assign commands to different hotkey
combinations, switch to windows created by these commands and
record keypress sequences.
For example, assign KOrganizer to Ctrl+Alt+O and instead
of looking for KOrganizer on the taskbar, running it from
the menu or pressing Alt+F2 and typing 'korganizer', having two
or more	KOrganizer's running, simply keep pressing Ctrl+Alt+O
all the time and KHotKeys will take care of it.
Recording keypress sequences ( here called macros ) means you
can assign for example 'unsigned' to CTRL+U. And pressing CTRL+U
in a text editor will fill in 'unsigned' as if you have typed it.
This rpm also modifies the startkde script to run khotkeys.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build
export KDEDIR=%{kdeprefix}
./configure --prefix=%{kdeprefix} --with-install-root=$RPM_BUILD_ROOT --disable-path-check 
make

%install
make install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%{kdeprefix}/bin/khotkeys
%{kdeprefix}/bin/kcmhotkeys
%{kdeprefix}/share/applnk/Settings/Keys/kcmhotkeys.kdelnk
%{kdeprefix}/share/doc/HTML/en/kcontrol/kcmhotkeys
%{kdeprefix}/share/locale/cs/LC_MESSAGES/kcmhotkeys.mo

%post
grep "exec kwm$" %{kdeprefix}/bin/startkde >/dev/null
if [ $? -ne 0 ]; then
  echo "Failed to modify your startkde script"
  echo "Please see the documentation how to run khotkeys manually"
else
sed '/exec khotkeys/ d
/KHotKeys/ d
/exec kwm$/ i\
# Run KHotKeys \( added by rpm install script )
/exec kwm$/ i\
(sleep 1 && exec khotkeys ) \&
' %{kdeprefix}/bin/startkde >%{kdeprefix}/bin/startkde.rpmtmp
mv %{kdeprefix}/bin/startkde.rpmtmp %{kdeprefix}/bin/startkde
chmod +x %{kdeprefix}/bin/startkde
fi

%postun
sed '/exec khotkeys/ d
/KHotKeys/ d
' %{kdeprefix}/bin/startkde >%{kdeprefix}/bin/startkde.rpmtmp
mv %{kdeprefix}/bin/startkde.rpmtmp %{kdeprefix}/bin/startkde
chmod +x %{kdeprefix}/bin/startkde
