#ifndef _GPS_PARSER_H_
#define _GPS_PARSER_H_

typedef struct {
	int	chksum;
} GGAData;

typedef struct {
	char mode;
	int fixtype;
	struct	
	{
		int	prn;
	} sat[12];
	double pos_dilution;
	double hor_dilution;
	double ver_dilution;
	int	chksum;
	int newdata;
} GSAData;

typedef struct {
	int	num_sats;
	struct	
	{
		int	prn;
		int	elev;
		int	az;
		int	snr;
	} sat[12];
	int	chksum;
	int newdata;
} GSVData;

typedef struct {
	int	utc_time;
	char	state;
	double	latitude;	
	char	latitude_dir;	
	double	longitude;
	char	longitude_dir;
	double	speed;
	double	heading;
	int	date;
	double	magnetic;
	char	magnetic_dir;
	int	chksum;
	int newdata;
} RMCData;

void gps_init_parser(void);
int gps_parse(char* buf, int count);

#endif
