/***************************************************************************
      testmount.cpp  -  A class for mounting / unmounting a partition
                             -------------------                                         
    begin                : Mon Jul 12 1999                                           
    copyright            : (C) 1999 by Andreas Reuter                         
    email                : Andreas.Reuter@andreas-reuter.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "testmount.h"
#include <kmsgbox.h>
#include <qmultilinedit.h>

TestMount::TestMount( QString argcmd2, QString argcmd3, QString argcmd5, QString argcmd7,
   QWidget *parent, const char *name ) :
      KDialog( parent, name, TRUE, WStyle_Tool )
{
   mountSuccess = FALSE;
   cmd2 = argcmd2;
   cmd3 = argcmd3;
   cmd5 = argcmd5;
   cmd7 = argcmd7;

   int xOffset = 10;
   int yOffset = 10;
   int minimumHeight;
   int minimumWidth = 600;
   int maximumWidth = 600;
   int QMLEHeight = 100;

   setCaption( name );

   QString tmpStr;
   tmpStr.sprintf( i18n( "I will now try to mount %s on %s \n"
      "using filesystem %s\nwith following options: %s\n\n"
      "This is the output:" ), ( const char * ) cmd2, ( const char * ) cmd3,
      ( const char * ) cmd5, ( const char * ) cmd7 );
   QLabel *subLabel = new QLabel( this );
   CHECK_PTR( subLabel );
   subLabel->setText( tmpStr );
   subLabel->setGeometry( xOffset, yOffset,
      subLabel->sizeHint().width(),
      subLabel->sizeHint().height() );
   minimumHeight = subLabel->sizeHint().height() + yOffset;

   QMLEmount = new QMultiLineEdit( this );
   CHECK_PTR( QMLEmount );
   QMLEmount->setGeometry( xOffset,
      minimumHeight + yOffset,
      maximumWidth - 2 * xOffset - QMLEmount->sizeHint().width(),
      QMLEmount->sizeHint().height() + QMLEHeight );
   QMLEmount->setReadOnly( TRUE );
   minimumHeight += yOffset + QMLEmount->sizeHint().height() + QMLEHeight;

   QPushButton * QPBtMount = new QPushButton( i18n( "&Start Testmount" ), this );
   connect( QPBtMount, SIGNAL( clicked()), this,
      SLOT( doTestMount()));
   QPBtMount->setDefault( TRUE );

   QPushButton *QPBpMount = new QPushButton( i18n( "&Mount permanently" ), this );
   connect( QPBpMount, SIGNAL( clicked()), this,
      SLOT( doPermanentMount()));

   QPushButton *QPBpUMount = new QPushButton( i18n( "&Unmount permanently" ), this );
   connect( QPBpUMount, SIGNAL( clicked()), this,
      SLOT( doPermanentUmount()));

   QPushButton *QPBexit = new QPushButton( i18n( "&Exit" ), this );
   CHECK_PTR( QPBexit );
   connect( QPBexit, SIGNAL( clicked()), SLOT( accept()) );

   QPBtMount->setGeometry( xOffset,
      minimumHeight + yOffset,
      QPBtMount->sizeHint().width(), QPBtMount->sizeHint().height() );
   QPBexit->setGeometry( minimumWidth - QPBtMount->sizeHint().width() - xOffset,
      minimumHeight + yOffset,
      QPBtMount->sizeHint().width(), QPBexit->sizeHint().height() );
   QPBpMount->setGeometry( minimumWidth / 2 - xOffset / 2 - QPBpUMount->sizeHint().width(),
      minimumHeight + yOffset,
      QPBpUMount->sizeHint().width(), QPBpMount->sizeHint().height() );
   QPBpUMount->setGeometry( minimumWidth / 2 + xOffset / 2,
      minimumHeight + yOffset,
      QPBpUMount->sizeHint().width(), QPBpUMount->sizeHint().height() );

   minimumHeight += yOffset + QPBexit->sizeHint().height();

   minimumHeight += yOffset;
   setMinimumSize( minimumWidth, minimumHeight );
   setMaximumSize( minimumWidth, minimumHeight );
//   setMaximumSize( maximumWidth, maximumHeight );
}

TestMount::~TestMount()
{
   if ( mountProc.isRunning() ) mountProc.kill();
   if ( mountSuccess == TRUE ) executeUmount();
   if ( mountProc.isRunning() ) mountProc.kill();
}

void TestMount::doPermanentMount()
{
   QMLEmount->clear();
   if ( mountSuccess == FALSE )
   {
   kapp->setOverrideCursor( waitCursor );
   executeMount();
   kapp->restoreOverrideCursor();

   if ( mountSuccess == FALSE )
      KMsgBox::message( this, i18n( "Warning" ),
         i18n( "Partition is not mountable" ), KMsgBox::EXCLAMATION );
   else {
      QMLEmount->insertLine( i18n( "Partition mounted successfully." ));
      KMsgBox::message( this, i18n( "Information" ),
         i18n( "Partition mounted successfully." ), KMsgBox::EXCLAMATION );
      }
   mountSuccess = FALSE;
   }
   else
      unstableCondition();
}

void TestMount::doPermanentUmount()
{
   QMLEmount->clear();
   if ( mountSuccess == FALSE )
   {
      kapp->setOverrideCursor( waitCursor );
      mountSuccess = TRUE;
      executeUmount();
      kapp->restoreOverrideCursor();
      if ( mountSuccess == TRUE )
         KMsgBox::message( this, i18n( "Warning" ),
            i18n( "Partition is not unmountable" ), KMsgBox::EXCLAMATION );
      else
      {
         QMLEmount->insertLine( i18n( "Partition unmounted successfully." ));
         KMsgBox::message( this, i18n( "Information" ),
            i18n( "Partition unmounted successfully." ), KMsgBox::EXCLAMATION );
      }
   mountSuccess = FALSE;
   }
   else
      unstableCondition();
}

void TestMount::doTestMount()
{
   QMLEmount->clear();
   if ( mountSuccess == FALSE )
   {
   kapp->setOverrideCursor( waitCursor );
   executeMount();
   kapp->restoreOverrideCursor();

   if ( mountSuccess == FALSE )
      KMsgBox::message( this, i18n( "Warning" ),
         i18n( "Partition is not mountable" ), KMsgBox::EXCLAMATION );
   else {
      kapp->setOverrideCursor( waitCursor );
      executeUmount();
      kapp->restoreOverrideCursor();
      if ( mountSuccess == TRUE )
         KMsgBox::message( this, i18n( "Warning" ),
            i18n( "Partition is not unmountable" ), KMsgBox::EXCLAMATION );
      else
      {
         QMLEmount->insertLine( i18n( "Partition testmount successful." ));
         KMsgBox::message( this, i18n( "Information" ),
            i18n( "Partition testmount successful" ), KMsgBox::EXCLAMATION );
      }
   }
   mountSuccess = FALSE;
   }
   else
      unstableCondition();
}

void TestMount::executeMount()
{
   mounting = TRUE;
   QMLEmount->insertLine( i18n( "Start to mount the partition" ));

   mountProc.clearArguments();
   mountProc << "/bin/mount" << "-v" << cmd2 << cmd3 << "-t" << cmd5 << "-o" << cmd7;
   connect( &mountProc, SIGNAL( processExited( KProcess * ) ),
      this, SLOT( slotProcessDead( KProcess * ) ));
   connect( &mountProc, SIGNAL( receivedStdout( KProcess *, char *, int)),
      this, SLOT(slotCmdStdout(KProcess *, char *, int)));
   connect( &mountProc, SIGNAL( receivedStderr( KProcess *, char *, int)),
      this, SLOT(slotCmdStdout(KProcess *, char *, int)));
// NotifyOnExit isnt good as we have to wait until it is finished
//   if( !mountProc.start( KProcess::NotifyOnExit, KProcess::AllOutput ))
   if( !mountProc.start( KProcess::Block, KProcess::AllOutput ))
      unstableCondition();
}

void TestMount::executeUmount()
{
   mounting = FALSE;
   QMLEmount->insertLine( i18n( "Start to unmount the partition" ));

   if ( mountSuccess == TRUE ) {
      mountProc.clearArguments();
      mountProc << "export lang=english;";
      mountProc.start( KProcess::Block, KProcess::AllOutput );
      mountProc.clearArguments();
      mountProc << "/bin/umount" << "-v" << cmd3;
      connect( &mountProc, SIGNAL( processExited( KProcess * ) ),
         this, SLOT( slotProcessDead( KProcess * ) ));
      connect( &mountProc, SIGNAL( receivedStdout( KProcess *, char *, int)),
         this, SLOT(slotCmdStdout(KProcess *, char *, int )));
      connect( &mountProc, SIGNAL( receivedStderr( KProcess *, char *, int)),
         this, SLOT(slotCmdStdout(KProcess *, char *, int )));
   // NotifyOnExit isnt good as we have to wait for the output to continue
   //   if( !mountProc.start( KProcess::NotifyOnExit, KProcess::AllOutput ))
      if( !mountProc.start( KProcess::Block, KProcess::AllOutput ))
         KMsgBox::message( this, i18n( "Error" ),
            i18n( "Could not start process" ), KMsgBox::STOP );
   }
}

void TestMount::slotProcessDead( KProcess *child )
{
   // disconnect KProcess
   disconnect( child, SIGNAL( receivedStderr( KProcess *, char *, int )),
      this, SLOT( slotCmdStdout( KProcess *, char *, int )));
   disconnect( child, SIGNAL( receivedStdout( KProcess *, char *, int )),
      this, SLOT( slotCmdStdout( KProcess *, char *, int )));
   disconnect( child, SIGNAL( processExited( KProcess * ) ),
      this, SLOT( slotProcessDead( KProcess * ) ) );
}

void TestMount::slotCmdStdout( KProcess *, char *buffer, int buflen )
{
   QString privBuffer;
   privBuffer = buffer;
   // As buffer doesnt contain a '\0' at the end we must shorten the string
   privBuffer.resize( buflen );
   if ( mounting == TRUE ) {
      if ( ( strstr( privBuffer, "already mounted" )) ||
         ( strstr( privBuffer, "busy" )) ||
         ( strstr( privBuffer, "not recognize" )) ||
         ( strstr( privBuffer, "only root can do that" )) ||
         ( strstr( privBuffer, "timed out" )) ||
         ( strstr( privBuffer, "kernel does not recognize" )) ||
         ( strstr( privBuffer, "I/O error" )) ||
         ( strstr( privBuffer, "Segmentation fault" )) ||
         ( strstr( privBuffer, "wrong fs type" )) ||
         ( strstr( privBuffer, "bad superblock" )) ||
         ( strstr( privBuffer, "too many mounted file systems" )) ||
         ( strstr( privBuffer, "not supported by kernel" )) ||
         ( strstr( privBuffer, "you didn't specify a filesystem type" )) ||
         ( strstr( privBuffer, "does not exist" )) ||
         ( strstr( privBuffer, "directory to mount not in" )) ||
         ( strstr( privBuffer, "not a valid block device" ))
         )
         {
            mountSuccess = FALSE;
            QMLEmount->insertLine( i18n( "Partition not mounted.\n"
               "This is mounts output:" ));
            if ( strstr( privBuffer, "is already mounted on" ))
               checkMount = TRUE;
         }
      else mountSuccess = TRUE;
   }
   else // mounting == FALSE
   {
      if ( ( strstr( privBuffer, "not mounted" )) ||
         ( strstr( privBuffer, "only root can unmount" )) ||
         ( strstr( privBuffer, "device is busy" )) ||
         ( strstr( privBuffer, "timed out" )) ||
         ( strstr( privBuffer, "I/O error" )) ||
         ( strstr( privBuffer, "Segmentation fault" ))
         )
         {
            mountSuccess = TRUE;
            QMLEmount->insertLine( i18n( "Partition cannot be unmounted.\n"
               "This is umounts output:" ));
         }
      else mountSuccess = FALSE;
   }
   QMLEmount->insertLine( privBuffer );
}

void TestMount::unstableCondition()
{
   KMsgBox::message( this, i18n( "Error" ),
      i18n( "Unstable condition: It seems that a mount Process is "
         "running.\nThat should never happen." ), KMsgBox::EXCLAMATION );
}

#include <testmount.moc>
