/*****************************************************************************
 * This software is distributed under the terms of the General Public License.
 *
 * Program : kfstab
 * Authors : Andreas Reuter
 * E-Mail  : holtwick@uni-duisburg.de
 *           Andreas.Reuter@munich.netsurf.de
*****************************************************************************/

// KDE Header Files
#include <kapp.h>
#include <kbuttonbox.h>

// Application Header Files
#include "optpref.h"

/**
 * Constructor
 * Draws the widget, checks which options are activated and which 
 * can be activated
 */
 
OptPreferences::OptPreferences( QString optStr, QWidget *parent,
   QString name ) :
      KDialog( parent, name, TRUE /* == Modal Dialog */ )
{
   const int yOff = 15;
   const int xOff = 10;
   int optQCBHeight;
   int numQCB = 0;

   setCaption( name );

   QCBdefaults = new QCheckBox( this, "defaults" );
   CHECK_PTR( QCBdefaults );
   QCBdefaults->setText( "&defaults" ); // translation senseless
   optQCBHeight = QCBdefaults->sizeHint().height();
   QCBdefaults->setGeometry( xOff, yOff, 
      QCBdefaults->sizeHint().width(), optQCBHeight );
   numQCB++;

   QCBrw = new QCheckBox( this, "rw" );
   CHECK_PTR( QCBrw );
   QCBrw->setText( i18n( "&rw enabled - otherwise ro" ));
   QCBrw->setGeometry( xOff, yOff + numQCB * optQCBHeight, 
      QCBrw->sizeHint().width(), optQCBHeight );
   numQCB++;

   QCBnoauto = new QCheckBox( this, "noauto" );
   CHECK_PTR( QCBnoauto );
   QCBnoauto->setText( "&noauto" ); // translation senseless
   QCBnoauto->setGeometry( xOff, yOff + numQCB * optQCBHeight, 
      QCBnoauto->sizeHint().width(), optQCBHeight );
   numQCB++;

   QCBuser = new QCheckBox( this, "user" );
   CHECK_PTR( QCBuser );
   QCBuser->setText( "&user" ); // translation senseless
   QCBuser->setGeometry( xOff, yOff + numQCB * optQCBHeight, 
      QCBuser->sizeHint().width(), optQCBHeight );
   numQCB++;
   
   QCBexec = new QCheckBox( this, "exec" );
   CHECK_PTR( QCBexec );
   QCBexec->setText( "&exec" );
   QCBexec->setGeometry( xOff, yOff + numQCB * optQCBHeight,
      QCBexec->sizeHint().width(), optQCBHeight );
   numQCB++;
   
   QCBsuid = new QCheckBox( this, "suid" );
   CHECK_PTR( QCBsuid );
   QCBsuid->setText( "&suid" );
   QCBsuid->setGeometry( xOff, yOff + numQCB * optQCBHeight,
      QCBsuid->sizeHint().width(), optQCBHeight );
   numQCB++;

   QCBdev = new QCheckBox( this, "dev" );
   CHECK_PTR( QCBdev );
   QCBdev->setText( "de&v" );
   QCBdev->setGeometry( xOff, yOff + numQCB * optQCBHeight,
      QCBdev->sizeHint().width(), optQCBHeight );
   numQCB++;

   QCBsync = new QCheckBox( this, "sync" );
   CHECK_PTR( QCBsync );
   QCBsync->setText( "s&ync" );
   QCBsync->setGeometry( xOff, yOff + numQCB * optQCBHeight,
      QCBsync->sizeHint().width(), optQCBHeight );
   numQCB++;

   QPBapply = new QPushButton( i18n( "&Apply" ), this );
   CHECK_PTR( QPBapply );
   QPBapply->setGeometry( ( int ) xOff, yOff + ( numQCB + 1 ) * optQCBHeight,
      QPBapply->sizeHint().width(), QPBapply->sizeHint().height() );

   QPBcancel = new QPushButton( i18n( "&Cancel" ), this );
   CHECK_PTR( QPBcancel );
   QPBcancel->setDefault( TRUE );
   // Now we calculate width of this widget
   int xSize;
   xSize = 3 * xOff + QPBapply->sizeHint().width() + QPBcancel->sizeHint().width();
   if ( ( QCBrw->sizeHint().width() + 2 * xOff ) > xSize )
      xSize = QCBrw->sizeHint().width() + 2 * xOff;
   QPBcancel->setGeometry(
      xSize - ( QPBcancel->sizeHint().width() + xOff ),
      yOff + (numQCB + 1) * optQCBHeight,
      QPBcancel->sizeHint().width(), QPBcancel->sizeHint().height() );
   setMinimumSize( xSize,
      2 * yOff + ( numQCB + 1 ) * optQCBHeight +
         QPBcancel->sizeHint().height() );
   setMaximumSize( xSize,
      2 * yOff + ( numQCB + 1 ) * optQCBHeight +
         QPBcancel->sizeHint().height() );

   if ( strstr( optStr, "defaults" ) )
      QCBdefaults->setChecked( TRUE );
   if ( strstr( optStr, "rw" ) )
      QCBrw->setChecked( TRUE );
   if ( strstr( optStr, "noauto" ) )
      QCBnoauto->setChecked( TRUE );
   if ( strstr( optStr, "user" ) )
      QCBuser->setChecked( TRUE );
   if ( strstr( optStr, "exec" ) )
      QCBexec->setChecked( TRUE );
   if ( strstr( optStr, "suid" ) )
      QCBsuid->setChecked( TRUE );
   if ( strstr( optStr, "dev" ) )
      QCBdev->setChecked( TRUE );
   if ( strstr( optStr, "sync" ) )
      QCBsync->setChecked( TRUE );

   connect( QCBdefaults, SIGNAL( clicked()), SLOT( defaultsClicked()) );
   defaultsClicked(); // set CheckBoxes to actual settings
   connect( QPBapply, SIGNAL( clicked()), SLOT( optAccept()) );
   connect( QPBcancel, SIGNAL( clicked()), SLOT( reject()) );
}

/**
 * Is called when defaults Checkbox is clicked
 * if its activated other options are disabled
 * if its deactivated other options are enabled
 */
 
void OptPreferences::defaultsClicked()
{
  if ( QCBdefaults->isChecked() ) {
     QCBrw->setEnabled( FALSE );
     QCBnoauto->setEnabled( FALSE );
     QCBuser->setEnabled( FALSE );
     QCBexec->setEnabled( FALSE );
     QCBsuid->setEnabled( FALSE );
     QCBdev->setEnabled( FALSE );
     QCBsync->setEnabled( FALSE );
  }
  else {
     QCBrw->setEnabled( TRUE );
     QCBnoauto->setEnabled( TRUE );
     QCBuser->setEnabled( TRUE );
     QCBexec->setEnabled( TRUE );
     QCBsuid->setEnabled( TRUE );
     QCBdev->setEnabled( TRUE );
     QCBsync->setEnabled( TRUE );
  }
}

/**
 * is called when the selected options are accepted
 * if defaults is activated its the only option,
 * otherwise the selected options are scanned and send to the input field
 */
 
void OptPreferences::optAccept()
{
   QString tmpStr;
   if ( QCBdefaults->isChecked() )
      tmpStr = "defaults";
   else	{				// defaults can only be alone
      if ( QCBrw->isChecked() )
         tmpStr = "rw";
      else
         tmpStr = "ro";
      if ( QCBnoauto->isChecked() )
         tmpStr += ",noauto";
      if ( QCBuser->isChecked() )
         tmpStr += ",user";
      if ( QCBexec->isChecked() )
         tmpStr += ",exec";
      if ( QCBsuid->isChecked() )
         tmpStr += ",suid";
      if ( QCBdev->isChecked() )
         tmpStr += ",dev";
      if ( QCBsync->isChecked() )
         tmpStr += ",sync";
   }
   emit newOptions( tmpStr ); // send new options back
   emit accept(); // close dialog
}

#include "optpref.moc"
